/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.GoToHashOrRefPopup;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoToHashOrRefAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        final VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        final VcsLogUiImpl logUi = (VcsLogUiImpl)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project2 == null || log == null || logUi == null) {
            return;
        }
        GoToHashOrRefPopup popup = new GoToHashOrRefPopup(project2, VcsLogUtil.getVisibleBranches(log, logUi), new Function<String, Future>(){

            public Future fun(String text) {
                return log.jumpToReference(text);
            }
        }, new Function<VcsRef, Future>(){

            public Future fun(VcsRef vcsRef) {
                return logUi.jumpToCommit(vcsRef.getCommitHash(), vcsRef.getRoot());
            }
        }, logUi.getColorManager(), new VcsRefComparator(logUi.getDataPack().getLogProviders()));
        popup.show((JComponent)((Object)logUi.getTable()));
    }

    public void update(AnActionEvent e) {
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log != null && logUi != null);
    }

    private static class VcsRefComparator
    implements Comparator<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myProviders;

        public VcsRefComparator(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
            if (providers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/ui/actions/GoToHashOrRefAction$VcsRefComparator", "<init>"));
            }
            this.myProviders = providers;
        }

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            if (ref1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref1", "com/intellij/vcs/log/ui/actions/GoToHashOrRefAction$VcsRefComparator", "compare"));
            }
            if (ref2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref2", "com/intellij/vcs/log/ui/actions/GoToHashOrRefAction$VcsRefComparator", "compare"));
            }
            VcsLogProvider provider1 = this.myProviders.get(ref1.getRoot());
            VcsLogProvider provider2 = this.myProviders.get(ref1.getRoot());
            if (provider1 == null) {
                return provider2 == null ? ref1.getName().compareTo(ref2.getName()) : 1;
            }
            if (provider2 == null) {
                return -1;
            }
            if (provider1 == provider2) {
                return provider1.getReferenceManager().getLabelsOrderComparator().compare(ref1, ref2);
            }
            return provider1.getSupportedVcs().getName().compareTo(provider2.getSupportedVcs().getName());
        }
    }
}

