/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class GraphAction
extends DumbAwareAction {
    public GraphAction(@NotNull String text, @NotNull String description, @NotNull Icon icon) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/actions/GraphAction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/vcs/log/ui/actions/GraphAction", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/vcs/log/ui/actions/GraphAction", "<init>"));
        }
        super(text, description, icon);
    }

    private static boolean areGraphActionsEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/GraphAction", "areGraphActionsEnabled"));
        }
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui == null) {
            return false;
        }
        return ui.areGraphActionsEnabled();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/GraphAction", "update"));
        }
        boolean graphActionsEnabled = GraphAction.areGraphActionsEnabled(e);
        e.getPresentation().setEnabled(graphActionsEnabled);
        if (graphActionsEnabled) {
            this.update((VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI), e);
        }
    }

    protected abstract void update(@NotNull VcsLogUi var1, @NotNull AnActionEvent var2);
}

