/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.Function;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

class MultilinePopupBuilder {
    private static final char[] SEPARATORS = new char[]{',', '|', '\n'};
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project2, @NotNull Collection<String> values, @NotNull String initialValue, boolean supportsNegativeValues) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        this.myTextField = MultilinePopupBuilder.createTextField(project2, values, supportsNegativeValues, initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project2, Collection<String> values, boolean supportsNegativeValues, @NotNull String initialValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        LanguageTextField textField = new LanguageTextField(FileTypes.PLAIN_TEXT.getLanguage(), project2, initialValue){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                SoftWrapsEditorCustomization.ENABLED.customize(editor);
                EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
                if (disableSpellChecking != null) {
                    disableSpellChecking.customize(editor);
                }
                editor.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, true);
                return editor;
            }
        };
        new MyCompletionProvider(values, supportsNegativeValues).apply(textField);
        textField.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), textField.getBorder()));
        textField.setOneLineMode(false);
        LanguageTextField languageTextField = textField;
        if (languageTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        return languageTextField;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.myTextField), "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)((Object)this.myTextField)).setCancelOnClickOutside(true).setAdText(KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize(new Dimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$2", "actionPerformed"));
                }
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup.getContent());
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createPopup"));
        }
        return jBPopup;
    }

    @NotNull
    Collection<String> getSelectedValues() {
        List list = ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), (Function)new Function<String, String>(){

            public String fun(String value) {
                String trimmed = value.trim();
                return trimmed.isEmpty() ? null : trimmed;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "getSelectedValues"));
        }
        return list;
    }

    private static class MyCompletionProvider
    extends TextFieldCompletionProviderDumbAware {
        @NotNull
        private final Collection<String> myValues;
        private final boolean mySupportsNegativeValues;

        MyCompletionProvider(@NotNull Collection<String> values, boolean supportsNegativeValues) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "<init>"));
            }
            super(true);
            this.myValues = values;
            this.mySupportsNegativeValues = supportsNegativeValues;
        }

        @Override
        @NotNull
        protected String getPrefix(@NotNull String currentTextPrefix) {
            if (currentTextPrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "getPrefix"));
            }
            int separatorPosition = MyCompletionProvider.lastSeparatorPosition(currentTextPrefix);
            String prefix = separatorPosition == -1 ? currentTextPrefix : currentTextPrefix.substring(separatorPosition + 1).trim();
            String string = this.mySupportsNegativeValues && prefix.startsWith("-") ? prefix.substring(1) : prefix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "getPrefix"));
            }
            return string;
        }

        private static int lastSeparatorPosition(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "lastSeparatorPosition"));
            }
            int lastPosition = -1;
            for (char separator : SEPARATORS) {
                int lio = text.lastIndexOf(separator);
                if (lio <= lastPosition) continue;
                lastPosition = lio;
            }
            return lastPosition;
        }

        @Override
        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            result.addLookupAdvertisement("Select one or more users separated with comma, | or new lines");
            for (String completionVariant : this.myValues) {
                LookupElementBuilder element = LookupElementBuilder.create((String)completionVariant);
                result.addElement((LookupElement)element.withLookupString(completionVariant.toLowerCase()));
            }
        }
    }
}

