/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFileFilter;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FilterModel<VcsLogFileFilter> myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        this.myUi = ui;
        this.myLogDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable<VcsLogDataPack> dataPackGetter = new NotNullComputable<VcsLogDataPack>(){

            @NotNull
            public VcsLogDataPack compute() {
                VcsLogDataPack vcsLogDataPack = VcsLogClassicFilterUi.this.myDataPack;
                if (vcsLogDataPack == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$1", "compute"));
                }
                return vcsLogDataPack;
            }
        };
        this.myBranchFilterModel = new BranchFilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myUserFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myDateFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myStructureFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myTextFilterModel = new TextFilterModel(dataPackGetter);
        this.updateUiOnFilterChange();
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(new Runnable(){

                @Override
                public void run() {
                    VcsLogClassicFilterUi.this.myUi.applyFiltersAndUpdateUi();
                    VcsLogClassicFilterUi.this.myBranchFilterModel.onStructureFilterChanged(new HashSet<VirtualFile>(VcsLogClassicFilterUi.this.myLogDataHolder.getRoots()), (VcsLogFileFilter)VcsLogClassicFilterUi.this.myStructureFilterModel.getFilter());
                }
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new TextFilterComponent(this.myTextFilterModel));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new BranchFilterPopupComponent(VcsLogClassicFilterUi.this.myUi, VcsLogClassicFilterUi.this.myUiProperties, VcsLogClassicFilterUi.this.myBranchFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new UserFilterPopupComponent(VcsLogClassicFilterUi.this.myUiProperties, VcsLogClassicFilterUi.this.myLogDataHolder, VcsLogClassicFilterUi.this.myUserFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new DateFilterPopupComponent(VcsLogClassicFilterUi.this.myDateFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new StructureFilterPopupComponent(VcsLogClassicFilterUi.this.myStructureFilterModel, VcsLogClassicFilterUi.this.myUi.getColorManager()).initUi();
            }
        }));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "createActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea((VcsLogTextFilter)this.myTextFilterModel.getFilter());
        VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl((VcsLogBranchFilter)this.myBranchFilterModel.getFilter(), this.myUserFilterModel.getFilter(), (VcsLogHashFilter)filtersFromText.second, this.myDateFilterModel.getFilter(), (VcsLogTextFilter)filtersFromText.first, this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getStructureFilter(), this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getRootFilter());
        if (vcsLogFilterCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFilters"));
        }
        return vcsLogFilterCollectionImpl;
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@Nullable VcsLogTextFilter filter) {
        VcsLogHashFilterImpl hashFilter;
        VcsLogTextFilterImpl textFilter;
        String word;
        if (filter == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
            }
            return pair;
        }
        String text = filter.getText().trim();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
            }
            return pair;
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        Iterator iterator = StringUtil.split((String)text, (String)" ").iterator();
        while (iterator.hasNext() && !StringUtil.isEmptyOrSpaces((String)(word = (String)iterator.next())) && word.matches(HASH_PATTERN)) {
            hashes.add(word);
        }
        if (!hashes.isEmpty()) {
            textFilter = null;
            hashFilter = new VcsLogHashFilterImpl(hashes);
        } else {
            textFilter = new VcsLogTextFilterImpl(text);
            hashFilter = null;
        }
        Pair pair = Pair.create((Object)textFilter, (Object)hashFilter);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
        }
        return pair;
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "setFilter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setFilter((VcsLogBranchFilter)filter);
            JComponent toolbar = this.myUi.getToolbar();
            toolbar.revalidate();
            toolbar.repaint();
        }
    }

    @NotNull
    public VcsLogUi getLogUi() {
        VcsLogUiImpl vcsLogUiImpl = this.myUi;
        if (vcsLogUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getLogUi"));
        }
        return vcsLogUiImpl;
    }

    private static class TextFilterModel
    extends FilterModel<VcsLogTextFilter> {
        @Nullable
        private String myText;

        public TextFilterModel(NotNullComputable<VcsLogDataPack> dataPackProvider) {
            super((Computable<VcsLogDataPack>)dataPackProvider);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                String string = this.myText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
                }
                return string;
            }
            if (this.getFilter() != null) {
                String string = ((VcsLogTextFilter)this.getFilter()).getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "setUnsavedText"));
            }
            this.myText = text;
        }

        @Override
        void setFilter(@Nullable VcsLogTextFilter filter) {
            super.setFilter(filter);
            this.myText = null;
        }
    }

    public static class BranchFilterModel
    extends FilterModel<VcsLogBranchFilter> {
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<VcsLogDataPack> provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "<init>"));
            }
            super(provider);
        }

        public void onStructureFilterChanged(@NotNull Set<VirtualFile> roots, @Nullable VcsLogFileFilter filter) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "onStructureFilterChanged"));
            }
            this.myVisibleRoots = filter == null ? null : VcsLogUtil.getAllVisibleRoots(roots, filter.getRootFilter(), filter.getStructureFilter());
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Computable<JComponent> componentCreator) {
            if (componentCreator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentCreator", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent", "<init>"));
            }
            this.myComponentCreator = componentCreator;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent", "actionPerformed"));
            }
        }
    }

    private static class TextFilterComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
        private final TextFilterModel myFilterModel;

        public TextFilterComponent(TextFilterModel filterModel) {
            this.myFilterModel = filterModel;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JPanel panel = new JPanel();
            JLabel filterCaption = new JLabel("Filter:");
            filterCaption.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
            panel.add(filterCaption);
            panel.add(this.createSearchField());
            return panel;
        }

        private Component createSearchField() {
            final SearchTextFieldWithStoredHistory textFilter = new SearchTextFieldWithStoredHistory(VCS_LOG_TEXT_FILTER_HISTORY){

                protected void onFieldCleared() {
                    TextFilterComponent.this.myFilterModel.setFilter((VcsLogTextFilter)null);
                }
            };
            textFilter.setText(this.myFilterModel.getText());
            textFilter.getTextEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterComponent$2", "actionPerformed"));
                    }
                    TextFilterComponent.this.myFilterModel.setFilter(new VcsLogTextFilterImpl(textFilter.getText()));
                    textFilter.addCurrentTextToHistory();
                }
            });
            textFilter.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    try {
                        TextFilterComponent.this.myFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            });
            return textFilter;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterComponent", "actionPerformed"));
            }
        }
    }
}

