/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType<?, ?>> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            XBreakpointType<?, ?>[] types = XBreakpointUtil.getBreakpointTypes();
            ArrayList<XLineBreakpointType> lineBreakpointTypes = new ArrayList<XLineBreakpointType>();
            for (XBreakpointType<?, ?> type : types) {
                if (!(type instanceof XLineBreakpointType)) continue;
                lineBreakpointTypes.add((XLineBreakpointType)type);
            }
            this.myLineBreakpointTypes = lineBreakpointTypes.toArray(new XLineBreakpointType[lineBreakpointTypes.size()]);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project2, @NotNull VirtualFile file2, int line, boolean temporary) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file2, line, project2) || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type;
        }
        if (typeWinner != null) {
            this.toggleLineBreakpoint(project2, typeWinner, file2, line, temporary);
        }
    }

    public boolean canPutBreakpointAt(@NotNull Project project2, @NotNull VirtualFile file2, int line) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file2, line, project2)) continue;
            return true;
        }
        return false;
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project2, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line, boolean temporary) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XSourcePositionImpl position = XSourcePositionImpl.create(file2, line);
        if (position != null) {
            XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project2, type, position, temporary, null);
        }
    }

    @NotNull
    public static <P extends XBreakpointProperties> Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(final @NotNull Project project2, final @NotNull XLineBreakpointType<P> type, final @NotNull XSourcePosition position, final boolean temporary, final @Nullable Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        Promise promise2 = (Promise)new WriteAction<Promise<XLineBreakpoint>>(){

            /*
             * Exception decompiling
             */
            protected void run(@NotNull Result<Promise<XLineBreakpoint>> result) throws Throwable {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.execute().getResultObject();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        return promise2;
    }

    public void removeBreakpoint(final Project project2, final XBreakpoint<?> breakpoint) {
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$2", "run"));
                }
                XDebuggerManager.getInstance((Project)project2).getBreakpointManager().removeBreakpoint(breakpoint);
            }
        }.execute();
    }

    public <B extends XBreakpoint<?>> XBreakpointType<B, ?> findBreakpointType(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeClass", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findBreakpointType"));
        }
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = new THashMap();
            for (XBreakpointType<?, ?> breakpointType : XBreakpointUtil.getBreakpointTypes()) {
                this.myBreakpointTypeByClass.put(breakpointType.getClass(), breakpointType);
            }
        }
        XBreakpointType<?, ?> type = this.myBreakpointTypeByClass.get(typeClass);
        return type;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingManagerImpl.getInstanceImpl().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line) {
        return XSourcePositionImpl.create(file2, line);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line, int column) {
        return XSourcePositionImpl.create(file2, line, column);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file2, int offset) {
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @Nullable
    public XSourcePosition createPositionByElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        final VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePosition(){
            private volatile XSourcePosition myDelegate;

            private XSourcePosition getDelegate() {
                if (this.myDelegate == null) {
                    this.myDelegate = (XSourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XSourcePosition>(){

                        public XSourcePosition compute() {
                            PsiElement elem = pointer.getElement();
                            return XSourcePositionImpl.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                        }
                    });
                }
                return this.myDelegate;
            }

            public int getLine() {
                return this.getDelegate().getLine();
            }

            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            @NotNull
            public VirtualFile getFile() {
                VirtualFile virtualFile = file2;
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "getFile"));
                }
                return virtualFile;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                }
                if (this.myDelegate != null) {
                    Navigatable navigatable = this.myDelegate.createNavigatable(project2);
                    if (navigatable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                    }
                    return navigatable;
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    Navigatable navigatable = (Navigatable)elem;
                    if (navigatable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                    }
                    return navigatable;
                }
                Navigatable navigatable = NonNavigatable.INSTANCE;
                if (navigatable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                }
                return navigatable;
            }
        };
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getCaretPosition"));
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @NotNull
    public static Collection<XSourcePosition> getAllCaretsPositions(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            List<XSourcePosition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
            }
            return list;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        SmartList res = new SmartList();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            XSourcePositionImpl position = XSourcePositionImpl.createByOffset(file2, caret.getOffset());
            if (position == null) continue;
            res.add(position);
        }
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
        }
        return smartList;
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getEditor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(final XBreakpointType<B, ?> type) {
        return new Comparator<B>(){

            @Override
            public int compare(B o1, B o2) {
                return type.getDisplayText(o1).compareTo(type.getDisplayText(o2));
            }
        };
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return new Comparator<XLineBreakpoint<P>>(){

            @Override
            public int compare(XLineBreakpoint<P> o1, XLineBreakpoint<P> o2) {
                int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
                if (fileCompare != 0) {
                    return fileCompare;
                }
                return o1.getLine() - o2.getLine();
            }
        };
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project2, @NotNull Document document, int line, @NotNull Processor<PsiElement> processor2) {
        int lineEnd;
        int lineStart;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        int offset = lineStart;
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        while (offset < lineEnd) {
            PsiElement element = file2.findElementAt(offset);
            if (element != null) {
                if (!processor2.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project2, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file2;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file2 = document == null ? null : PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (file2 == null) {
            return null;
        }
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        PsiElement result = null;
        do {
            if ((element = file2.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result == null) {
            result = file2.findElementAt(startOffset);
        }
        if (checkXml && result != null && StdFileTypes.XML.getLanguage().equals(result.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result, PsiLanguageInjectionHost.class)) != null) {
            result = InjectedLanguageUtil.findElementInInjected(parent, offset);
        }
        return result;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "disableValueLookup"));
        }
        ValueLookupManager.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createEditor"));
        }
        return descriptor.canNavigate() ? FileEditorManager.getInstance((Project)descriptor.getProject()).openTextEditor(descriptor, false) : null;
    }

    public static void rebuildAllSessionsViews(@Nullable Project project2) {
        if (project2 == null) {
            return;
        }
        for (XDebugSession session : XDebuggerManager.getInstance((Project)project2).getDebugSessions()) {
            if (!session.isSuspended()) continue;
            session.rebuildViews();
        }
    }

    @NotNull
    public XExpression createExpression(@NotNull String text, Language language, String custom, EvaluationMode mode) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createExpression"));
        }
        XExpressionImpl xExpressionImpl = new XExpressionImpl(text, language, custom, mode);
        if (xExpressionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createExpression"));
        }
        return xExpressionImpl;
    }

    public static boolean isEmptyExpression(@Nullable XExpression expression) {
        return expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression());
    }
}

