/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.ui.BreakpointEditor;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(final JCheckBox checkbox, final JComponent textfield) {
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = checkbox.isSelected();
                textfield.setEnabled(selected);
            }
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(final JCheckBox checkbox, final JComponent component) {
        final Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        };
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checkbox.isSelected()) {
                    SwingUtilities.invokeLater(runnable2);
                }
            }
        });
    }

    public static void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    @Deprecated
    public static RelativePoint calcPopupLocation(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "calcPopupLocation"));
        }
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(p)) {
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    @Nullable
    public static RelativePoint getPositionForPopup(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getPositionForPopup"));
        }
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        return editor.getScrollingModel().getVisibleArea().contains(p) ? new RelativePoint((Component)editor.getContentComponent(), p) : null;
    }

    public static void showPopupForEditorLine(@NotNull JBPopup popup, @NotNull Editor editor, int line) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showPopupForEditorLine"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showPopupForEditorLine"));
        }
        RelativePoint point = DebuggerUIUtil.getPositionForPopup(editor, line);
        if (point != null) {
            popup.show(point);
        } else {
            Project project2 = editor.getProject();
            if (project2 != null) {
                popup.showCenteredInCurrentWindow(project2);
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project2, @Nullable Editor editor) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        TextViewer textArea = new TextViewer("Evaluating...", project2);
        textArea.setBackground(HintUtil.INFORMATION_COLOR);
        FullValueEvaluationCallbackImpl callback = new FullValueEvaluationCallbackImpl(textArea);
        evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
        Dimension size = DimensionService.getInstance().getSize(FULL_VALUE_POPUP_DIMENSION_KEY, project2);
        if (size == null) {
            Dimension frameSize = WindowManager.getInstance().getFrame(project2).getSize();
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        textArea.setPreferredSize(size);
        JBPopup popup = DebuggerUIUtil.createValuePopup(project2, (JComponent)((Object)textArea), callback);
        if (editor == null) {
            Rectangle bounds = new Rectangle(event.getLocationOnScreen(), size);
            ScreenUtil.fitToScreenVertical((Rectangle)bounds, (int)5, (int)5, (boolean)true);
            if (size.width != bounds.width || size.height != bounds.height) {
                size = bounds.getSize();
                textArea.setPreferredSize(size);
            }
            popup.showInScreenCoordinates(event.getComponent(), bounds.getLocation());
        } else {
            popup.showInBestPositionFor(editor);
        }
    }

    public static JBPopup createValuePopup(Project project2, JComponent component, final @Nullable FullValueEvaluationCallbackImpl callback) {
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null);
        builder.setResizable(true).setMovable(true).setDimensionServiceKey(project2, FULL_VALUE_POPUP_DIMENSION_KEY, false).setRequestFocus(false);
        if (callback != null) {
            builder.setCancelCallback((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    callback.setObsolete();
                    return true;
                }
            });
        }
        return builder.createPopup();
    }

    public static void showXBreakpointEditorBalloon(final Project project2, final @Nullable Point point, final JComponent component, boolean showAllOptions, final XBreakpoint breakpoint) {
        final XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        final XLightBreakpointPropertiesPanel<XBreakpointBase> propertiesPanel = new XLightBreakpointPropertiesPanel<XBreakpointBase>(project2, breakpointManager, (XBreakpointBase)breakpoint, showAllOptions);
        final Ref balloonRef = Ref.create(null);
        final Ref isLoading = Ref.create((Object)Boolean.FALSE);
        final Ref moreOptionsRequested = Ref.create((Object)Boolean.FALSE);
        propertiesPanel.setDelegate(new XLightBreakpointPropertiesPanel.Delegate(){

            @Override
            public void showMoreOptions() {
                if (!((Boolean)isLoading.get()).booleanValue()) {
                    propertiesPanel.saveProperties();
                }
                if (!balloonRef.isNull()) {
                    ((Balloon)balloonRef.get()).hide();
                }
                DebuggerUIUtil.showXBreakpointEditorBalloon(project2, point, component, true, breakpoint);
                moreOptionsRequested.set((Object)true);
            }
        });
        isLoading.set((Object)Boolean.TRUE);
        propertiesPanel.loadProperties();
        isLoading.set((Object)Boolean.FALSE);
        if (((Boolean)moreOptionsRequested.get()).booleanValue()) {
            return;
        }
        Runnable showMoreOptions = new Runnable(){

            @Override
            public void run() {
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
                BreakpointsDialogFactory.getInstance(project2).showDialog(breakpoint);
            }
        };
        final JPanel mainPanel = propertiesPanel.getMainPanel();
        final Balloon balloon = DebuggerUIUtil.showBreakpointEditor(project2, mainPanel, point, component, showMoreOptions, breakpoint);
        balloonRef.set((Object)balloon);
        XBreakpointAdapter breakpointListener = new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> removedBreakpoint) {
                if (removedBreakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBreakpoint", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$7", "breakpointRemoved"));
                }
                if (removedBreakpoint.equals((Object)breakpoint)) {
                    balloon.hide();
                }
            }
        };
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter((XBreakpointListener)breakpointListener){
            final /* synthetic */ XBreakpointListener val$breakpointListener;
            {
                this.val$breakpointListener = xBreakpointListener;
            }

            public void onClosed(LightweightWindowEvent event) {
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
                breakpointManager.removeBreakpointListener(this.val$breakpointListener);
            }
        });
        breakpointManager.addBreakpointListener((XBreakpointListener)breakpointListener);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.findInstance().requestFocus((Component)mainPanel, true);
            }
        });
    }

    public static Balloon showBreakpointEditor(Project project2, JComponent mainPanel, Point whereToShow, final JComponent component, final @Nullable Runnable showMoreOptions, Object breakpoint) {
        BreakpointEditor editor = new BreakpointEditor();
        editor.setPropertiesPanel(mainPanel);
        editor.setShowMoreOptionsLink(true);
        JPanel panel = editor.getMainPanel();
        final Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel, null).setHideOnClickOutside(true).setCloseButtonEnabled(false).setAnimationCycle(0).setBlockClicksThroughBalloon(true).createBalloon();
        editor.setDelegate(new BreakpointEditor.Delegate(){

            @Override
            public void done() {
                balloon.hide();
            }

            @Override
            public void more() {
                assert (showMoreOptions != null);
                balloon.hide();
                showMoreOptions.run();
            }
        });
        final ComponentAdapter moveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                balloon.hide();
            }
        };
        component.addComponentListener(moveListener);
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                component.removeComponentListener(moveListener);
            }
        });
        if (whereToShow == null) {
            balloon.showInCenterOf(component);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            RelativePoint p = new RelativePoint((Component)component, whereToShow);
            if (window != null) {
                RelativePoint point = new RelativePoint((Component)window, new Point(0, 0));
                if (p.getScreenPoint().getX() - point.getScreenPoint().getX() < 40.0) {
                    p.getPoint().x += 40;
                }
            }
            balloon.show(p, Balloon.Position.below);
        }
        BreakpointsDialogFactory.getInstance(project2).setBalloonToHide(balloon, breakpoint);
        return balloon;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForComponent((JComponent)component);
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    @Nullable
    public static String getNodeRawValue(@NotNull XValueNodeImpl valueNode) {
        if (valueNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueNode", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getNodeRawValue"));
        }
        if (valueNode.getValueContainer() instanceof XValueTextProvider) {
            return ((XValueTextProvider)valueNode.getValueContainer()).getValueText();
        }
        return valueNode.getRawValue();
    }

    public static boolean hasEvaluationExpression(@NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "hasEvaluationExpression"));
        }
        Promise promise2 = value.calculateEvaluationExpression();
        if (promise2.getState() == Promise.State.PENDING) {
            return true;
        }
        if (promise2 instanceof Getter) {
            return ((Getter)promise2).get() != null;
        }
        return true;
    }

    public static void registerExtraHandleShortcuts(final ListPopupImpl popup, String ... actionNames) {
        for (String name : actionNames) {
            KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(name).getShortcutSet());
            if (stroke == null) continue;
            popup.registerAction("handleSelection " + stroke, stroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popup.handleSelect(true);
                }
            });
        }
    }

    public static String getSelectionShortcutsAdText(String ... actionNames) {
        StringBuilder res = new StringBuilder();
        for (String name : actionNames) {
            KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(name).getShortcutSet());
            if (stroke == null) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(KeymapUtil.getKeystrokeText((KeyStroke)stroke));
        }
        return XDebuggerBundle.message((String)"ad.extra.selection.shortcut", (Object[])new Object[]{res.toString()});
    }

    public static boolean isObsolete(Object object) {
        return object instanceof Obsolescent && ((Obsolescent)object).isObsolete();
    }

    private static class FullValueEvaluationCallbackImpl
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final AtomicBoolean myObsolete = new AtomicBoolean(false);
        private final EditorTextField myTextArea;

        public FullValueEvaluationCallbackImpl(EditorTextField textArea) {
            this.myTextArea = textArea;
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "evaluated"));
            }
            this.evaluated(fullValue, null);
        }

        public void evaluated(final @NotNull String fullValue, final @Nullable Font font) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "evaluated"));
            }
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(fullValue);
                    if (font != null) {
                        FullValueEvaluationCallbackImpl.this.myTextArea.setFont(font);
                    }
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "errorOccurred"));
            }
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(errorMessage);
                }
            });
        }

        private void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }
    }
}

