/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryFinalOnLocalVariableOrParameterInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnAbstractMethods = false;
    public boolean reportLocalVariables = true;
    public boolean reportParameters = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.or.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        String variableName = variable.getName();
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.problem.descriptor", variableName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.problem.descriptor", variableName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        final JCheckBox abstractOnlyCheckBox = new JCheckBox(InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option", new Object[0]), this.onlyWarnOnAbstractMethods){

            @Override
            public void setEnabled(boolean b) {
                if (b) {
                    super.setEnabled(UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters);
                } else {
                    super.setEnabled(false);
                }
            }
        };
        abstractOnlyCheckBox.setEnabled(true);
        abstractOnlyCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods = abstractOnlyCheckBox.isSelected();
            }
        });
        final JCheckBox reportLocalVariablesCheckBox = new JCheckBox(InspectionGadgetsBundle.message("unnecessary.final.report.local.variables.option", new Object[0]), this.reportLocalVariables);
        final JCheckBox reportParametersCheckBox = new JCheckBox(InspectionGadgetsBundle.message("unnecessary.final.report.parameters.option", new Object[0]), this.reportParameters);
        reportLocalVariablesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables = reportLocalVariablesCheckBox.isSelected();
                if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                    reportParametersCheckBox.setSelected(true);
                }
            }
        });
        reportParametersCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters = reportParametersCheckBox.isSelected();
                if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                    reportLocalVariablesCheckBox.setSelected(true);
                }
                abstractOnlyCheckBox.setEnabled(UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters);
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        panel.add((Component)reportLocalVariablesCheckBox, constraints);
        constraints.gridy = 1;
        panel.add((Component)reportParametersCheckBox, constraints);
        constraints.insets.left = 20;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        panel.add((Component)abstractOnlyCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnLocalVariableOrParameterVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix("final");
    }

    private class UnnecessaryFinalOnLocalVariableOrParameterVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnLocalVariableOrParameterVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            super.visitDeclarationStatement(statement2);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                return;
            }
            PsiElement[] declaredElements = statement2.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (variable.hasModifierProperty("final")) continue;
                return;
            }
            PsiCodeBlock containingBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (!this.isNecessaryFinal((PsiElement)containingBlock, (PsiVariable)variable)) continue;
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)statement2.getDeclaredElements()[0];
            this.registerModifierError("final", (PsiModifierListOwner)variable, variable);
        }

        public void visitMethod(PsiMethod method) {
            PsiParameter[] parameters;
            super.visitMethod(method);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                this.checkParameter(method, parameter);
            }
        }

        private void checkParameter(PsiMethod method, PsiParameter parameter) {
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && (containingClass.isInterface() || containingClass.isAnnotationType())) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
                return;
            }
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods) {
                return;
            }
            this.registerError((PsiElement)method, (PsiVariable)parameter);
        }

        public void visitTryStatement(PsiTryStatement statement2) {
            PsiCatchSection[] catchSections;
            super.visitTryStatement(statement2);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement2.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null || !parameter.hasModifierProperty("final")) continue;
                this.registerError((PsiElement)catchBlock, (PsiVariable)parameter);
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            this.registerError((PsiElement)statement2, (PsiVariable)parameter);
        }

        private boolean isNecessaryFinal(PsiElement method, PsiVariable parameter) {
            return !PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameter) && VariableAccessUtils.variableIsUsedInInnerClass(parameter, method);
        }

        private void registerError(PsiElement context, PsiVariable parameter) {
            if (!this.isNecessaryFinal(context, parameter)) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
            }
        }
    }
}

