/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.net.InetAddresses;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.NettyKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "built-in-server"})
@KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, strings={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "built-in-server"})
public final class BuiltInWebServer
extends HttpRequestHandler {
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return super.isSupported(request) || Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String projectName;
        boolean isIpv6;
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String host = NettyKt.getHost((HttpRequest)request);
        if (StringsKt.isNullOrEmpty((CharSequence)host)) {
            return false;
        }
        int portIndex = StringsKt.indexOf$default((CharSequence)host, (char)':', (int)0, (boolean)false, (int)6, null);
        if (portIndex > 0) {
            host = StringsKt.substring((String)host, (int)0, (int)portIndex);
        }
        boolean bl = isIpv6 = host.charAt(0) == '[' && host.length() > 2 && host.charAt(host.length() - 1) == ']';
        if (isIpv6) {
            host = StringsKt.substring((String)host, (int)1, (int)(host.length() - 1));
        }
        if (isIpv6 || InetAddresses.isInetAddress((String)host) || BuiltInWebServerKt.isOwnHostName(host) || StringsKt.endsWith$default((String)host, (String)".ngrok.io", (boolean)false, (int)2, null)) {
            if (urlDecoder.path().length() < 2) {
                return false;
            }
            projectName = null;
        } else {
            projectName = host;
        }
        return BuiltInWebServerKt.access$doProcess(request, context, projectName);
    }
}

