/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "processSsi", "", "file", "Ljava/io/File;", "path", "built-in-server"})
@KotlinClass(version={1, 1, 0}, data={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, strings={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "processSsi", "", "file", "Ljava/io/File;", "path", "built-in-server"})
public final class StaticFileHandler
extends WebServerFileHandler {
    private SsiProcessor ssiProcessor;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project2, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost) {
        block11: {
            File file2;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                if (pathInfo.getIoFile() != null) break block10;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block11;
            }
            if ((file2 = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                file2 = new File(virtualFile.getPath());
            }
            File ioFile = file2;
            String nameSequence = pathInfo.getName();
            if (!(StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm"))) {
                StaticFileHandlerKt.sendIoFile(channel, ioFile, (HttpRequest)request);
                return true;
            }
            String string = PathUtilRt.getParentPath((String)((Object)canonicalPath).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(canonicalPath.toString())");
            this.processSsi(ioFile, string, project2, request, channel);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file3 = virtualFile;
        HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file3.getTimeStamp(), file3.getPath());
        if (httpResponse == null) return true;
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file3.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file3.getInputStream()));
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return true;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(File file2, String path, Project project2, FullHttpRequest request, Channel channel) {
        boolean keepAlive;
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            long lastModified;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project2, (HttpRequest)request, path, file2.getParentFile()), file2, new ByteBufUtf8Writer(buffer)), file2.getPath()) == null) {
                return;
            }
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

