/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/debugger/FunctionScopesValueGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "functionValue", "Lorg/jetbrains/debugger/values/FunctionValue;", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/values/FunctionValue;Lorg/jetbrains/debugger/VariableContext;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "script-debugger-ui"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/debugger/FunctionScopesValueGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "functionValue", "Lorg/jetbrains/debugger/values/FunctionValue;", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/values/FunctionValue;Lorg/jetbrains/debugger/VariableContext;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "script-debugger-ui"})
public final class FunctionScopesValueGroup
extends XValueGroup {
    private final FunctionValue functionValue;
    private final VariableContext variableContext;

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        Promise<FunctionValue> $receiver$iv = this.functionValue.resolve();
        $receiver$iv.done((Consumer)new ObsolescentConsumer<FunctionValue>((Obsolescent)node, this, node){
            final /* synthetic */ FunctionScopesValueGroup this$0;
            final /* synthetic */ XCompositeNode $node$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void consume(Object param) {
                FunctionValue it = (FunctionValue)param;
                Scope[] scopes = it.getScopes();
                if (scopes == null || ((Object[])scopes).length == 0) {
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                } else {
                    List<Scope> list = Arrays.asList(Arrays.copyOf(scopes, scopes.length));
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*scopes)");
                    ScopeVariablesGroupKt.createAndAddScopeList(this.$node$inlined, list, FunctionScopesValueGroup.access$getVariableContext$p(this.this$0), null);
                }
            }
            {
                void $super_call_param$1;
                this.this$0 = functionScopesValueGroup;
                this.$node$inlined = xCompositeNode;
                super((Obsolescent)$super_call_param$1);
            }
        }).rejected((Consumer)new Consumer<Throwable>(node){
            final /* synthetic */ XCompositeNode $node;

            public final void consume(Throwable it) {
                Promise.logError((Logger)CommandProcessorKt.getLOG(), (Throwable)it);
                String string = it.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$node.setErrorMessage(string);
            }
            {
                this.$node = xCompositeNode;
            }
        });
    }

    public FunctionScopesValueGroup(@NotNull FunctionValue functionValue, @NotNull VariableContext variableContext) {
        Intrinsics.checkParameterIsNotNull((Object)functionValue, (String)"functionValue");
        Intrinsics.checkParameterIsNotNull((Object)variableContext, (String)"variableContext");
        super("Function scopes");
        this.functionValue = functionValue;
        this.variableContext = variableContext;
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getVariableContext$p(FunctionScopesValueGroup $this) {
        return $this.variableContext;
    }
}

