/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0014J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0010R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "isAttached", "", "()Z", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "detach", "Lorg/jetbrains/concurrency/Promise;", "getChannelIfActive", "write", "content", "VmEx", "script-debugger-backend"})
@KotlinClass(version={1, 1, 0}, data={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0014J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0010R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "isAttached", "", "()Z", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "detach", "Lorg/jetbrains/concurrency/Promise;", "getChannelIfActive", "write", "content", "VmEx", "script-debugger-backend"})
public class StandaloneVmHelper
implements AttachStateManager {
    private volatile Channel channel;
    private final Vm vm;
    private final MessageProcessor messageProcessor;

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? (Channel)null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        return channel != null && !channel.writeAndFlush(content).isCancelled();
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return PromiseKt.resolvedPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        Vm vm = this.vm;
        if (!(vm instanceof VmEx)) {
            vm = null;
        }
        VmEx vmEx = (VmEx)vm;
        Request<? extends Object> disconnectRequest = vmEx != null ? vmEx.createDisconnectRequest() : null;
        AsyncPromise promise2 = new AsyncPromise();
        if (disconnectRequest == null) {
            this.messageProcessor.closed();
            this.channel = null;
        } else {
            this.messageProcessor.send(disconnectRequest).rejected((Consumer)detach.1.INSTANCE);
            currentChannel.flush();
            this.messageProcessor.closed();
            this.channel = null;
            this.messageProcessor.cancelWaitingRequests();
        }
        this.closeChannel(currentChannel, (AsyncPromise<Object>)promise2);
        return (Promise)promise2;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise2) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise2);
    }

    /*
     * WARNING - void declaration
     */
    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor, @NotNull Channel channel) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)messageProcessor, (String)"messageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.vm = vm;
        this.messageProcessor = messageProcessor;
        this.channel = channel;
        ChannelFuture channelFuture = channel.closeFuture();
        $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ StandaloneVmHelper this$0;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                if (StandaloneVmHelper.access$getChannel$p(this.this$0) != null) {
                    StandaloneVmHelper.access$getMessageProcessor$p(this.this$0).closed();
                    StandaloneVmHelper.access$getVm$p(this.this$0).getDebugListener().disconnected();
                }
            }
            {
                this.this$0 = standaloneVmHelper;
            }
        });
    }

    @Nullable
    public static final /* synthetic */ Channel access$getChannel$p(StandaloneVmHelper $this) {
        return $this.channel;
    }

    public static final /* synthetic */ void access$setChannel$p(StandaloneVmHelper $this, @Nullable Channel channel) {
        $this.channel = channel;
    }

    @NotNull
    public static final /* synthetic */ MessageProcessor access$getMessageProcessor$p(StandaloneVmHelper $this) {
        return $this.messageProcessor;
    }

    @NotNull
    public static final /* synthetic */ Vm access$getVm$p(StandaloneVmHelper $this) {
        return $this.vm;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", "", "script-debugger-backend"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", "", "script-debugger-backend"})
    public static interface VmEx
    extends Vm {
        @Nullable
        public Request<? extends Object> createDisconnectRequest();

        @KotlinSyntheticClass(version={1, 1, 0})
        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static Promise<?> setBreakOnException(@NotNull VmEx $this, ExceptionCatchMode catchMode) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)catchMode), (String)"catchMode");
                return Vm.DefaultImpls.setBreakOnException($this, catchMode);
            }
        }
    }
}

