/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendState;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.VmAwareValueManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00050\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/debugger/SuspendContextBase;", "VM", "Lorg/jetbrains/debugger/Vm;", "VALUE_MANAGER", "Lorg/jetbrains/debugger/values/ValueManager;", "F", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContext;", "valueManager", "explicitPaused", "", "(Lorg/jetbrains/debugger/values/ValueManager;Z)V", "getExplicitPaused", "()Z", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "()Lorg/jetbrains/debugger/Script;", "state", "Lorg/jetbrains/debugger/SuspendState;", "getState", "()Lorg/jetbrains/debugger/SuspendState;", "getValueManager", "()Lorg/jetbrains/debugger/values/ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "script-debugger-backend"})
@KotlinClass(version={1, 1, 0}, data={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00050\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/debugger/SuspendContextBase;", "VM", "Lorg/jetbrains/debugger/Vm;", "VALUE_MANAGER", "Lorg/jetbrains/debugger/values/ValueManager;", "F", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContext;", "valueManager", "explicitPaused", "", "(Lorg/jetbrains/debugger/values/ValueManager;Z)V", "getExplicitPaused", "()Z", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "()Lorg/jetbrains/debugger/Script;", "state", "Lorg/jetbrains/debugger/SuspendState;", "getState", "()Lorg/jetbrains/debugger/SuspendState;", "getValueManager", "()Lorg/jetbrains/debugger/values/ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "script-debugger-backend"})
public abstract class SuspendContextBase<VM extends Vm, VALUE_MANAGER extends ValueManager, F extends CallFrame>
implements SuspendContext<F> {
    @NotNull
    private final VALUE_MANAGER valueManager;
    private final boolean explicitPaused;

    @Override
    @NotNull
    public SuspendState getState() {
        return this.getExceptionData() == null ? (this.explicitPaused ? SuspendState.PAUSED : SuspendState.NORMAL) : SuspendState.EXCEPTION;
    }

    @Override
    @Nullable
    public Script getScript() {
        Object topFrame = this.getTopFrame();
        return topFrame == null || !(this.valueManager instanceof VmAwareValueManager) ? (Script)null : ((VmAwareValueManager)this.valueManager).getVm().getScriptManager().getScript((CallFrame)topFrame);
    }

    @NotNull
    public final VALUE_MANAGER getValueManager() {
        return this.valueManager;
    }

    protected final boolean getExplicitPaused() {
        return this.explicitPaused;
    }

    public SuspendContextBase(@NotNull VALUE_MANAGER valueManager, boolean explicitPaused) {
        Intrinsics.checkParameterIsNotNull(valueManager, (String)"valueManager");
        this.valueManager = valueManager;
        this.explicitPaused = explicitPaused;
    }

    @Override
    @Nullable
    public ExceptionData getExceptionData() {
        return SuspendContext.DefaultImpls.getExceptionData(this);
    }

    @Override
    public boolean getHasUnresolvedBreakpointsHit() {
        return SuspendContext.DefaultImpls.getHasUnresolvedBreakpointsHit(this);
    }
}

