/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.frame.ExecutionStackImpl;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010J+\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "debugProcess", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "executionStack", "Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "script-debugger-ui"})
@KotlinClass(version={1, 1, 0}, data={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010J+\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, strings={"Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "debugProcess", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "executionStack", "Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "script-debugger-ui"})
public class SuspendContextImpl
extends XSuspendContext {
    private final ExecutionStackImpl executionStack;

    @NotNull
    public final XExecutionStack getActiveExecutionStack() {
        return this.executionStack;
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        CallFrameView callFrameView = this.executionStack.getTopFrame();
        if (callFrameView == null) {
            return PromiseKt.rejectedPromise("Top frame is null");
        }
        CallFrameView frame = callFrameView;
        Promise<String> promise2 = this.evaluateExpression(frame.getCallFrame().getEvaluateContext(), expression);
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"evaluateExpression(frame\u2026luateContext, expression)");
        return promise2;
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext2, String expression) {
        return EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, expression, null, false, 6, null).thenAsync((AsyncFunction)evaluateExpression.1.INSTANCE);
    }

    public SuspendContextImpl(@NotNull SuspendContext<? extends CallFrame> suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        this.executionStack = new ExecutionStackImpl(suspendContext, debugProcess, topFrameScript, topFrameSourceInfo);
    }

    public /* synthetic */ SuspendContextImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }
}

