/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a#\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0014\b\u0004\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0013H\u0086\b\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0006\u001aB\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0007\u001a#\u0010\u001f\u001a\u00020\n*\u00020\n2\u0014\b\u0004\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0013H\u0086\b\u001a&\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"*\u00020#2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0086\b\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020\u0010*\u00020'\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "releaseIfError", "T", "Lio/netty/buffer/ByteBuf;", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "platform-impl"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a#\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0014\b\u0004\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0013H\u0086\b\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0006\u001aB\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0007\u001a#\u0010\u001f\u001a\u00020\n*\u00020\n2\u0014\b\u0004\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0013H\u0086\b\u001a&\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"*\u00020#2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0086\b\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020\u0010*\u00020'\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, strings={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "releaseIfError", "T", "Lio/netty/buffer/ByteBuf;", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "platform-impl"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2, Object object) {
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, n, condition, n2, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, @NotNull AsyncPromise<?> asyncPromise, int n) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, n, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, AsyncPromise<?> asyncPromise) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, InetSocketAddress inetSocketAddress) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, null, 0, null, 14, null);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @NotNull
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headers().getAsString(HttpHeaderNames.HOST)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(ByteBuf $receiver, @NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $receiver.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e;
            }
        }
    }
}

