/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;", "built-in-server"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;", "built-in-server"})
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel) {
        try {
            if (channel.isActive()) {
                Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            }
        }
        catch (Throwable e) {
            NettyUtil.log(e, LOG);
        }
    }

    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            byte b;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b = buffer.readByte()) >= 0 && (char)b != '\n') {
                if ((char)b == '\r') continue;
                if (valueExpected && (char)b == ':') {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace(buffer);
                    continue;
                }
                builder.append((char)b);
            }
            if (builder.length() == 0) {
                return;
            }
            if (StringsKt.isNullOrEmpty((CharSequence)key)) continue;
            String string = key;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith((String)string, (String)"http", (boolean)true) || StringsKt.startsWith((String)key, (String)"X-Accel-", (boolean)true)) continue;
            String value = builder.toString();
            if (StringsKt.equals((String)key, (String)"status", (boolean)true)) {
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(StringsKt.substring((String)value, (int)0, (int)index))));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2, null)) continue;
            response.headers().add(key, (Object)value);
        }
    }

    static {
        Logger logger = Logger.getInstance(FastCgiService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FastCgiService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$sendBadGateway(@NotNull Channel channel) {
        FastCgiServiceKt.sendBadGateway(channel);
    }

    public static final /* synthetic */ void access$parseHeaders(@NotNull HttpResponse response, @NotNull ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }
}

