/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsScope;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0018\u00010\bR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "parent", "description", "", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/lang/String;)V", "labelScopes", "Ljava/util/Stack;", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "declareName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "identifier", "declareNameUnsafe", "enterLabel", "label", "exitLabel", "", "findLabel", "hasOwnName", "", "name", "Companion", "LabelScope", "js.dart-ast"})
@KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0018\u00010\bR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, strings={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "parent", "description", "", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/lang/String;)V", "labelScopes", "Ljava/util/Stack;", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "declareName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "identifier", "declareNameUnsafe", "enterLabel", "label", "exitLabel", "", "findLabel", "hasOwnName", "", "name", "Companion", "LabelScope", "js.dart-ast"})
public class JsFunctionScope
extends JsScope {
    private final Stack<LabelScope> labelScopes;
    @NotNull
    private static final Set<String> RESERVED_WORDS;
    public static final Companion Companion;

    private final LabelScope getTopLabelScope() {
        return CollectionsKt.isNotEmpty((Collection)this.labelScopes) ? this.labelScopes.peek() : (LabelScope)null;
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        JsName jsName = super.declareFreshName(identifier);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"super.declareFreshName(identifier)");
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return Companion.getRESERVED_WORDS().contains(name2) || super.hasOwnName(name2);
    }

    @NotNull
    public JsName declareNameUnsafe(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        JsName jsName = super.declareName(identifier);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"super.declareName(identifier)");
        return jsName;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label);
        this.labelScopes.push(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        Unit unit;
        boolean value$iv = CollectionsKt.isNotEmpty((Collection)this.labelScopes);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "No scope to exit from";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.labelScopes.pop();
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    public JsFunctionScope(@NotNull JsScope parent2, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        super(parent2, description, null);
        this.labelScopes = new Stack();
    }

    static {
        Companion = new Companion(null);
        RESERVED_WORDS = SetsKt.setOf((Object[])new String[]{"await", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments", "NaN", "Infinity", "undefined", "Kotlin"});
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "parent", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "ident", "", "(Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "getLabelName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "findOwnName", "name", "hasOwnName", "", "js.dart-ast"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, strings={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "parent", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "ident", "", "(Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "getLabelName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "findOwnName", "name", "hasOwnName", "", "js.dart-ast"})
    private final class LabelScope
    extends JsScope {
        @NotNull
        private final JsName labelName;
        @NotNull
        private final String ident;

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return Intrinsics.areEqual((Object)name2, (Object)this.ident) ? this.labelName : (JsName)null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            if (Companion.getRESERVED_WORDS().contains(name2)) return true;
            if (Intrinsics.areEqual((Object)name2, (Object)this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual((Object)name2, (Object)(jsName != null ? jsName.getIdent() : null))) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name2);
            if (!bl) return false;
            return true;
        }

        @NotNull
        public final String getIdent() {
            return this.ident;
        }

        public LabelScope(@NotNull LabelScope parent2, String ident) {
            Intrinsics.checkParameterIsNotNull((Object)ident, (String)"ident");
            super(parent2, "Label scope for " + ident, null);
            this.ident = ident;
            String freshIdent = Companion.getRESERVED_WORDS().contains(this.ident) ? this.getFreshIdent(this.ident) : (parent2 != null ? parent2.getFreshIdent(this.ident) : this.ident);
            this.labelName = new JsName(JsFunctionScope.this, freshIdent);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;", "js.dart-ast"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, strings={"Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;", "js.dart-ast"})
    public static final class Companion {
        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

