/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightPackage;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;
    private final CachedValue<SLRUCache<FindClassesRequest, PsiClass[]>> findClassesCache;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
        }
        for (PsiElementFinder extension : extensions = (PsiElementFinder[])Extensions.getArea((AreaInstance)project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            JavaElementFinder javaElementFinder = (JavaElementFinder)extension;
            if (javaElementFinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
            }
            return javaElementFinder;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        if (lightClassGenerationSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lightClassGenerationSupport", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        this.project = project;
        this.psiManager = PsiManager.getInstance((Project)project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
        this.findClassesCache = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<SLRUCache<FindClassesRequest, PsiClass[]>>(){

            @Nullable
            public CachedValueProvider.Result<SLRUCache<FindClassesRequest, PsiClass[]>> compute() {
                return new CachedValueProvider.Result((Object)new SLRUCache<FindClassesRequest, PsiClass[]>(30, 10){

                    @NotNull
                    public PsiClass[] createValue(FindClassesRequest key) {
                        PsiClass[] psiClassArray = JavaElementFinder.this.doFindClasses(key.fqName, key.scope);
                        if (psiClassArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder$1$1", "createValue"));
                        }
                        return psiClassArray;
                    }
                }, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope2);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        SLRUCache value2;
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        SLRUCache sLRUCache = value2 = (SLRUCache)this.findClassesCache.getValue();
        // MONITORENTER : sLRUCache
        PsiClass[] psiClassArray = (PsiClass[])value2.get((Object)new FindClassesRequest(qualifiedNameString, scope2));
        // MONITOREXIT : sLRUCache
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
    }

    private PsiClass[] doFindClasses(String qualifiedNameString, GlobalSearchScope scope2) {
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList answer = new SmartList();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope2, (List<PsiClass>)answer);
        answer.addAll(this.lightClassGenerationSupport.getFacadeClasses(qualifiedName, scope2));
        return JavaElementFinder.sortByClasspath((List<PsiClass>)answer, scope2).toArray(new PsiClass[answer.size()]);
    }

    private void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass2;
            if (declaration instanceof KtEnumEntry || (lightClass2 = LightClassUtilsKt.toLightClass(declaration)) == null) continue;
            answer.add(lightClass2);
        }
    }

    private void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        if (qualifiedName.isRoot()) {
            return;
        }
        if (!qualifiedName.shortName().asString().equals("DefaultImpls")) {
            return;
        }
        for (KtClassOrObject classOrObject : this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName.parent(), scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface() || (interfaceClass = LightClassUtilsKt.toLightClass(classOrObject)) == null || (implsClass = interfaceClass.findInnerClassByName("DefaultImpls", false)) == null) continue;
            answer.add(implsClass);
        }
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet answer = Sets.newHashSet();
        answer.addAll(this.lightClassGenerationSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations2) {
            String name2 = declaration.getName();
            if (name2 == null) continue;
            answer.add(name2);
        }
        HashSet hashSet = answer;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        return hashSet;
    }

    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findPackage"));
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName2, allScope)) {
            return new KtLightPackage(this.psiManager, fqName2, allScope);
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope2);
        Collection answer = Collections2.transform(subpackages, (Function)new Function<FqName, PsiPackage>(){

            public PsiPackage apply(@Nullable FqName input) {
                return new KtLightPackage(JavaElementFinder.this.psiManager, input, scope2);
            }
        });
        PsiPackage[] psiPackageArray = answer.toArray(new PsiPackage[answer.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        SmartList answer = new SmartList();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.lightClassGenerationSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass2 = LightClassUtilsKt.toLightClass(declaration);
            if (aClass2 == null) continue;
            answer.add(aClass2);
        }
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath((List<PsiClass>)answer, scope2).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> result2 = this.lightClassGenerationSupport.findFilesForPackage(packageFQN, scope2);
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        return psiFileArray;
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(final @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        return new Condition<PsiFile>(){

            public boolean value(PsiFile input) {
                if (!(input instanceof KtFile)) {
                    return true;
                }
                return psiPackage.getQualifiedName().equals(((KtFile)input).getPackageFqName().asString());
            }
        };
    }

    @NotNull
    public static Comparator<PsiElement> byClasspathComparator(final @NotNull GlobalSearchScope searchScope2) {
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        Comparator<PsiElement> comparator2 = new Comparator<PsiElement>(){

            @Override
            public int compare(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                VirtualFile f2;
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/asJava/JavaElementFinder$4", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/asJava/JavaElementFinder$4", "compare"));
                }
                VirtualFile f1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
                if (f1 == (f2 = PsiUtilCore.getVirtualFile((PsiElement)o2))) {
                    return 0;
                }
                if (f1 == null) {
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                return searchScope2.compare(f2, f1);
            }
        };
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        return comparator2;
    }

    private static Collection<PsiClass> sortByClasspath(@NotNull List<PsiClass> classes2, @NotNull GlobalSearchScope searchScope2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (classes2.size() > 1) {
            ContainerUtil.quickSort(classes2, JavaElementFinder.byClasspathComparator(searchScope2));
        }
        return classes2;
    }

    private static class FindClassesRequest {
        private final String fqName;
        private final GlobalSearchScope scope;

        private FindClassesRequest(@NotNull String fqName2, @NotNull GlobalSearchScope scope2) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            this.fqName = fqName2;
            this.scope = scope2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FindClassesRequest request = (FindClassesRequest)o;
            if (!this.fqName.equals(request.fqName)) {
                return false;
            }
            return this.scope.equals(request.scope);
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = 31 * result2 + this.scope.hashCode();
            return result2;
        }

        public String toString() {
            return this.fqName + " in " + this.scope;
        }
    }
}

