/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class ControlFlowProcessor {
    private final ControlFlowBuilder builder = new ControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public ControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode2 = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode2).postProcess();
        Pseudocode pseudocode3 = pseudocode2;
        if (pseudocode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generatePseudocode"));
        }
        return pseudocode3;
    }

    @NotNull
    private Pseudocode generate(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            KtDeclarationWithBody declarationWithBody = (KtDeclarationWithBody)subroutine;
            List<KtParameter> valueParameters = declarationWithBody.getValueParameters();
            for (KtParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            KtExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!declarationWithBody.hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        Pseudocode pseudocode2 = this.builder.exitSubroutine(subroutine);
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generate"));
        }
        return pseudocode2;
    }

    private void generateImplicitReturnValue(@NotNull KtExpression bodyExpression, @NotNull KtElement subroutine) {
        if (bodyExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generateImplicitReturnValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generateImplicitReturnValue"));
        }
        CallableDescriptor subroutineDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (subroutineDescriptor == null) {
            return;
        }
        KotlinType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue returnValue = this.builder.getBoundValue(bodyExpression);
        if (returnValue == null) {
            return;
        }
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private void processLocalDeclaration(@NotNull KtDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "processLocalDeclaration"));
        }
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends KtVisitorVoid {
        private final ControlFlowBuilder builder;
        private final KtVisitorVoid conditionVisitor;

        private CFPVisitor(ControlFlowBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new KtVisitorVoid(){

                private KtExpression getSubjectExpression(KtWhenCondition condition2) {
                    KtWhenExpression whenExpression2 = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)condition2, KtWhenExpression.class);
                    return whenExpression2 != null ? whenExpression2.getSubjectExpression() : null;
                }

                @Override
                public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                    }
                    if (!CFPVisitor.this.generateCall(condition2.getOperationReference())) {
                        KtExpression rangeExpression = condition2.getRangeExpression();
                        CFPVisitor.this.generateInstructions(rangeExpression);
                        CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.UNRESOLVED_CALL, new KtElement[]{rangeExpression});
                    }
                }

                @Override
                public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                    }
                    CFPVisitor.this.mark(condition2);
                    CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.IS, new KtElement[]{this.getSubjectExpression(condition2)});
                }

                @Override
                public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                    }
                    CFPVisitor.this.mark(condition2);
                    KtExpression expression2 = condition2.getExpression();
                    CFPVisitor.this.generateInstructions(expression2);
                    KtExpression subjectExpression = this.getSubjectExpression(condition2);
                    if (subjectExpression != null) {
                        CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.EQUALS_IN_WHEN_CONDITION, new KtElement[]{subjectExpression, expression2});
                    } else {
                        CFPVisitor.this.copyValue(expression2, condition2);
                    }
                }

                @Override
                public void visitKtElement(@NotNull KtElement element2) {
                    if (element2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitKtElement"));
                    }
                    throw new UnsupportedOperationException("[ControlFlowProcessor] " + element2.toString());
                }
            };
            this.builder = builder;
        }

        private void mark(KtElement element2) {
            this.builder.mark(element2);
        }

        public void generateInstructions(@Nullable KtElement element2) {
            if (element2 == null) {
                return;
            }
            element2.accept(this);
            this.checkNothingType(element2);
        }

        private void checkNothingType(KtElement element2) {
            if (!(element2 instanceof KtExpression)) {
                return;
            }
            KtExpression expression2 = KtPsiUtil.deparenthesize((KtExpression)element2);
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof KtStatementExpression || expression2 instanceof KtTryExpression || expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError(expression2);
            }
        }

        @NotNull
        private PseudoValue createSyntheticValue(@NotNull KtElement instructionElement, @NotNull MagicKind kind2, KtElement ... from) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from.length > 0 ? Arrays.asList(from) : Collections.emptyList());
            PseudoValue pseudoValue = this.builder.magic(instructionElement, null, values, kind2).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull KtElement to, @NotNull List<? extends KtElement> from, @NotNull MagicKind kind2) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            PseudoValue pseudoValue = this.builder.magic(to, to, values, kind2).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull KtElement to, @NotNull MagicKind kind2, KtElement ... from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            PseudoValue pseudoValue = this.createNonSyntheticValue(to, Arrays.asList(from), kind2);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        private void mergeValues(@NotNull List<KtExpression> from, @NotNull KtExpression to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            this.builder.merge(to, this.elementsToValues(from));
        }

        private void copyValue(@Nullable KtElement from, @NotNull KtElement to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "copyValue"));
            }
            PseudoValue value2 = this.getBoundOrUnreachableValue(from);
            if (value2 != null) {
                this.builder.bindValue(value2, to);
            }
        }

        @Nullable
        private PseudoValue getBoundOrUnreachableValue(@Nullable KtElement element2) {
            if (element2 == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element2);
            return value2 != null || element2 instanceof KtDeclaration ? value2 : this.builder.newValue(element2);
        }

        private List<PseudoValue> elementsToValues(List<? extends KtElement> from) {
            if (from.isEmpty()) {
                return Collections.emptyList();
            }
            return CollectionsKt.filterNotNull((Iterable)CollectionsKt.map(from, (Function1)new Function1<KtElement, PseudoValue>(){

                public PseudoValue invoke(KtElement element2) {
                    return CFPVisitor.this.getBoundOrUnreachableValue(element2);
                }
            }));
        }

        private void generateInitializer(@NotNull KtDeclaration declaration, @NotNull PseudoValue initValue) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            if (initValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), Collections.<PseudoValue, ReceiverValue>emptyMap());
        }

        @NotNull
        private AccessTarget getResolvedCallAccessTarget(KtElement element2) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(element2, ControlFlowProcessor.this.trace.getBindingContext());
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getResolvedCallAccessTarget"));
            }
            return accessTarget;
        }

        @NotNull
        private AccessTarget getDeclarationAccessTarget(KtElement element2) {
            DeclarationDescriptor descriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
            AccessTarget accessTarget = descriptor2 instanceof VariableDescriptor ? new AccessTarget.Declaration((VariableDescriptor)descriptor2) : AccessTarget.BlackBox.INSTANCE;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getDeclarationAccessTarget"));
            }
            return accessTarget;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            this.mark(expression2);
            KtExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression2);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall == null) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression2, resolvedCall, this.getReceiverValues(resolvedCall));
            }
            this.copyValue(expression2, expression2.getInstanceReference());
        }

        @Override
        public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.getConstant(expression2, ControlFlowProcessor.this.trace.getBindingContext());
            this.builder.loadConstant(expression2, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                this.generateCall(variableAsFunctionResolvedCall.getVariableCall());
            } else if (!this.generateCall(expression2) && !(expression2.getParent() instanceof KtCallExpression)) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, this.generateAndGetReceiverIfAny(expression2));
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            this.mark(expression2);
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            KtSimpleNameExpression operationReference = expression2.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, ControlFlowProcessor.this.trace.getBindingContext());
                if (resolvedCall != null) {
                    PseudoValue rhsValue = this.generateCall(resolvedCall).getOutputValue();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)expression2.getOperationToken());
                    if (!resolvedCall.getResultingDescriptor().getName().equals(assignMethodName)) {
                        this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression2);
                    }
                } else {
                    this.generateBothArgumentsAndMark(expression2);
                }
            } else if (operationType == KtTokens.ELVIS) {
                this.generateInstructions(left);
                this.mark(expression2);
                Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                this.builder.jumpOnTrue(afterElvis, expression2, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right);
                }
                this.builder.bindLabel(afterElvis);
                this.mergeValues(Arrays.asList(left, right), expression2);
            } else if (!this.generateCall(expression2)) {
                this.generateBothArgumentsAndMark(expression2);
            }
        }

        private void generateBooleanOperation(KtBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression2, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression2, this.builder.getBoundValue(left));
            }
            if (right != null) {
                this.generateInstructions(right);
            }
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            this.builder.predefinedOperation(expression2, operation, this.elementsToValues(Arrays.asList(left, right)));
        }

        private Function0<PseudoValue> getValueAsFunction(final PseudoValue value2) {
            return new Function0<PseudoValue>(){

                public PseudoValue invoke() {
                    return value2;
                }
            };
        }

        private Function0<PseudoValue> getDeferredValue(final KtExpression expression2) {
            return new Function0<PseudoValue>(){

                public PseudoValue invoke() {
                    CFPVisitor.this.generateInstructions(expression2);
                    return CFPVisitor.this.getBoundOrUnreachableValue(expression2);
                }
            };
        }

        private void generateBothArgumentsAndMark(KtBinaryExpression expression2) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize(expression2.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression2);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, left, right);
        }

        private void visitAssignment(KtExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAssignment"));
            }
            KtExpression left = KtPsiUtil.deparenthesize(lhs);
            if (left == null) {
                List<Object> arguments2 = Collections.singletonList(rhsDeferredValue.invoke());
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            Object receiverValues = SmartFMap.emptyMap();
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions(left);
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, left);
            }
            PseudoValue rValue = (rightValue = (PseudoValue)rhsDeferredValue.invoke()) != null ? rightValue : this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]);
            this.builder.write(parentExpression, left, rValue, accessTarget, (Map<PseudoValue, ReceiverValue>)receiverValues);
        }

        private void generateArrayAssignment(KtArrayAccessExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, @NotNull KtExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            ResolvedCall<FunctionDescriptor> setResolvedCall = ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                List arguments2 = CollectionsKt.filterNotNull(Arrays.asList(this.getBoundOrUnreachableValue(lhs), (PseudoValue)rhsDeferredValue.invoke()));
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            if (((KtOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, (Map<PseudoValue, ValueParameterDescriptor>)argumentValues);
        }

        private SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<PseudoValue> rhsDeferredValue, final ResolvedCall<FunctionDescriptor> setResolvedCall) {
            List valueArguments2 = (List)CollectionsKt.flatMapTo(setResolvedCall.getResultingDescriptor().getValueParameters(), new ArrayList(), (Function1)new Function1<ValueParameterDescriptor, Iterable<? extends ValueArgument>>(){

                public Iterable<? extends ValueArgument> invoke(ValueParameterDescriptor descriptor2) {
                    ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor2);
                    return resolvedValueArgument != null ? resolvedValueArgument.getArguments() : Collections.emptyList();
                }
            });
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull((List)valueArguments2);
            SmartFMap argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments2) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, (SmartFMap<PseudoValue, ValueParameterDescriptor>)argumentValues);
                    continue;
                }
                PseudoValue rhsValue = (PseudoValue)rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus((Object)rhsValue, (Object)parameterDescriptor);
            }
            return argumentValues;
        }

        private void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            inputExpressions.add(arrayExpression);
            this.generateInstructions(arrayExpression);
            for (KtExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
            PseudoValue rhsValue;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            KtSimpleNameExpression operationSign = expression2.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression2, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(Collections.singletonList(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall != null) {
                rhsValue = this.generateCall(resolvedCall).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                rhsValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression2);
                if (expression2 instanceof KtPostfixExpression) {
                    this.copyValue(baseExpression, expression2);
                }
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            this.mark(expression2);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression2, this.builder.getBoundValue(condition2));
            KtExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression2);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues(branches, expression2);
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            boolean hasFinally;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            this.mark(expression2);
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                assert (onExceptionToFinallyBlock != null) : "No finally lable generated: " + expression2.getText();
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression2);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            branches.add(expression2.getTryBlock());
            for (KtCatchClause catchClause : expression2.getCatchClauses()) {
                branches.add(catchClause.getCatchBody());
            }
            this.mergeValues(branches, expression2);
        }

        @Nullable
        private Label generateTryAndCatches(@NotNull KtTryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateTryAndCatches"));
            }
            List<KtCatchClause> catchClauses = expression2.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression2, null);
            }
            KtBlockExpression tryBlock2 = expression2.getTryBlock();
            this.generateInstructions(tryBlock2);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression2);
                this.builder.bindLabel(onException);
                LinkedList catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels, expression2);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    KtExpression catchBody;
                    this.builder.enterLexicalScope(catchClause);
                    if (!isFirst) {
                        this.builder.bindLabel((Label)catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody);
                    }
                    this.builder.jump(afterCatches, expression2);
                    this.builder.exitLexicalScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            this.mark(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition2, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression2, this.builder.getBoundValue(condition2));
            } else {
                assert (condition2 != null) : "Invalid while condition: " + expression2.getText();
                this.createSyntheticValue(condition2, MagicKind.VALUE_CONSUMER, condition2);
            }
            this.builder.enterLoopBody(expression2);
            KtExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            this.builder.enterLexicalScope(expression2);
            this.mark(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.enterLoopBody(expression2);
            KtExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression2, this.builder.getBoundValue(condition2));
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitLexicalScope(expression2);
        }

        @Override
        public void visitForExpression(@NotNull KtForExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            this.builder.enterLexicalScope(expression2);
            KtExpression loopRange = expression2.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange);
            }
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression2, null);
            this.writeLoopParameterAssignment(expression2);
            this.mark(expression2);
            this.builder.enterLoopBody(expression2);
            KtExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitLexicalScope(expression2);
        }

        private void declareLoopParameter(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression2.getDestructuringParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitDestructuringDeclaration(multiDeclaration, false);
            }
        }

        private void writeLoopParameterAssignment(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression2.getDestructuringParameter();
            KtExpression loopRange = expression2.getLoopRange();
            PseudoValue value2 = this.builder.magic(loopRange != null ? loopRange : expression2, null, ContainerUtil.createMaybeSingletonList((Object)this.builder.getBoundValue(loopRange)), MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value2);
            } else if (multiDeclaration != null) {
                for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateInitializer(entry, value2);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            KtElement loop = this.getCorrespondingLoop(expression2);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression2, loop);
                this.builder.jump(this.builder.getExitPoint(loop), expression2);
            }
        }

        @Override
        public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            KtElement loop = this.getCorrespondingLoop(expression2);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression2, loop);
                this.builder.jump(this.builder.getConditionEntryPoint(loop), expression2);
            }
        }

        @Nullable
        private KtElement getCorrespondingLoop(KtExpressionWithLabel expression2) {
            KtLoopExpression loop;
            String labelName = expression2.getLabelName();
            if (labelName != null) {
                KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    loop = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression2, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression2));
                } else {
                    KtWhenExpression whenExpression2 = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtWhenExpression.class, (boolean)true, (Class[])new Class[]{KtLoopExpression.class});
                    if (whenExpression2 != null) {
                        ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on(expression2));
                    }
                }
            }
            if (loop != null && loop.getBody() != null && !loop.getBody().getTextRange().contains(expression2.getTextRange())) {
                ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression2));
                return null;
            }
            return loop;
        }

        private void checkJumpDoesNotCrossFunctionBoundary(@NotNull KtExpressionWithLabel jumpExpression, @NotNull KtElement jumpTarget) {
            FunctionDescriptor labelTargetEnclosingFunc;
            if (jumpExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            if (jumpTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpTarget", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpTarget))) {
                ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on(jumpExpression));
            }
        }

        @Override
        public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
            KtElement subroutine;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            KtExpression returnedExpression = expression2.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof KtElement);
                    subroutine = (KtElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue(expression2, returnValue, subroutine);
                }
            } else {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, returnedExpression);
            }
        }

        @Override
        public void visitParameter(@NotNull KtParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            this.builder.declareParameter(parameter);
            KtExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                Label skipDefaultValue = this.builder.createUnboundLabel("after default value for parameter " + parameter.getName());
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                this.generateInstructions(defaultValue);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
        }

        @NotNull
        private PseudoValue computePseudoValueForParameter(@NotNull KtParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            PseudoValue defaultValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (defaultValue == null) {
                PseudoValue pseudoValue = syntheticValue;
                if (pseudoValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
                }
                return pseudoValue;
            }
            PseudoValue pseudoValue = this.builder.merge(parameter, Lists.newArrayList((Object[])new PseudoValue[]{defaultValue, syntheticValue})).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            return pseudoValue;
        }

        @Override
        public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
            boolean declareLexicalScope;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            boolean bl = declareLexicalScope = !this.isBlockInDoWhile(expression2);
            if (declareLexicalScope) {
                this.builder.enterLexicalScope(expression2);
            }
            this.mark(expression2);
            List<KtExpression> statements = expression2.getStatements();
            for (KtExpression statement : statements) {
                this.generateInstructions(statement);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression2);
            } else {
                this.copyValue((KtElement)CollectionsKt.lastOrNull(statements), expression2);
            }
            if (declareLexicalScope) {
                this.builder.exitLexicalScope(expression2);
            }
        }

        private boolean isBlockInDoWhile(@NotNull KtBlockExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "isBlockInDoWhile"));
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 == null) {
                return false;
            }
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private void visitFunction(@NotNull KtFunction function2) {
            boolean isAnonymousFunction;
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitFunction"));
            }
            ControlFlowProcessor.this.processLocalDeclaration(function2);
            boolean bl = isAnonymousFunction = function2 instanceof KtFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            this.visitFunction(function2);
        }

        @Override
        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            if (lambdaExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitLambdaExpression"));
            }
            this.mark(lambdaExpression);
            KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
            this.visitFunction(functionLiteral);
            this.copyValue(functionLiteral, lambdaExpression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.mark(expression2);
            KtExpression selectorExpression = expression2.getSelectorExpression();
            KtExpression receiverExpression = expression2.getReceiverExpression();
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                this.generateInstructions(selectorExpression);
                this.copyValue(selectorExpression, expression2);
            } else {
                this.generateInstructions(receiverExpression);
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, receiverExpression);
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            if (!this.generateCall(expression2)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument2 : expression2.getValueArguments()) {
                    KtExpression argumentExpression = argument2.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                inputExpressions.add(calleeExpression);
                inputExpressions.add(this.generateAndGetReceiverIfAny(expression2));
                this.mark(expression2);
                this.createNonSyntheticValue((KtElement)expression2, inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Nullable
        private KtExpression generateAndGetReceiverIfAny(KtExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (!(parent2 instanceof KtQualifiedExpression)) {
                return null;
            }
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            if (qualifiedExpression.getSelectorExpression() != expression2) {
                return null;
            }
            KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            KtExpression delegate2;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            this.builder.declareVariable(property2);
            KtExpression initializer2 = property2.getInitializer();
            if (initializer2 != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer2), property2);
            }
            if ((delegate2 = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate2);
                if (this.builder.getBoundValue(delegate2) != null) {
                    this.createSyntheticValue(property2, MagicKind.VALUE_CONSUMER, delegate2);
                }
            }
            if (KtPsiUtil.isLocal(property2)) {
                for (KtPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDestructuringDeclaration"));
            }
            this.visitDestructuringDeclaration(declaration, true);
        }

        @Override
        private void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration, boolean generateWriteForEntries) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDestructuringDeclaration"));
            }
            KtExpression initializer2 = declaration.getInitializer();
            this.generateInstructions(initializer2);
            for (KtDestructuringDeclarationEntry entry : declaration.getEntries()) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = resolvedCall != null ? this.builder.call(entry, resolvedCall, this.getReceiverValues(resolvedCall), Collections.<PseudoValue, ValueParameterDescriptor>emptyMap()).getOutputValue() : this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, initializer2);
                if (!generateWriteForEntries) continue;
                this.generateInitializer(entry, writtenValue != null ? writtenValue : this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            ControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            this.mark(expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.CAST, left);
                }
            } else {
                this.visitKtElement(expression2);
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, left);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            this.mark(expression2);
            KtExpression thrownExpression = expression2.getThrownExpression();
            if (thrownExpression == null) {
                return;
            }
            this.generateInstructions(thrownExpression);
            PseudoValue thrownValue = this.builder.getBoundValue(thrownExpression);
            if (thrownValue == null) {
                return;
            }
            this.builder.throwException(expression2, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            this.generateArrayAccess(expression2, ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        @Override
        public void visitIsExpression(@NotNull KtIsExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.mark(expression2);
            KtExpression left = expression2.getLeftHandSide();
            this.generateInstructions(left);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.IS, left);
        }

        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            this.mark(expression2);
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                Object[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    KtWhenCondition condition2 = conditions[i];
                    condition2.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, expression2, this.builder.getBoundValue(condition2));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])conditions);
                    this.builder.nondeterministicJump(nextLabel, expression2, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression2);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic(expression2, null, Collections.<PseudoValue>emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues(branches, expression2);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            this.mark(expression2);
            KtObjectDeclaration declaration = expression2.getObjectDeclaration();
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression2);
        }

        @Override
        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateInitializersForScriptClassOrObject(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            this.mark(expression2);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            for (KtStringTemplateEntry entry : expression2.getEntries()) {
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues(inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody());
        }

        private void generateHeaderDelegationSpecifiers(@NotNull KtClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateHeaderDelegationSpecifiers"));
            }
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions(specifier);
            }
        }

        private void generateInitializersForScriptClassOrObject(@NotNull KtDeclarationContainer classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializersForScriptClassOrObject"));
            }
            for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitClass(@NotNull KtClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass);
                this.generateInitializersForScriptClassOrObject(klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass);
        }

        @Override
        public void visitScript(@NotNull KtScript script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitScript"));
            }
            this.generateInitializersForScriptClassOrObject(script);
        }

        private void generateDeclarationForLocalClassOrObjectIfNeeded(@NotNull KtClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateDeclarationForLocalClassOrObjectIfNeeded"));
            }
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof KtSecondaryConstructor || declaration instanceof KtProperty || declaration instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions(declaration);
                }
            }
        }

        private void processParameters(@NotNull List<KtParameter> parameters2) {
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "processParameters"));
            }
            for (KtParameter parameter : parameters2) {
                this.generateInstructions(parameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSecondaryConstructor"));
            }
            KtClassOrObject classOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)constructor, KtClassOrObject.class);
            assert (classOrObject != null) : "Guaranteed by parsing contract";
            this.processParameters(constructor.getValueParameters());
            this.generateCallOrMarkUnresolved(constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                this.generateInitializersForScriptClassOrObject(classOrObject);
            }
            this.generateInstructions(constructor.getBodyExpression());
        }

        @Override
        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeCallEntry"));
            }
            this.generateCallOrMarkUnresolved(call);
        }

        private void generateCallOrMarkUnresolved(@Nullable KtCallElement call) {
            if (call == null) {
                return;
            }
            if (!this.generateCall(call)) {
                List arguments2 = CollectionsKt.map(call.getValueArguments(), (Function1)new Function1<ValueArgument, KtExpression>(){

                    public KtExpression invoke(ValueArgument valueArgument) {
                        return valueArgument.getArgumentExpression();
                    }
                });
                for (KtExpression argument2 : arguments2) {
                    this.generateInstructions(argument2);
                }
                this.createNonSyntheticValue((KtElement)call, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDelegatedSuperTypeEntry"));
            }
            KtExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression);
            this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, delegateExpression);
        }

        @Override
        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeEntry"));
            }
        }

        @Override
        public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeList"));
            }
            list2.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitKtFile"));
            }
            for (KtDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof KtProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDoubleColonExpression"));
            }
            this.mark(expression2);
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.CALLABLE_REFERENCE, new KtElement[0]);
        }

        @Override
        public void visitKtElement(@NotNull KtElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitKtElement"));
            }
            this.createNonSyntheticValue(element2, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private boolean generateCall(@Nullable KtElement callElement2) {
            if (callElement2 == null) {
                return false;
            }
            return this.checkAndGenerateCall(CallUtilKt.getResolvedCall(callElement2, ControlFlowProcessor.this.trace.getBindingContext()));
        }

        private boolean checkAndGenerateCall(@Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                return false;
            }
            this.generateCall(resolvedCall);
            return true;
        }

        @NotNull
        private InstructionWithValue generateCall(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            KtElement callElement2 = resolvedCall.getCall().getCallElement();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : resolvedCall.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping = resolvedCall.getArgumentMapping(valueArgument);
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, argumentExpression);
            }
            if (resolvedCall.getResultingDescriptor() instanceof VariableDescriptor) {
                KtExpression callExpression2;
                KtExpression ktExpression = callExpression2 = callElement2 instanceof KtExpression ? (KtExpression)callElement2 : null;
                assert (callExpression2 != null) : "Variable-based call without callee expression: " + callElement2.getText();
                assert (parameterValues.isEmpty()) : "Variable-based call with non-empty argument list: " + callElement2.getText();
                ReadValueInstruction readValueInstruction = this.builder.readVariable(callExpression2, resolvedCall, receivers);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return readValueInstruction;
            }
            this.mark(resolvedCall.getCall().getCallElement());
            CallInstruction callInstruction = this.builder.call(callElement2, resolvedCall, receivers, (Map<PseudoValue, ValueParameterDescriptor>)parameterValues);
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            return callInstruction;
        }

        @NotNull
        private Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall) {
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall()).getOutputValue();
                ExplicitReceiverKind kind2 = resolvedCall.getExplicitReceiverKind();
                switch (kind2) {
                    case DISPATCH_RECEIVER: {
                        explicitReceiver = resolvedCall.getDispatchReceiver();
                        break;
                    }
                    case EXTENSION_RECEIVER: 
                    case BOTH_RECEIVERS: {
                        explicitReceiver = (ReceiverValue)resolvedCall.getExtensionReceiver();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            if (explicitReceiver != null && varCallResult != null) {
                receiverValues = receiverValues.plus((Object)varCallResult, explicitReceiver);
            }
            KtElement callElement2 = resolvedCall.getCall().getCallElement();
            receiverValues = this.getReceiverValues(callElement2, resolvedCall.getDispatchReceiver(), receiverValues);
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues = this.getReceiverValues(callElement2, (ReceiverValue)resolvedCall.getExtensionReceiver(), receiverValues);
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement2, @Nullable ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValues) {
            if (receiver == null || receiverValues.containsValue((Object)receiver)) {
                SmartFMap smartFMap = receiverValues;
                if (smartFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
                }
                return smartFMap;
            }
            if (receiver instanceof ImplicitReceiver) {
                receiverValues = receiverValues.plus((Object)this.createSyntheticValue(callElement2, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), (Object)receiver);
            } else if (receiver instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression2) == null) {
                    this.generateInstructions(expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    receiverValues = receiverValues.plus((Object)receiverPseudoValue, (Object)receiver);
                }
            } else if (!(receiver instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            SmartFMap smartFMap = receiverValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    parameterValues = parameterValues.plus((Object)argValue, (Object)parameterDescriptor);
                }
            }
            SmartFMap smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        private class FinallyBlockGenerator {
            private final KtFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(KtFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                KtBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

