/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.psi.KtElement;

public class PseudocodeImpl
implements Pseudocode {
    private final List<Instruction> mutableInstructionList = new ArrayList<Instruction>();
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues = new BidirectionalMap();
    private final Map<PseudoValue, List<Instruction>> valueUsages = Maps.newHashMap();
    private final Map<PseudoValue, Set<PseudoValue>> mergedValues = Maps.newHashMap();
    private final Set<Instruction> sideEffectFree = Sets.newHashSet();
    private Pseudocode parent = null;
    private Set<LocalFunctionDeclarationInstruction> localDeclarations = null;
    private final Map<KtElement, Instruction> representativeInstructions = new HashMap<KtElement, Instruction>();
    private final List<PseudocodeLabel> labels = new ArrayList<PseudocodeLabel>();
    private final KtElement correspondingElement;
    private SubroutineExitInstruction exitInstruction;
    private SubroutineSinkInstruction sinkInstruction;
    private SubroutineExitInstruction errorInstruction;
    private boolean postPrecessed = false;

    public PseudocodeImpl(KtElement correspondingElement) {
        this.correspondingElement = correspondingElement;
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        KtElement ktElement = this.correspondingElement;
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getCorrespondingElement"));
        }
        return ktElement;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        if (this.localDeclarations == null) {
            this.localDeclarations = PseudocodeImpl.getLocalDeclarations(this);
        }
        Set<LocalFunctionDeclarationInstruction> set = this.localDeclarations;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        return set;
    }

    @NotNull
    private static Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(@NotNull Pseudocode pseudocode2) {
        if (pseudocode2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        LinkedHashSet localDeclarations = Sets.newLinkedHashSet();
        for (Instruction instruction : ((PseudocodeImpl)pseudocode2).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations.add((LocalFunctionDeclarationInstruction)instruction);
            localDeclarations.addAll(PseudocodeImpl.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        LinkedHashSet linkedHashSet = localDeclarations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    private void setParent(Pseudocode parent2) {
        this.parent = parent2;
    }

    @NotNull
    public Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            Pseudocode pseudocode2 = parent2;
            if (pseudocode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getRootPseudocode"));
            }
            return pseudocode2;
        }
        PseudocodeImpl pseudocodeImpl = this;
        if (pseudocodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getRootPseudocode"));
        }
        return pseudocodeImpl;
    }

    PseudocodeLabel createLabel(@NotNull String name2, @Nullable String comment) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "createLabel"));
        }
        PseudocodeLabel label = new PseudocodeLabel(name2, comment);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list2 = this.instructions;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getInstructions"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = Sets.newLinkedHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.sinkInstruction, traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < this.instructions.size()) {
            ArrayList simplyReversedInstructions = Lists.newArrayList(this.instructions);
            Collections.reverse(simplyReversedInstructions);
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)traversedInstructions);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getReversedInstructions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        List<Instruction> list2 = this.mutableInstructionList;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getInstructionsIncludingDeadCode"));
        }
        return list2;
    }

    @NotNull
    public List<PseudocodeLabel> getLabels() {
        List<PseudocodeLabel> list2 = this.labels;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getLabels"));
        }
        return list2;
    }

    void addExitInstruction(SubroutineExitInstruction exitInstruction) {
        this.addInstruction(exitInstruction);
        assert (this.exitInstruction == null);
        this.exitInstruction = exitInstruction;
    }

    void addSinkInstruction(SubroutineSinkInstruction sinkInstruction) {
        this.addInstruction(sinkInstruction);
        assert (this.sinkInstruction == null);
        this.sinkInstruction = sinkInstruction;
    }

    void addErrorInstruction(SubroutineExitInstruction errorInstruction) {
        this.addInstruction(errorInstruction);
        assert (this.errorInstruction == null);
        this.errorInstruction = errorInstruction;
    }

    void addInstruction(Instruction instruction) {
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction) {
            KtElementInstruction elementInstruction = (KtElementInstruction)instruction;
            this.representativeInstructions.put(elementInstruction.getElement(), instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.exitInstruction;
        if (subroutineExitInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getExitInstruction"));
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.sinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getSinkInstruction"));
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        SubroutineEnterInstruction subroutineEnterInstruction = (SubroutineEnterInstruction)this.mutableInstructionList.get(0);
        if (subroutineEnterInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getEnterInstruction"));
        }
        return subroutineEnterInstruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element2) {
        return (PseudoValue)this.elementsToValues.get((Object)element2);
    }

    @Override
    @NotNull
    public List<? extends KtElement> getValueElements(@Nullable PseudoValue value2) {
        List result2 = this.elementsToValues.getKeysByValue((Object)value2);
        List list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getValueElements"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends Instruction> getUsages(@Nullable PseudoValue value2) {
        List<Instruction> result2 = this.valueUsages.get(value2);
        List<Instruction> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getUsages"));
        }
        return list2;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "isSideEffectFree"));
        }
        return this.sideEffectFree.contains(instruction);
    }

    void bindElementToValue(@NotNull KtElement element2, @NotNull PseudoValue value2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "bindElementToValue"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "bindElementToValue"));
        }
        this.elementsToValues.put((Object)element2, (Object)value2);
    }

    void bindLabel(Label label) {
        ((PseudocodeLabel)label).setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private Set<PseudoValue> getMergedValues(@NotNull PseudoValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getMergedValues"));
        }
        Set<PseudoValue> result2 = this.mergedValues.get(value2);
        return result2 != null ? result2 : Collections.emptySet();
    }

    private void addMergedValues(@NotNull MergeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "addMergedValues"));
        }
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value2 : instruction.getInputValues()) {
            result2.addAll(this.getMergedValues(value2));
            result2.add(value2);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    private void addValueUsage(PseudoValue value2, Instruction usage) {
        if (usage instanceof MergeInstruction) {
            return;
        }
        ((List)MapsKt.getOrPut(this.valueUsages, (Object)value2, (Function0)new Function0<List<Instruction>>(){

            public List<Instruction> invoke() {
                return Lists.newArrayList();
            }
        })).add(usage);
    }

    public void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.errorInstruction.setSink(this.getSinkInstruction());
        this.exitInstruction.setSink(this.getSinkInstruction());
        int index2 = 0;
        for (Instruction instruction : this.mutableInstructionList) {
            this.processInstruction(instruction, index2);
            ++index2;
        }
        if (this.getParent() != null) {
            return;
        }
        this.collectAndCacheReachableInstructions();
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : this.getLocalDeclarations()) {
            ((PseudocodeImpl)localFunctionDeclarationInstruction.getBody()).collectAndCacheReachableInstructions();
        }
    }

    private void collectAndCacheReachableInstructions() {
        Set<Instruction> reachableInstructions = this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!reachableInstructions.contains(instruction)) continue;
            this.instructions.add(instruction);
        }
        this.markDeadInstructions();
    }

    private void processInstruction(Instruction instruction, final int currentPosition) {
        instruction.accept(new InstructionVisitor(){

            @Override
            public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitInstructionWithNext"));
                }
                instruction.setNext(PseudocodeImpl.this.getNextPosition(currentPosition));
            }

            @Override
            public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitJump"));
                }
                instruction.setResolvedTarget(PseudocodeImpl.this.getJumpTarget(instruction.getTargetLabel()));
            }

            @Override
            public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitNondeterministicJump"));
                }
                instruction.setNext(PseudocodeImpl.this.getNextPosition(currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.this.getJumpTarget(targetLabel));
                }
            }

            @Override
            public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitConditionalJump"));
                }
                Instruction nextInstruction = PseudocodeImpl.this.getNextPosition(currentPosition);
                Instruction jumpTarget = PseudocodeImpl.this.getJumpTarget(instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            @Override
            public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitLocalFunctionDeclarationInstruction"));
                }
                PseudocodeImpl body2 = (PseudocodeImpl)instruction.getBody();
                body2.setParent(PseudocodeImpl.this);
                body2.postProcess();
                instruction.setNext(PseudocodeImpl.this.getSinkInstruction());
            }

            @Override
            public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitSubroutineExit"));
                }
            }

            @Override
            public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitSubroutineSink"));
                }
            }

            @Override
            public void visitInstruction(@NotNull Instruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$2", "visitInstruction"));
                }
                throw new UnsupportedOperationException(instruction.toString());
            }
        });
    }

    private Set<Instruction> collectReachableInstructions() {
        HashSet visited2 = Sets.newHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getEnterInstruction(), visited2, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)new Function1<Instruction, TraverseInstructionResult>(){

            public TraverseInstructionResult invoke(Instruction instruction) {
                if (instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.EXHAUSTIVE_WHEN_ELSE) {
                    return TraverseInstructionResult.SKIP;
                }
                return TraverseInstructionResult.CONTINUE;
            }
        });
        if (!visited2.contains(this.getExitInstruction())) {
            visited2.add(this.getExitInstruction());
        }
        if (!visited2.contains(this.errorInstruction)) {
            visited2.add(this.errorInstruction);
        }
        if (!visited2.contains(this.getSinkInstruction())) {
            visited2.add(this.getSinkInstruction());
        }
        return visited2;
    }

    private void markDeadInstructions() {
        HashSet instructionSet = Sets.newHashSet(this.instructions);
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            ((InstructionImpl)instruction).setMarkedAsDead(true);
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                nextInstruction.getPreviousInstructions().remove(instruction);
            }
        }
    }

    @NotNull
    private Instruction getJumpTarget(@NotNull Label targetLabel) {
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getJumpTarget"));
        }
        Instruction instruction = ((PseudocodeLabel)targetLabel).resolveToInstruction();
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getJumpTarget"));
        }
        return instruction;
    }

    @NotNull
    private Instruction getNextPosition(int currentPosition) {
        int targetPosition = currentPosition + 1;
        assert (targetPosition < this.mutableInstructionList.size()) : currentPosition;
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "getNextPosition"));
        }
        return instruction;
    }

    @Override
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.correspondingElement);
        result2.repeatWhole(this);
        return result2;
    }

    private void repeatWhole(@NotNull PseudocodeImpl originalPseudocode) {
        if (originalPseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPseudocode", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatWhole"));
        }
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.parent = originalPseudocode.parent;
    }

    public int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        if (startLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatPart"));
        }
        if (finishLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatPart"));
        }
        return this.repeatInternal(((PseudocodeLabel)startLabel).getPseudocode(), startLabel, finishLabel, labelCount);
    }

    private int repeatInternal(@NotNull PseudocodeImpl originalPseudocode, @Nullable Label startLabel, @Nullable Label finishLabel, int labelCount) {
        Integer finishIndex;
        Integer startIndex;
        if (originalPseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPseudocode", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatInternal"));
        }
        Integer n = startIndex = startLabel != null ? ((PseudocodeLabel)startLabel).getTargetInstructionIndex() : Integer.valueOf(0);
        assert (startIndex != null);
        Integer n2 = finishIndex = finishLabel != null ? ((PseudocodeLabel)finishLabel).getTargetInstructionIndex() : Integer.valueOf(originalPseudocode.mutableInstructionList.size());
        assert (finishIndex != null);
        LinkedHashMap originalToCopy = Maps.newLinkedHashMap();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel pseudocodeLabel : originalPseudocode.labels) {
            Integer index2 = pseudocodeLabel.getTargetInstructionIndex();
            if (index2 == null || pseudocodeLabel == startLabel || pseudocodeLabel == finishLabel || startIndex > index2 || index2 > finishIndex) continue;
            originalToCopy.put(pseudocodeLabel, pseudocodeLabel.copy(labelCount++));
            originalLabelsForInstruction.put((Object)this.getJumpTarget(pseudocodeLabel), (Object)pseudocodeLabel);
        }
        for (Label label : originalToCopy.values()) {
            this.labels.add((PseudocodeLabel)label);
        }
        for (int index3 = startIndex.intValue(); index3 < finishIndex; ++index3) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(index3);
            this.repeatLabelsBindingForInstruction(instruction, originalToCopy, (Multimap<Instruction, Label>)originalLabelsForInstruction);
            Instruction copy = PseudocodeImpl.copyInstruction(instruction, originalToCopy);
            this.addInstruction(copy);
            if (instruction == originalPseudocode.errorInstruction && copy instanceof SubroutineExitInstruction) {
                this.errorInstruction = (SubroutineExitInstruction)copy;
            }
            if (instruction == originalPseudocode.exitInstruction && copy instanceof SubroutineExitInstruction) {
                this.exitInstruction = (SubroutineExitInstruction)copy;
            }
            if (instruction != originalPseudocode.sinkInstruction || !(copy instanceof SubroutineSinkInstruction)) continue;
            this.sinkInstruction = (SubroutineSinkInstruction)copy;
        }
        if (finishIndex < this.mutableInstructionList.size()) {
            this.repeatLabelsBindingForInstruction(originalPseudocode.mutableInstructionList.get(finishIndex), originalToCopy, (Multimap<Instruction, Label>)originalLabelsForInstruction);
        }
        return labelCount;
    }

    private void repeatLabelsBindingForInstruction(@NotNull Instruction originalInstruction, @NotNull Map<Label, Label> originalToCopy, @NotNull Multimap<Instruction, Label> originalLabelsForInstruction) {
        if (originalInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalInstruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        if (originalToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToCopy", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        if (originalLabelsForInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLabelsForInstruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        for (Label originalLabel : originalLabelsForInstruction.get((Object)originalInstruction)) {
            this.bindLabel(originalToCopy.get(originalLabel));
        }
    }

    private static Instruction copyInstruction(@NotNull Instruction instruction, @NotNull Map<Label, Label> originalToCopy) {
        Label originalTarget;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "copyInstruction"));
        }
        if (originalToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToCopy", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "copyInstruction"));
        }
        if (instruction instanceof AbstractJumpInstruction && originalToCopy.containsKey(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) {
            return ((AbstractJumpInstruction)instruction).copy(originalToCopy.get(originalTarget));
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = PseudocodeImpl.copyLabels(originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        return ((InstructionImpl)instruction).copy();
    }

    @NotNull
    private static List<Label> copyLabels(Collection<Label> labels, Map<Label, Label> originalToCopy) {
        ArrayList newLabels = Lists.newArrayList();
        for (Label label : labels) {
            Label newLabel = originalToCopy.get(label);
            newLabels.add(newLabel != null ? newLabel : label);
        }
        ArrayList arrayList = newLabels;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl", "copyLabels"));
        }
        return arrayList;
    }

    public class PseudocodeLabel
    implements Label {
        private final String name;
        private final String comment;
        private Integer targetInstructionIndex;

        private PseudocodeLabel(@Nullable String name2, String comment) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$PseudocodeLabel", "<init>"));
            }
            this.name = name2;
            this.comment = comment;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$PseudocodeLabel", "getName"));
            }
            return string;
        }

        public String toString() {
            return this.comment == null ? this.name : this.name + " [" + this.comment + "]";
        }

        public Integer getTargetInstructionIndex() {
            return this.targetInstructionIndex;
        }

        public void setTargetInstructionIndex(int targetInstructionIndex) {
            this.targetInstructionIndex = targetInstructionIndex;
        }

        @Nullable
        private List<Instruction> resolve() {
            assert (this.targetInstructionIndex != null);
            return PseudocodeImpl.this.mutableInstructionList.subList(this.getTargetInstructionIndex(), PseudocodeImpl.this.mutableInstructionList.size());
        }

        public Instruction resolveToInstruction() {
            assert (this.targetInstructionIndex != null);
            return (Instruction)PseudocodeImpl.this.mutableInstructionList.get(this.targetInstructionIndex);
        }

        public PseudocodeLabel copy(int newLabelIndex) {
            return new PseudocodeLabel("L" + newLabelIndex, "copy of " + this.name + ", " + this.comment);
        }

        public PseudocodeImpl getPseudocode() {
            return PseudocodeImpl.this;
        }
    }
}

