/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleKeeperKt;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addPathToCompiledOutput", "", "paramList", "Lcom/intellij/execution/configurations/ParametersList;", "module", "Lcom/intellij/openapi/module/Module;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createJavaParametersWithSdk", "Lcom/intellij/execution/configurations/JavaParameters;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "previousCompilationFailed", "", "Companion", "idea-repl"})
@KotlinClass(version={1, 1, 0}, data={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, strings={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addPathToCompiledOutput", "", "paramList", "Lcom/intellij/execution/configurations/ParametersList;", "module", "Lcom/intellij/openapi/module/Module;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createJavaParametersWithSdk", "Lcom/intellij/execution/configurations/JavaParameters;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "previousCompilationFailed", "", "Companion", "idea-repl"})
public final class KotlinConsoleKeeper {
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.get(virtualFile);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KotlinConsoleRunner run(@NotNull Module module, boolean previousCompilationFailed) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String path = module.getModuleFilePath();
        GeneralCommandLine generalCommandLine = this.createCommandLine(module);
        if (generalCommandLine == null) {
            void $receiver$iv;
            KotlinConsoleKeeper kotlinConsoleKeeper = this;
            KotlinConsoleKeeper $receiver = (KotlinConsoleKeeper)$receiver$iv;
            RunExecuteActionsKt.errorNotification($receiver.project, "Module SDK not found");
            return null;
        }
        GeneralCommandLine cmdLine = generalCommandLine;
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module, cmdLine, previousCompilationFailed, this.project, KotlinConsoleKeeperKt.access$getREPL_TITLE$p(), path);
        consoleRunner.initAndRun();
        consoleRunner.setupGutters();
        return consoleRunner;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module, bl);
    }

    public static /* bridge */ /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, int n) {
        return KotlinConsoleKeeper.run$default(kotlinConsoleKeeper, module, bl, n, null);
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine createCommandLine(Module module) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        SdkTypeId sdkType;
        JavaParameters javaParameters = this.createJavaParametersWithSdk(module);
        Sdk sdk = javaParameters.getJdk();
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        SdkTypeId sdkTypeId = sdkType = sdk2.getSdkType();
        if (sdkTypeId == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.JavaSdkType");
        }
        String exePath = ((JavaSdkType)sdkTypeId).getVMExecutablePath(sdk2);
        GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)((SimpleJavaParameters)javaParameters), (boolean)true);
        ParametersList paramList = commandLine.getParametersList();
        paramList.clearAll();
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForIdeaPlugin();
        Iterable iterable = CollectionsKt.listOf((Object[])new File[]{kotlinPaths.getCompilerPath(), kotlinPaths.getReflectPath(), kotlinPaths.getRuntimePath()});
        void var11_10 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            void var19_15 = destination$iv$iv;
            String string = it.getAbsolutePath();
            var19_15.add(string);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CharSequence charSequence = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
        String replClassPath = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62, null);
        paramList.add("-cp");
        paramList.add(replClassPath);
        paramList.add("-Dkotlin.repl.ideMode=true");
        paramList.add("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler");
        ParametersList parametersList = paramList;
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"paramList");
        this.addPathToCompiledOutput(parametersList, module);
        return commandLine;
    }

    private final JavaParameters createJavaParametersWithSdk(Module module) {
        JavaParameters params2 = new JavaParameters();
        params2.setCharset((Charset)null);
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && new File(sdk.getHomePath()).exists()) {
            params2.setJdk(sdk);
        }
        if (params2.getJdk() == null) {
            params2.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addPathToCompiledOutput(ParametersList paramList, Module module) {
        void elements$iv;
        Module[] moduleArray = new Module[]{module};
        Object[] objectArray = CompilerPathsEx.getOutputPaths((Module[])((Module[])((Object[])elements$iv)));
        CharSequence charSequence = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
        String compiledModulePath = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62, null);
        String moduleDependencies = OrderEnumerator.orderEntries((Module)module).recursively().getPathsList().getPathsString();
        String compiledOutputClasspath = compiledModulePath + File.pathSeparator + moduleDependencies;
        paramList.add("-cp");
        paramList.add(compiledOutputClasspath);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.consoleMap = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "idea-repl"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, strings={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "idea-repl"})
    public static final class Companion {
        @JvmStatic
        public final KotlinConsoleKeeper getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinConsoleKeeper)ServiceManager.getService((Project)project, KotlinConsoleKeeper.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

