/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public class MoveDeclarationsOutHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiElement[] move(@NotNull PsiElement container2, @NotNull PsiElement[] statements, boolean generateDefaultInitializers) {
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "move"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "move"));
        }
        if (statements.length == 0) {
            return statements;
        }
        Project project = container2.getProject();
        ArrayList<PsiElement> resultStatements = new ArrayList<PsiElement>();
        ArrayList<KtProperty> propertiesDeclarations = new ArrayList<KtProperty>();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(project);
        PsiElement dummyFirstStatement = container2.addBefore((PsiElement)psiFactory.createExpression("dummyStatement"), statements[0]);
        try {
            LocalSearchScope scope2 = new LocalSearchScope(container2);
            int lastStatementOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            for (PsiElement statement : statements) {
                if (MoveDeclarationsOutHelper.needToDeclareOut(statement, lastStatementOffset, (SearchScope)scope2)) {
                    if (statement instanceof KtProperty && ((KtProperty)statement).getInitializer() != null) {
                        KtProperty property2 = (KtProperty)statement;
                        KtProperty declaration = MoveDeclarationsOutHelper.createVariableDeclaration(property2, generateDefaultInitializers);
                        declaration = (KtProperty)container2.addBefore((PsiElement)declaration, dummyFirstStatement);
                        propertiesDeclarations.add(declaration);
                        container2.addAfter(psiFactory.createNewLine(), (PsiElement)declaration);
                        KtBinaryExpression assignment = MoveDeclarationsOutHelper.createVariableAssignment(property2);
                        resultStatements.add(property2.replace((PsiElement)assignment));
                        continue;
                    }
                    PsiElement newStatement = container2.addBefore(statement, dummyFirstStatement);
                    container2.addAfter(psiFactory.createNewLine(), newStatement);
                    container2.deleteChildRange(statement, statement);
                    continue;
                }
                resultStatements.add(statement);
            }
        }
        finally {
            dummyFirstStatement.delete();
        }
        ShortenReferences.DEFAULT.process(propertiesDeclarations);
        return PsiUtilCore.toPsiElementArray(resultStatements);
    }

    @NotNull
    private static KtBinaryExpression createVariableAssignment(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableAssignment"));
        }
        String propertyName = property2.getName();
        assert (propertyName != null) : "Property should have a name " + property2.getText();
        KtBinaryExpression assignment = (KtBinaryExpression)KtPsiFactoryKt.KtPsiFactory(property2).createExpression(propertyName + " = x");
        KtExpression right = assignment.getRight();
        assert (right != null) : "Created binary expression should have a right part " + assignment.getText();
        KtExpression initializer2 = property2.getInitializer();
        assert (initializer2 != null) : "Initializer should exist for property " + property2.getText();
        right.replace((PsiElement)initializer2);
        KtBinaryExpression ktBinaryExpression = assignment;
        if (ktBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableAssignment"));
        }
        return ktBinaryExpression;
    }

    @NotNull
    private static KtProperty createVariableDeclaration(@NotNull KtProperty property2, boolean generateDefaultInitializers) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableDeclaration"));
        }
        KotlinType propertyType = MoveDeclarationsOutHelper.getPropertyType(property2);
        String defaultInitializer = null;
        if (generateDefaultInitializers && property2.isVar()) {
            defaultInitializer = CodeInsightUtils.defaultInitializer(propertyType);
        }
        KtProperty ktProperty = MoveDeclarationsOutHelper.createProperty(property2, propertyType, defaultInitializer);
        if (ktProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableDeclaration"));
        }
        return ktProperty;
    }

    @NotNull
    private static KotlinType getPropertyType(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "getPropertyType"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(property2, BodyResolveMode.PARTIAL);
        VariableDescriptor propertyDescriptor = bindingContext2.get(BindingContext.VARIABLE, property2);
        assert (propertyDescriptor != null) : "Couldn't resolve property to property descriptor " + property2.getText();
        KotlinType kotlinType = propertyDescriptor.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "getPropertyType"));
        }
        return kotlinType;
    }

    @NotNull
    private static KtProperty createProperty(@NotNull KtProperty property2, @NotNull KotlinType propertyType, @Nullable String initializer2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        if (propertyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyType", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        KtTypeReference typeRef = property2.getTypeReference();
        String typeString = null;
        if (typeRef != null) {
            typeString = typeRef.getText();
        } else if (!propertyType.isError()) {
            typeString = IdeDescriptorRenderers.SOURCE_CODE.renderType(propertyType);
        }
        KtProperty ktProperty = KtPsiFactoryKt.KtPsiFactory(property2).createProperty(property2.getName(), typeString, property2.isVar(), initializer2);
        if (ktProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        return ktProperty;
    }

    private static boolean needToDeclareOut(@NotNull PsiElement element2, int lastStatementOffset, @NotNull SearchScope scope2) {
        PsiReference lastRef;
        PsiReference[] refs;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "needToDeclareOut"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "needToDeclareOut"));
        }
        return (element2 instanceof KtProperty || element2 instanceof KtClassOrObject || element2 instanceof KtFunction) && (refs = (PsiReference[])ReferencesSearch.search((PsiElement)element2, (SearchScope)scope2, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length > 0 && (lastRef = refs[refs.length - 1]).getElement().getTextOffset() > lastStatementOffset;
    }

    private MoveDeclarationsOutHelper() {
    }
}

