/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelper;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

public abstract class KotlinTrySurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement container2, @NotNull PsiElement[] statements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if ((statements = MoveDeclarationsOutHelper.move(container2, statements, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor, KotlinSurrounderUtils.SURROUND_WITH_ERROR);
            return null;
        }
        KtTryExpression tryExpression = (KtTryExpression)KtPsiFactoryKt.KtPsiFactory(project).createExpression(this.getCodeTemplate());
        tryExpression = (KtTryExpression)container2.addAfter((PsiElement)tryExpression, statements[statements.length - 1]);
        KtBlockExpression tryBlock2 = tryExpression.getTryBlock();
        KotlinSurrounderUtils.addStatementsInBlock(tryBlock2, statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        tryExpression = (KtTryExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)tryExpression);
        return this.getTextRangeForCaret(tryExpression);
    }

    protected abstract String getCodeTemplate();

    @NotNull
    protected abstract TextRange getTextRangeForCaret(@NotNull KtTryExpression var1);

    protected static TextRange getCatchTypeParameterTextRange(@NotNull KtTryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "getCatchTypeParameterTextRange"));
        }
        KtParameter parameter = expression2.getCatchClauses().get(0).getCatchParameter();
        assert (parameter != null) : "Catch parameter should exists for " + expression2.getText();
        KtTypeReference typeReference = parameter.getTypeReference();
        assert (typeReference != null) : "Type reference for parameter should exists for " + expression2.getText();
        return typeReference.getTextRange();
    }
}

