/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinPropertyInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "()V", "deleteEmptyParenthesis", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "idea-completion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, strings={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinPropertyInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "()V", "deleteEmptyParenthesis", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "idea-completion"})
public final class KotlinPropertyInsertHandler
extends KotlinCallableInsertHandler {
    public static final KotlinPropertyInsertHandler INSTANCE;

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.handleInsert(context, item);
        if (context.getCompletionChar() == '\t') {
            this.deleteEmptyParenthesis(context);
        }
    }

    private final void deleteEmptyParenthesis(InsertionContext context) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
        psiDocumentManager.commitAllDocuments();
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
        int offset2 = context.getTailOffset();
        Document document = context.getDocument();
        CharSequence chars = document.getCharsSequence();
        Integer n = HandlerUtilsKt.indexOfSkippingSpace(chars, '(', offset2);
        if (n == null) {
            return;
        }
        int lParenOffset = ((Number)n).intValue();
        Integer n2 = HandlerUtilsKt.indexOfSkippingSpace(chars, ')', lParenOffset + 1);
        if (n2 == null) {
            return;
        }
        int rParenOffset = ((Number)n2).intValue();
        document.deleteString(offset2, rParenOffset + 1);
    }

    private KotlinPropertyInsertHandler() {
        INSTANCE = this;
    }

    static {
        new KotlinPropertyInsertHandler();
    }
}

