/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.smart;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/smart/ArtificialElementInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "textBeforeCaret", "", "textAfterCaret", "shortenRefs", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getShortenRefs", "()Z", "getTextAfterCaret", "()Ljava/lang/String;", "getTextBeforeCaret", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0013"}, strings={"Lorg/jetbrains/kotlin/idea/completion/smart/ArtificialElementInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "textBeforeCaret", "", "textAfterCaret", "shortenRefs", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getShortenRefs", "()Z", "getTextAfterCaret", "()Ljava/lang/String;", "getTextBeforeCaret", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
public final class ArtificialElementInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final String textBeforeCaret;
    @NotNull
    private final String textAfterCaret;
    private final boolean shortenRefs;

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int offset2 = context.getEditor().getCaretModel().getOffset();
        int startOffset = offset2 - item.getLookupString().length();
        context.getDocument().deleteString(startOffset, offset2);
        context.getDocument().insertString(startOffset, (CharSequence)(this.textBeforeCaret + this.textAfterCaret));
        context.getEditor().getCaretModel().moveToOffset(startOffset + this.textBeforeCaret.length());
        if (this.shortenRefs) {
            CompletionUtilsKt.shortenReferences(context, startOffset, startOffset + this.textBeforeCaret.length() + this.textAfterCaret.length());
        }
    }

    @NotNull
    public final String getTextBeforeCaret() {
        return this.textBeforeCaret;
    }

    @NotNull
    public final String getTextAfterCaret() {
        return this.textAfterCaret;
    }

    public final boolean getShortenRefs() {
        return this.shortenRefs;
    }

    public ArtificialElementInsertHandler(@NotNull String textBeforeCaret, @NotNull String textAfterCaret, boolean shortenRefs) {
        Intrinsics.checkParameterIsNotNull((Object)textBeforeCaret, (String)"textBeforeCaret");
        Intrinsics.checkParameterIsNotNull((Object)textAfterCaret, (String)"textAfterCaret");
        this.textBeforeCaret = textBeforeCaret;
        this.textAfterCaret = textAfterCaret;
        this.shortenRefs = shortenRefs;
    }
}

