/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ExceptionUtil;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluateExpressionCache;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "evaluate", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getModifier", "Lcom/intellij/debugger/engine/evaluation/expression/Modifier;", "Companion", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "evaluate", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getModifier", "Lcom/intellij/debugger/engine/evaluation/expression/Modifier;", "Companion", "idea"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final SourcePosition sourcePosition;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (StringsKt.isEmpty((CharSequence)this.codeFragment.getText())) {
            return context.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        try {
            void isCompiledDataFromCache;
            KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2 = KotlinEvaluateExpressionCache.Companion.getOrCreateCompiledData(this.codeFragment, this.sourcePosition, context, (Function2<? super KtCodeFragment, ? super SourcePosition, KotlinEvaluateExpressionCache.CompiledDataDescriptor>)((Function2)new Function2<KtCodeFragment, SourcePosition, KotlinEvaluateExpressionCache.CompiledDataDescriptor>((Ref.BooleanRef)isCompiledDataFromCache, context){
                final /* synthetic */ Ref.BooleanRef $isCompiledDataFromCache;
                final /* synthetic */ EvaluationContextImpl $context;

                @NotNull
                public final KotlinEvaluateExpressionCache.CompiledDataDescriptor invoke(@NotNull KtCodeFragment fragment, @NotNull SourcePosition position) {
                    Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                    Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                    this.$isCompiledDataFromCache.element = false;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$extractAndCompile(KotlinEvaluator.Companion, fragment, position, this.$context);
                }
                {
                    this.$isCompiledDataFromCache = booleanRef;
                    this.$context = evaluationContextImpl;
                    super(2);
                }
            }));
            InterpreterResult result2 = KotlinEvaluator.Companion.runEval4j(context, compiledData2);
            if (isCompiledDataFromCache.element && result2 instanceof ExceptionThrown && Intrinsics.areEqual((Object)((Object)((ExceptionThrown)result2).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.BROKEN_CODE))) {
                return KotlinEvaluator.Companion.toJdiValue(KotlinEvaluator.Companion.runEval4j(context, KotlinEvaluator.Companion.extractAndCompile(this.codeFragment, this.sourcePosition, context)), context);
            }
            return KotlinEvaluator.Companion.toJdiValue(result2, context);
        }
        catch (EvaluateException e) {
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            KotlinEvaluationBuilderKt.getLOG().debug((Throwable)e);
            Void void_ = KotlinEvaluator.Companion.exception(e);
            throw null;
        }
        catch (VMDisconnectedException e) {
            String string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"error.vm.disconnected\")");
            Void void_ = KotlinEvaluator.Companion.exception(string);
            throw null;
        }
        catch (Exception e) {
            void elements$iv;
            Attachment[] attachmentArray = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile(this.sourcePosition.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)this.codeFragment), new Attachment("breakpoint.info", "line: " + this.sourcePosition.getLine())};
            Attachment[] attachments = (Attachment[])((Object[])elements$iv);
            KotlinEvaluationBuilderKt.getLOG().error((Object)LogMessageEx.createEvent((String)"Couldn't evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentUtilsKt.mergeAttachments(Arrays.copyOf(attachments, attachments.length))}));
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            Void void_ = KotlinEvaluator.Companion.exception("An exception occurs during Evaluate Expression Action " + cause);
            throw null;
        }
    }

    @Nullable
    public Modifier getModifier() {
        return null;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition2;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001;B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001bH\u0002J\"\u0010#\u001a\u00020$*\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0002J-\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040**\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0,H\u0002\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u00020\u0013*\u00020/2\u0006\u00100\u001a\u00020\rH\u0002J$\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u000208H\u0002J\u0016\u00109\u001a\u0004\u0018\u00010:*\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "boxOrUnboxArgumentIfNeeded", "Lorg/jetbrains/eval4j/Value;", "eval", "Lorg/jetbrains/eval4j/jdi/JDIEval;", "argumentValue", "parameterType", "Lorg/jetbrains/org/objectweb/asm/Type;", "createClassFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "extractedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$ParametersDescriptor;", "exception", "", "msg", "", "e", "", "extractAndCompile", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$CompiledDataDescriptor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getClassName", "fileName", "runEval4j", "Lorg/jetbrains/eval4j/InterpreterResult;", "compiledData", "checkForErrors", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyzeInlineFunctions", "", "contextFile", "getArgumentsForEval4j", "", "parameterTypes", "", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$ParametersDescriptor;[Lorg/jetbrains/org/objectweb/asm/Type;)Ljava/util/List;", "getParametersForDebugger", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "fragment", "recordAnonymousType", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "localVariableName", "visitor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor;", "toJdiValue", "Lcom/sun/jdi/Value;", "ExtendedAnalysisResult", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001;B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001bH\u0002J\"\u0010#\u001a\u00020$*\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0002J-\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040**\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0,H\u0002\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u00020\u0013*\u00020/2\u0006\u00100\u001a\u00020\rH\u0002J$\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u000208H\u0002J\u0016\u00109\u001a\u0004\u0018\u00010:*\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006<"}, strings={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "boxOrUnboxArgumentIfNeeded", "Lorg/jetbrains/eval4j/Value;", "eval", "Lorg/jetbrains/eval4j/jdi/JDIEval;", "argumentValue", "parameterType", "Lorg/jetbrains/org/objectweb/asm/Type;", "createClassFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "extractedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$ParametersDescriptor;", "exception", "", "msg", "", "e", "", "extractAndCompile", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$CompiledDataDescriptor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getClassName", "fileName", "runEval4j", "Lorg/jetbrains/eval4j/InterpreterResult;", "compiledData", "checkForErrors", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyzeInlineFunctions", "", "contextFile", "getArgumentsForEval4j", "", "parameterTypes", "", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluateExpressionCache$ParametersDescriptor;[Lorg/jetbrains/org/objectweb/asm/Type;)Ljava/util/List;", "getParametersForDebugger", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "fragment", "recordAnonymousType", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "localVariableName", "visitor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor;", "toJdiValue", "Lcom/sun/jdi/Value;", "ExtendedAnalysisResult", "idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final KotlinEvaluateExpressionCache.CompiledDataDescriptor extractAndCompile(KtCodeFragment codeFragment, SourcePosition sourcePosition2, EvaluationContextImpl context) {
            List list2;
            void $receiver$iv;
            org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.checkForErrors$default(this, codeFragment, false, null, 3, null);
            PsiFile psiFile = sourcePosition2.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"sourcePosition.file");
            ExtractionResult extractionResult = ExtractFunctionForDebuggerUtilKt.getFunctionForExtractedFragment(codeFragment, psiFile, sourcePosition2.getLine());
            if (extractionResult == null) {
                throw (Throwable)new IllegalStateException("Code fragment cannot be extracted to function: " + codeFragment.getText());
            }
            ExtractionResult extractionResult2 = extractionResult;
            KotlinEvaluateExpressionCache.ParametersDescriptor parametersDescriptor = this.getParametersForDebugger(extractionResult2, codeFragment);
            KtNamedDeclaration ktNamedDeclaration = extractionResult2.getDeclaration();
            if (ktNamedDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtNamedFunction extractedFunction = (KtNamedFunction)ktNamedDeclaration;
            if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                KotlinEvaluationBuilderKt.getLOG().debug("Extracted function:\n" + (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(extractedFunction){
                    final /* synthetic */ KtNamedFunction $extractedFunction;

                    public final String invoke() {
                        return this.$extractedFunction.getText();
                    }
                    {
                        this.$extractedFunction = ktNamedFunction;
                        super(0);
                    }
                }));
            }
            ClassFileFactory classFileFactory = this.createClassFileFactory(codeFragment, extractedFunction, context, parametersDescriptor);
            Iterable<OutputFile> iterable = ClassFileUtilsKt.filterClassFiles(classFileFactory.asList());
            Object object = $receiver$iv;
            Comparator comparator2 = new Comparator<OutputFile>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    OutputFile it = (OutputFile)a;
                    Comparable comparable = Integer.valueOf(it.getRelativePath().length());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    Integer n = it.getRelativePath().length();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            List outputFiles = CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator2);
            for (OutputFile file : outputFiles) {
                if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Output file generated: " + file.getRelativePath());
                }
                if (!KotlinEvaluationBuilderKt.access$getDEBUG_MODE$p()) continue;
                ConsoleKt.println((Object)file.asText());
            }
            if (outputFiles.size() < 2) {
                list2 = CollectionsKt.emptyList();
            } else {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv2;
                object = outputFiles.subList(1, outputFiles.size());
                comparator2 = $receiver$iv2;
                Collection $i$f$compareBy = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    OutputFile outputFile = (OutputFile)item$iv$iv;
                    void var19_16 = destination$iv$iv;
                    Pair pair2 = TuplesKt.to((Object)Companion.getClassName(it.getRelativePath()), (Object)it.asByteArray());
                    var19_16.add(pair2);
                }
                list2 = (List)destination$iv$iv;
            }
            List additionalFiles = list2;
            return new KotlinEvaluateExpressionCache.CompiledDataDescriptor(((OutputFile)CollectionsKt.first((List)outputFiles)).asByteArray(), additionalFiles, sourcePosition2, parametersDescriptor);
        }

        private final String getClassName(String fileName) {
            return StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)fileName, (String)".class", null, (int)2, null), (String)"/", (String)".", (boolean)false, (int)4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final InterpreterResult runEval4j(EvaluationContextImpl context, KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2) {
            void resultValue;
            VirtualMachine virtualMachine = context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
            if (CollectionsKt.isNotEmpty((Collection)compiledData2.getAdditionalClasses())) {
                CompilingEvaluatorKt.loadClasses(context, (Collection<Pair<String, byte[]>>)compiledData2.getAdditionalClasses());
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            new ClassReader(compiledData2.getBytecodes()).accept(new ClassVisitor(context, compiledData2, virtualMachine, (Ref.ObjectRef)resultValue, 327680){
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinEvaluateExpressionCache.CompiledDataDescriptor $compiledData;
                final /* synthetic */ VirtualMachine $virtualMachine;
                final /* synthetic */ Ref.ObjectRef $resultValue;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    if (Intrinsics.areEqual((Object)name2, (Object)KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME())) {
                        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                        KotlinEvaluateExpressionCache.ParametersDescriptor parametersDescriptor = this.$compiledData.getParameters();
                        Intrinsics.checkExpressionValueIsNotNull((Object)argumentTypes, (String)"argumentTypes");
                        List args = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$getArgumentsForEval4j(KotlinEvaluator.Companion, this.$context, parametersDescriptor, argumentTypes);
                        return (MethodVisitor)new MethodNode(this, args, argumentTypes, 327680, access, name2, desc, signature, exceptions){
                            final /* synthetic */ runEval4j.1 this$0;
                            final /* synthetic */ List $args;
                            final /* synthetic */ Type[] $argumentTypes;

                            /*
                             * WARNING - void declaration
                             */
                            public void visitEnd() {
                                List list2;
                                void destination$iv$iv;
                                void $receiver$iv$iv;
                                Iterable $receiver$iv;
                                Object it;
                                T element$iv2;
                                List<BreakpointRequest> list3 = this.this$0.$virtualMachine.eventRequestManager().breakpointRequests();
                                if (list3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.sun.jdi.request.EventRequest>");
                                }
                                Collection collection = list3;
                                Iterable iterable = this.this$0.$virtualMachine.eventRequestManager().classPrepareRequests();
                                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"virtualMachine.eventRequ\u2026().classPrepareRequests()");
                                List allRequests = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
                                Iterable $receiver$iv2 = allRequests;
                                for (T element$iv2 : $receiver$iv2) {
                                    it = (EventRequest)element$iv2;
                                    it.disable();
                                }
                                VirtualMachine virtualMachine = this.this$0.$virtualMachine;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"virtualMachine");
                                ClassLoaderReference classLoaderReference = this.this$0.$context.getClassLoader();
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = this.this$0.$context.getSuspendContext().getThread();
                                ThreadReference threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
                                if (threadReference == null) {
                                    Intrinsics.throwNpe();
                                }
                                JDIEval eval = new JDIEval(virtualMachine, classLoaderReference, threadReference, KotlinEvaluationBuilderKt.access$getInvokePolicy((SuspendContext)this.this$0.$context.getSuspendContext()));
                                Ref.ObjectRef objectRef = this.this$0.$resultValue;
                                MethodNode methodNode = this;
                                MethodNode methodNode2 = this;
                                Iterable iterable2 = this.$args;
                                Object[] objectArray = this.$argumentTypes;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"argumentTypes");
                                Iterable iterable3 = CollectionsKt.zip((Iterable)iterable2, (Object[])objectArray);
                                MethodNode methodNode3 = methodNode2;
                                MethodNode methodNode4 = methodNode;
                                Ref.ObjectRef objectRef2 = objectRef;
                                element$iv2 = $receiver$iv;
                                it = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv) {
                                    void it2;
                                    Pair pair2 = (Pair)item$iv$iv;
                                    list2 = destination$iv$iv;
                                    Value value2 = (Value)it2.getFirst();
                                    Type type2 = (Type)it2.getSecond();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it.second");
                                    Value value3 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$boxOrUnboxArgumentIfNeeded(KotlinEvaluator.Companion, eval, value2, type2);
                                    list2.add(value3);
                                }
                                list2 = (List)destination$iv$iv;
                                objectRef2.element = InterpreterLoopKt.interpreterLoop$default(methodNode4, JdiValuesKt.makeInitialFrame(methodNode3, list2), eval, null, 8, null);
                                $receiver$iv = allRequests;
                                for (T element$iv3 : $receiver$iv) {
                                    EventRequest it3 = (EventRequest)element$iv3;
                                    it3.enable();
                                }
                            }
                            {
                                this.this$0 = $outer;
                                this.$args = $captured_local_variable$1;
                                this.$argumentTypes = $captured_local_variable$2;
                                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                            }
                        };
                    }
                    return super.visitMethod(access, name2, desc, signature, exceptions);
                }
                {
                    this.$context = $captured_local_variable$0;
                    this.$compiledData = $captured_local_variable$1;
                    this.$virtualMachine = $captured_local_variable$2;
                    this.$resultValue = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }, 0);
            InterpreterResult interpreterResult = (InterpreterResult)resultValue.element;
            if (interpreterResult == null) {
                throw (Throwable)new IllegalStateException("resultValue is null: cannot find method " + KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME());
            }
            return interpreterResult;
        }

        private final Value boxOrUnboxArgumentIfNeeded(JDIEval eval, Value argumentValue, Type parameterType) {
            Type argumentType = argumentValue.getAsmType();
            if (AsmUtil.isPrimitive(parameterType) && !AsmUtil.isPrimitive(argumentType)) {
                try {
                    Type unboxedType = AsmUtil.unboxType(argumentType);
                    if (Intrinsics.areEqual((Object)parameterType, (Object)unboxedType)) {
                        return eval.unboxType(argumentValue, parameterType);
                    }
                }
                catch (UnsupportedOperationException ignored) {
                    // empty catch block
                }
            }
            if (!AsmUtil.isPrimitive(parameterType) && AsmUtil.isPrimitive(argumentType) && (Intrinsics.areEqual((Object)parameterType, (Object)FrameVisitor.Companion.getOBJECT_TYPE()) || Intrinsics.areEqual((Object)parameterType, (Object)AsmUtil.boxType(argumentType)))) {
                return eval.boxType(argumentValue);
            }
            return argumentValue;
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $receiver, EvaluationContextImpl context) {
            Object object;
            block9: {
                VirtualMachine vm;
                Value jdiValue;
                block8: {
                    InterpreterResult interpreterResult = $receiver;
                    if (!(interpreterResult instanceof ValueReturned)) {
                        if (interpreterResult instanceof ExceptionThrown) {
                            if (Intrinsics.areEqual((Object)((Object)((ExceptionThrown)$receiver).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE))) {
                                Object v = ((ExceptionThrown)$receiver).getException().getValue();
                                if (v == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                                }
                                Void void_ = this.exception(new InvocationException((ObjectReference)v));
                                throw null;
                            }
                            Void void_ = this.exception(((ExceptionThrown)$receiver).getException().toString());
                            throw null;
                        }
                        if (interpreterResult instanceof AbnormalTermination) {
                            Void void_ = this.exception(((AbnormalTermination)$receiver).getMessage());
                            throw null;
                        }
                        throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
                    }
                    jdiValue = ((ValueReturned)$receiver).getResult();
                    vm = context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
                    Value sharedVar = new FrameVisitor(context).getValueIfSharedVar(jdiValue, jdiValue.getAsmType(), false);
                    object = sharedVar;
                    if (object == null) break block8;
                    VirtualMachine virtualMachine = vm;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"vm");
                    if ((object = JdiValuesKt.asJdiValue((Value)object, virtualMachine, sharedVar.getAsmType())) != null) break block9;
                }
                VirtualMachine virtualMachine = vm;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"vm");
                object = JdiValuesKt.asJdiValue(jdiValue, virtualMachine, jdiValue.getAsmType());
            }
            return object;
        }

        private final KotlinEvaluateExpressionCache.ParametersDescriptor getParametersForDebugger(ExtractionResult $receiver, KtCodeFragment fragment) {
            return (KotlinEvaluateExpressionCache.ParametersDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<KotlinEvaluateExpressionCache.ParametersDescriptor>($receiver, fragment){
                final /* synthetic */ ExtractionResult receiver$0;
                final /* synthetic */ KtCodeFragment $fragment;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KotlinEvaluateExpressionCache.ParametersDescriptor invoke() {
                    void var3_3;
                    PsiFile contextElementFile;
                    HashMap<K, V> valuesForLabels = new HashMap<K, V>();
                    PsiElement psiElement2 = this.$fragment.getContext();
                    Object object = contextElementFile = psiElement2 != null ? psiElement2.getContainingFile() : null;
                    if (contextElementFile instanceof KtCodeFragment) {
                        contextElementFile.accept((PsiElementVisitor)new KtTreeVisitorVoid(valuesForLabels){
                            final /* synthetic */ HashMap $valuesForLabels;

                            public void visitProperty(@NotNull KtProperty property2) {
                                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                                com.sun.jdi.Value value2 = (com.sun.jdi.Value)property2.getUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY());
                                if (value2 != null) {
                                    String string = property2.getName();
                                    String string2 = string != null ? JetRefactoringUtilKt.quoteIfNeeded(string) : null;
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.$valuesForLabels.put(string2, JdiValuesKt.asValue(value2));
                                }
                            }
                            {
                                this.$valuesForLabels = $captured_local_variable$0;
                            }
                        });
                    }
                    KotlinEvaluateExpressionCache.ParametersDescriptor parameters2 = new KotlinEvaluateExpressionCache.ParametersDescriptor();
                    Parameter receiver = this.receiver$0.getConfig().getDescriptor().getReceiverParameter();
                    if (receiver != null) {
                        KotlinEvaluateExpressionCache.ParametersDescriptor.add$default(parameters2, KotlinEvaluationBuilderKt.getTHIS_NAME(), receiver.getParameterType(true), null, 4, null);
                    }
                    for (Parameter param : this.receiver$0.getConfig().getDescriptor().getParameters()) {
                        String paramName = StringsKt.contains$default((CharSequence)param.getArgumentText(), (CharSequence)"@", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)param.getArgumentText(), (String)"@", null, (int)2, null) : (StringsKt.startsWith$default((String)param.getArgumentText(), (String)"::", (boolean)false, (int)2, null) ? StringsKt.substring((String)param.getArgumentText(), (int)2) : param.getArgumentText());
                        parameters2.add(paramName, param.getParameterType(true), (Value)valuesForLabels.get(paramName));
                    }
                    return var3_3;
                }
                {
                    this.receiver$0 = extractionResult;
                    this.$fragment = ktCodeFragment;
                    super(0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<Value> getArgumentsForEval4j(EvaluationContextImpl $receiver, KotlinEvaluateExpressionCache.ParametersDescriptor parameters2, Type[] parameterTypes) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            FrameVisitor frameVisitor = new FrameVisitor($receiver);
            Iterable iterable = CollectionsKt.zip((Iterable)parameters2, (Object[])parameterTypes);
            void var6_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                Value value2;
                void it;
                Pair pair2 = (Pair)item$iv$iv;
                void var15_12 = destination$iv$iv;
                if (((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getValue() != null) {
                    value2 = ((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getValue();
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    value2 = frameVisitor.findValue(((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getCallText(), (Type)it.getSecond(), false, true);
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                Value result2 = value2;
                if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Parameter for eval4j: name = " + ((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getCallText() + ", type = " + (Type)it.getSecond() + ", value = " + result2);
                }
                Value value3 = result2;
                var15_12.add(value3);
            }
            return (List)destination$iv$iv;
        }

        private final ClassFileFactory createClassFileFactory(KtCodeFragment codeFragment, KtNamedFunction extractedFunction, EvaluationContextImpl context, KotlinEvaluateExpressionCache.ParametersDescriptor parameters2) {
            return (ClassFileFactory)ApplicationUtilsKt.runReadAction((Function0)new Function0<ClassFileFactory>(codeFragment, extractedFunction, context, parameters2){
                final /* synthetic */ KtCodeFragment $codeFragment;
                final /* synthetic */ KtNamedFunction $extractedFunction;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinEvaluateExpressionCache.ParametersDescriptor $parameters;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ClassFileFactory invoke() {
                    Unit unit;
                    void files;
                    void bindingContext2;
                    void moduleDescriptor;
                    KtFile fileForDebugger = KotlinEvaluationBuilderKt.access$createFileForDebugger(this.$codeFragment, this.$extractedFunction);
                    if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                        KotlinEvaluationBuilderKt.getLOG().debug("File for eval4j:" + "\n" + (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(fileForDebugger){
                            final /* synthetic */ KtFile $fileForDebugger;

                            public final String invoke() {
                                return this.$fileForDebugger.getText();
                            }
                            {
                                this.$fileForDebugger = ktFile;
                                super(0);
                            }
                        }));
                    }
                    ExtendedAnalysisResult extendedAnalysisResult = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$checkForErrors(KotlinEvaluator.Companion, fileForDebugger, true, this.$codeFragment.getContextContainingFile());
                    BindingContext bindingContext3 = extendedAnalysisResult.component1();
                    ModuleDescriptor moduleDescriptor2 = extendedAnalysisResult.component2();
                    List<KtFile> list2 = extendedAnalysisResult.component3();
                    extendedAnalysisResult = null;
                    GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(fileForDebugger){
                        final /* synthetic */ KtFile $fileForDebugger;

                        public boolean shouldGeneratePackagePart(@NotNull KtFile jetFile) {
                            Intrinsics.checkParameterIsNotNull((Object)jetFile, (String)"jetFile");
                            return Intrinsics.areEqual((Object)jetFile, (Object)this.$fileForDebugger);
                        }

                        public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                            return true;
                        }

                        public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                            return Intrinsics.areEqual((Object)processingClassOrObject.getContainingKtFile(), (Object)this.$fileForDebugger);
                        }

                        public boolean shouldGenerateScript(@NotNull KtScript script) {
                            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                            return false;
                        }
                        {
                            this.$fileForDebugger = $captured_local_variable$0;
                        }
                    };
                    Project project = fileForDebugger.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"fileForDebugger.project");
                    ClassBuilderFactory classBuilderFactory = !KotlinEvaluationBuilderKt.access$getDEBUG_MODE$p() ? ClassBuilderFactories.BINARIES : ClassBuilderFactories.TEST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"if (!DEBUG_MODE) ClassBu\u2026lassBuilderFactories.TEST");
                    GenerationState state = new GenerationState(project, classBuilderFactory, (ModuleDescriptor)moduleDescriptor, (BindingContext)bindingContext2, (List)files, false, false, generateClassFilter2, false, false, false, null, null, null, null, null, null, false, null, 524128, null);
                    FrameVisitor frameVisitor = new FrameVisitor(this.$context);
                    KtTypeReference ktTypeReference = this.$extractedFunction.getReceiverTypeReference();
                    if (ktTypeReference != null) {
                        void $receiver$iv;
                        KtTypeReference ktTypeReference2 = ktTypeReference;
                        KtTypeReference it = (KtTypeReference)$receiver$iv;
                        BindingTrace bindingTrace = state.getBindingTrace();
                        KtTypeReference ktTypeReference3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType(KotlinEvaluator.Companion, bindingTrace, ktTypeReference3, KotlinEvaluationBuilderKt.getTHIS_NAME(), frameVisitor);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    List<KtParameter> valueParameters = this.$extractedFunction.getValueParameters();
                    int paramIndex = 0;
                    for (KotlinEvaluateExpressionCache.Parameter param : this.$parameters) {
                        KtParameter valueParameter;
                        KtTypeReference paramRef;
                        if ((paramRef = (valueParameter = valueParameters.get(paramIndex++)).getTypeReference()) == null) {
                            KotlinEvaluationBuilderKt.getLOG().error("Each parameter for extracted function should have a type reference", new Attachment[]{new Attachment("codeFragment.txt", this.$codeFragment.getText()), new Attachment("extractedFunction.txt", this.$extractedFunction.getText())});
                            Void void_ = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception(KotlinEvaluator.Companion, "An exception occurs during Evaluate Expression Action");
                            throw null;
                        }
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType(KotlinEvaluator.Companion, state.getBindingTrace(), paramRef, param.getCallText(), frameVisitor);
                    }
                    KotlinCodegenFacade.compileCorrectFiles(state, CompilationErrorHandler.THROW_EXCEPTION);
                    return state.getFactory();
                }
                {
                    this.$codeFragment = ktCodeFragment;
                    this.$extractedFunction = ktNamedFunction;
                    this.$context = evaluationContextImpl;
                    this.$parameters = parametersDescriptor;
                    super(0);
                }
            });
        }

        private final void recordAnonymousType(BindingTrace $receiver, KtTypeReference typeReference, String localVariableName, FrameVisitor visitor2) {
            ClassifierDescriptor declarationDescriptor;
            KotlinType paramAnonymousType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
            if (paramAnonymousType != null && (declarationDescriptor = paramAnonymousType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                Value value2 = visitor2.findValue(localVariableName, null, false, false);
                if (value2 == null) {
                    Void void_ = this.exception("Couldn't find local variable this in current frame to get classType for anonymous type " + paramAnonymousType + "}");
                    throw null;
                }
                Value localVariable = value2;
                $receiver.record(CodegenBinding.ASM_TYPE, declarationDescriptor, localVariable.getAsmType());
                if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Asm type " + localVariable.getAsmType().getClassName() + " was recorded for " + ((ClassDescriptor)declarationDescriptor).getName());
                }
            }
        }

        private final Void exception(String msg) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)msg);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(msg)");
            throw throwable;
        }

        private final Void exception(Throwable e) {
            String message2 = e.getMessage();
            if (message2 != null) {
                Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)message2, (Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026uateException(message, e)");
                throw throwable;
            }
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(e)");
            throw throwable;
        }

        private final ExtendedAnalysisResult checkForErrors(KtFile $receiver, boolean analyzeInlineFunctions, KtFile contextFile) {
            return (ExtendedAnalysisResult)ApplicationUtilsKt.runReadAction((Function0)new Function0<ExtendedAnalysisResult>($receiver, contextFile, analyzeInlineFunctions){
                final /* synthetic */ KtFile receiver$0;
                final /* synthetic */ KtFile $contextFile;
                final /* synthetic */ boolean $analyzeInlineFunctions;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExtendedAnalysisResult invoke() {
                    ExtendedAnalysisResult extendedAnalysisResult;
                    Object it;
                    Object v3;
                    Object $receiver$iv;
                    BindingContext bindingContext2;
                    AnalysisResult analysisResult;
                    ResolutionFacade resolutionFacade;
                    block7: {
                        try {
                            AnalyzingUtils.checkForSyntacticErrors((PsiElement)this.receiver$0);
                        }
                        catch (IllegalArgumentException e) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)e.getMessage());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026luateException(e.message)");
                            throw throwable;
                        }
                        List filesToAnalyze = this.$contextFile == null ? CollectionsKt.listOf((Object)this.receiver$0) : CollectionsKt.listOf((Object[])new KtFile[]{this.receiver$0, this.$contextFile});
                        Project project = this.receiver$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        resolutionFacade = KotlinCacheService.Companion.getInstance(project).getResolutionFacade(CollectionsKt.plus((Collection)filesToAnalyze, (Object)KotlinEvaluationBuilderKt.access$createFlexibleTypesFile((PsiElement)this.receiver$0)));
                        analysisResult = resolutionFacade.analyzeFullyAndGetResult(filesToAnalyze);
                        if (analysisResult.isError()) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((Throwable)analysisResult.getError());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ion(analysisResult.error)");
                            throw throwable;
                        }
                        bindingContext2 = analysisResult.getBindingContext();
                        Iterable iterable = bindingContext2.getDiagnostics();
                        Iterator<T> iterator2 = $receiver$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv = iterator2.next();
                            Diagnostic it2 = (Diagnostic)element$iv;
                            if (!Intrinsics.areEqual((Object)((Object)it2.getSeverity()), (Object)((Object)Severity.ERROR))) continue;
                            v3 = element$iv;
                            break block7;
                        }
                        v3 = null;
                    }
                    Diagnostic diagnostic = v3;
                    if (diagnostic != null) {
                        $receiver$iv = diagnostic;
                        it = $receiver$iv;
                        Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)DefaultErrorMessages.render((Diagnostic)it));
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ErrorMessages.render(it))");
                        throw throwable;
                    }
                    if (this.$analyzeInlineFunctions) {
                        void files;
                        void newBindingContext;
                        Pair<BindingContext, List<KtFile>> pair2 = DebuggerUtils.INSTANCE.analyzeInlinedFunctions(resolutionFacade, bindingContext2, this.receiver$0, false);
                        $receiver$iv = (BindingContext)pair2.component1();
                        it = (List)pair2.component2();
                        pair2 = null;
                        extendedAnalysisResult = new ExtendedAnalysisResult((BindingContext)newBindingContext, analysisResult.getModuleDescriptor(), (List<? extends KtFile>)files);
                    } else {
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        List<KtFile> list2 = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonList(this)");
                        extendedAnalysisResult = new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, list2);
                    }
                    return extendedAnalysisResult;
                }
                {
                    this.receiver$0 = ktFile;
                    this.$contextFile = ktFile2;
                    this.$analyzeInlineFunctions = bl;
                    super(0);
                }
            });
        }

        static /* bridge */ /* synthetic */ ExtendedAnalysisResult checkForErrors$default(Companion companion, KtFile ktFile, boolean bl, KtFile ktFile2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                ktFile2 = null;
            }
            return companion.checkForErrors(ktFile, bl, ktFile2);
        }

        static /* bridge */ /* synthetic */ ExtendedAnalysisResult checkForErrors$default(Companion companion, KtFile ktFile, boolean bl, KtFile ktFile2, int n) {
            return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.checkForErrors$default(companion, ktFile, bl, ktFile2, n, null);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getArgumentsForEval4j(Companion $this, EvaluationContextImpl $receiver, @NotNull KotlinEvaluateExpressionCache.ParametersDescriptor parameters2, @NotNull Type[] parameterTypes) {
            return $this.getArgumentsForEval4j($receiver, parameters2, parameterTypes);
        }

        @NotNull
        public static final /* synthetic */ Value access$boxOrUnboxArgumentIfNeeded(Companion $this, @NotNull JDIEval eval, @NotNull Value argumentValue, @NotNull Type parameterType) {
            return $this.boxOrUnboxArgumentIfNeeded(eval, argumentValue, parameterType);
        }

        @NotNull
        public static final /* synthetic */ ExtendedAnalysisResult access$checkForErrors(Companion $this, KtFile $receiver, boolean analyzeInlineFunctions, @Nullable KtFile contextFile) {
            return $this.checkForErrors($receiver, analyzeInlineFunctions, contextFile);
        }

        public static final /* synthetic */ void access$recordAnonymousType(Companion $this, BindingTrace $receiver, @NotNull KtTypeReference typeReference, @NotNull String localVariableName, @NotNull FrameVisitor visitor2) {
            $this.recordAnonymousType($receiver, typeReference, localVariableName, visitor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "copy", "idea"})
        @KotlinClass(version={1, 1, 0}, data={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "copy", "idea"})
        private static final class ExtendedAnalysisResult {
            @NotNull
            private final BindingContext bindingContext;
            @NotNull
            private final ModuleDescriptor moduleDescriptor;
            @NotNull
            private final List<KtFile> files;

            @NotNull
            public final BindingContext getBindingContext() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor getModuleDescriptor() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<KtFile> getFiles() {
                return this.files;
            }

            public ExtendedAnalysisResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.bindingContext = bindingContext2;
                this.moduleDescriptor = moduleDescriptor;
                this.files = files;
            }

            @NotNull
            public final BindingContext component1() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor component2() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<KtFile> component3() {
                return this.files;
            }

            @NotNull
            public final ExtendedAnalysisResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                return new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, files);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ExtendedAnalysisResult copy$default(ExtendedAnalysisResult extendedAnalysisResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    bindingContext2 = extendedAnalysisResult.bindingContext;
                }
                if ((n & 2) != 0) {
                    moduleDescriptor = extendedAnalysisResult.moduleDescriptor;
                }
                if ((n & 4) != 0) {
                    list2 = extendedAnalysisResult.files;
                }
                return extendedAnalysisResult.copy(bindingContext2, moduleDescriptor, (List<? extends KtFile>)list2);
            }

            public static /* bridge */ /* synthetic */ ExtendedAnalysisResult copy$default(ExtendedAnalysisResult extendedAnalysisResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list2, int n) {
                return ExtendedAnalysisResult.copy$default(extendedAnalysisResult, bindingContext2, moduleDescriptor, list2, n, null);
            }

            public String toString() {
                return "ExtendedAnalysisResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
            }

            public int hashCode() {
                BindingContext bindingContext2 = this.bindingContext;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                List<KtFile> list2 = this.files;
                return ((bindingContext2 != null ? bindingContext2.hashCode() : 0) * 31 + (moduleDescriptor != null ? moduleDescriptor.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ExtendedAnalysisResult)) break block3;
                        ExtendedAnalysisResult extendedAnalysisResult = (ExtendedAnalysisResult)object;
                        if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)extendedAnalysisResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)extendedAnalysisResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, extendedAnalysisResult.files)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

