/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsSerializedResourcePaths;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInClassFileType;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInPackageFileType;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.common.DirectoryBasedClassDataFinder;
import org.jetbrains.kotlin.idea.decompiler.common.ProtoBufUtilKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/KotlinBuiltInStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "getStubVersion", "", "Companion", "idea-analysis"})
@KotlinClass(version={1, 1, 0}, data={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/KotlinBuiltInStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "getStubVersion", "", "Companion", "idea-analysis"})
public final class KotlinBuiltInStubBuilder
extends ClsStubBuilder {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public int getStubVersion() {
        return 12 + 1;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"content.file");
        if (KotlinBuiltInDecompilerKt.isInternalBuiltInFile(virtualFile)) {
            return null;
        }
        return this.doBuildFileStub(content2);
    }

    @Nullable
    public final KotlinFileStubImpl doBuildFileStub(@NotNull FileContent content2) {
        KotlinFileStubImpl kotlinFileStubImpl;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile file = content2.getFile();
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile directory = virtualFile;
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        NameResolverImpl nameResolverImpl = KotlinBuiltInStubBuilderKt.readStringTable(directory, logger);
        if (nameResolverImpl == null) {
            return null;
        }
        NameResolverImpl nameResolver = nameResolverImpl;
        byte[] contentAsBytes = content2.getContent();
        FileType fileType = file.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInPackageFileType.INSTANCE)) {
            ProtoBuf.Package packageProto = ProtoBufUtilKt.toPackageProto(contentAsBytes, BuiltInsSerializedResourcePaths.INSTANCE.getExtensionRegistry());
            FqName packageFqName = KotlinBuiltInDecompilerKt.packageFqName(packageProto, nameResolver);
            VirtualFile virtualFile2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
            ClsStubBuilderComponents components = this.createStubBuilderComponents(virtualFile2, packageFqName, nameResolver);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            kotlinFileStubImpl = ClsStubBuildingKt.createPackageFacadeStub(packageProto, packageFqName, context);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInClassFileType.INSTANCE)) {
            ProtoBuf.Class classProto = ProtoBufUtilKt.toClassProto(contentAsBytes, BuiltInsSerializedResourcePaths.INSTANCE.getExtensionRegistry());
            ClassId classId = nameResolver.getClassId(classProto.getFqName());
            FqName packageFqName = classId.getPackageFqName();
            VirtualFile virtualFile3 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
            FqName fqName2 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
            ClsStubBuilderComponents components = this.createStubBuilderComponents(virtualFile3, fqName2, nameResolver);
            NameResolver nameResolver3 = nameResolver;
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver3, fqName3, new TypeTable(typeTable));
            kotlinFileStubImpl = ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, context);
        } else {
            Void void_ = PreconditionsKt.error((Object)("Unexpected filetype " + file.getFileType()));
            throw null;
        }
        return kotlinFileStubImpl;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, NameResolver nameResolver) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassDataFinder finder = new DirectoryBasedClassDataFinder(virtualFile, packageFqName, nameResolver, BuiltInsSerializedResourcePaths.INSTANCE);
        AnnotationLoaderForStubBuilderImpl annotationLoader = new AnnotationLoaderForStubBuilderImpl(BuiltInSerializerProtocol.INSTANCE);
        return new ClsStubBuilderComponents(finder, annotationLoader, file);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinBuiltInStubBuilder.class);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/KotlinBuiltInStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, strings={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/KotlinBuiltInStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

