/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInsSerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"readStringTable", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, strings={"readStringTable", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
public final class KotlinBuiltInStubBuilderKt {
    @Nullable
    public static final NameResolverImpl readStringTable(@NotNull VirtualFile directory, @NotNull Logger log) {
        NameResolverImpl nameResolverImpl;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        String stringsFileName = directory.getName() + "." + BuiltInsSerializedResourcePaths.INSTANCE.getSTRING_TABLE_FILE_EXTENSION();
        VirtualFile virtualFile = directory.findFileByRelativePath(stringsFileName);
        if (virtualFile == null) {
            log.error(stringsFileName + " not found in " + directory);
            return null;
        }
        VirtualFile stringTableFile = virtualFile;
        try {
            nameResolverImpl = NameResolverImpl.Companion.read(new ByteArrayInputStream(stringTableFile.contentsToByteArray(false)));
        }
        catch (Exception e) {
            log.error("Error reading data from " + stringTableFile + " ", (Throwable)e);
            nameResolverImpl = null;
        }
        NameResolverImpl nameResolver = nameResolverImpl;
        return nameResolver;
    }
}

