/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.DeserializerForClassfileDecompiler;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\t"}, d2={"classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "getClassId", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)Lorg/jetbrains/kotlin/name/ClassId;", "DeserializerForClassfileDecompiler", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/DeserializerForClassfileDecompiler;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\t"}, strings={"classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "getClassId", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)Lorg/jetbrains/kotlin/name/ClassId;", "DeserializerForClassfileDecompiler", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/DeserializerForClassfileDecompiler;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
public final class DeserializerForClassfileDecompilerKt {
    @NotNull
    public static final DeserializerForClassfileDecompiler DeserializerForClassfileDecompiler(@NotNull VirtualFile classFile) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinClassHeaderInfo = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, classFile, null, 2, null);
        boolean value$iv = kotlinClassHeaderInfo != null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData = kotlinClassHeaderInfo;
        if (kotlinBinaryHeaderData == null) {
            Intrinsics.throwNpe();
        }
        FqName packageFqName = kotlinBinaryHeaderData.getClassId().getPackageFqName();
        VirtualFile virtualFile = classFile.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        return new DeserializerForClassfileDecompiler(virtualFile, fqName2);
    }

    private static final ClassId getClassId(JavaClass $receiver) {
        ClassId classId;
        JavaClass outer = $receiver.getOuterClass();
        if (outer == null) {
            FqName fqName2 = $receiver.getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            classId = ClassId.topLevel(fqName2);
        } else {
            classId = DeserializerForClassfileDecompilerKt.getClassId(outer).createNestedClassId($receiver.getName());
        }
        return classId;
    }

    @NotNull
    public static final /* synthetic */ ClassId access$getClassId$p(JavaClass $receiver) {
        return DeserializerForClassfileDecompilerKt.getClassId($receiver);
    }
}

