/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "classFinder", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;)V", "getClassFinder", "()Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "idea-analysis"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "classFinder", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;)V", "getClassFinder", "()Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "idea-analysis"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.classFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        KotlinClassHeader classHeader = binaryClass.getClassHeader();
        String[] data = classHeader.getData();
        if (data == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        String[] strings = classHeader.getStrings();
        if (strings == null) {
            this.log.error("String table not found in class " + binaryClass.getClassId());
            return null;
        }
        return new ClassDataWithSource(JvmProtoBufUtil.readClassDataFrom(data, strings), null, 2, null);
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)classFinder, (String)"classFinder");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.classFinder = classFinder;
        this.log = log;
    }
}

