/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.common;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/common/DirectoryBasedClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "paths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findFileForClass", "idea-analysis"})
@KotlinClass(version={1, 1, 0}, data={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, strings={"Lorg/jetbrains/kotlin/idea/decompiler/common/DirectoryBasedClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "paths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findFileForClass", "idea-analysis"})
public final class DirectoryBasedClassDataFinder
implements ClassDataFinder {
    private final VirtualFile packageDirectory;
    private final FqName directoryPackageFqName;
    private final NameResolver nameResolver;
    private final SerializedResourcePaths paths;

    @Nullable
    public final VirtualFile findFileForClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        if (Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName) ^ true) {
            return null;
        }
        String pathRelativeToDir = StringsKt.substringAfterLast$default((String)this.paths.getClassMetadataPath(classId), (String)"/", null, (int)2, null);
        return this.packageDirectory.findChild(pathRelativeToDir);
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        VirtualFile virtualFile = this.findFileForClass(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        byte[] content2 = virtualFile2.contentsToByteArray(false);
        ProtoBuf.Class classProto = ProtoBufUtilKt.toClassProto(content2, this.paths.getExtensionRegistry());
        return new ClassDataWithSource(new ClassData(this.nameResolver, classProto), null, 2, null);
    }

    public DirectoryBasedClassDataFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName, @NotNull NameResolver nameResolver, @NotNull SerializedResourcePaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
        this.nameResolver = nameResolver;
        this.paths = paths;
    }
}

