/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayInputStream;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.common.DirectoryBasedClassDataFinder;
import org.jetbrains.kotlin.idea.decompiler.common.ProtoBufUtilKt;
import org.jetbrains.kotlin.idea.decompiler.js.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "idea-analysis"})
@KotlinClass(version={1, 1, 0}, data={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, strings={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "idea-analysis"})
public final class KotlinJavaScriptStubBuilder
extends ClsStubBuilder {
    public int getStubVersion() {
        return 12 + 1;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile = file = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        if (JsMetaFileUtils.INSTANCE.isKotlinJavaScriptInternalCompiledFile(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        return this.doBuildFileStub(virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiFileStub<KtFile> doBuildFileStub(@NotNull VirtualFile file) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FqName packageFqName = JsMetaFileUtils.INSTANCE.getPackageFqName(file);
        byte[] content2 = file.contentsToByteArray(false);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE.isPackageHeader(file);
        VirtualFile moduleDirectory = JsMetaFileUtils.INSTANCE.getModuleDirectory(file);
        String stringsFileName = KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(packageFqName);
        VirtualFile stringsFile = moduleDirectory.findFileByRelativePath(stringsFileName);
        boolean bl = stringsFile != null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "strings file not found: " + stringsFileName;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        VirtualFile virtualFile = stringsFile;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        NameResolverImpl nameResolver = NameResolverImpl.Companion.read(new ByteArrayInputStream(virtualFile.contentsToByteArray(false)));
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, packageFqName, nameResolver);
        if (isPackageHeader) {
            ProtoBuf.Package packageProto = ProtoBufUtilKt.toPackageProto(content2, KotlinJavascriptSerializedResourcePaths.INSTANCE.getExtensionRegistry());
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            return ClsStubBuildingKt.createPackageFacadeStub(packageProto, packageFqName, context);
        }
        ProtoBuf.Class classProto = ProtoBufUtilKt.toClassProto(content2, KotlinJavascriptSerializedResourcePaths.INSTANCE.getExtensionRegistry());
        NameResolver nameResolver3 = nameResolver;
        ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
        ClsStubBuilderContext context = components.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
        ClassId classId = JsMetaFileUtils.INSTANCE.getClassId(file);
        return ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, context);
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, NameResolver nameResolver) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassDataFinder classDataFinder = new DirectoryBasedClassDataFinder(virtualFile, packageFqName, nameResolver, KotlinJavascriptSerializedResourcePaths.INSTANCE);
        AnnotationLoaderForStubBuilderImpl annotationLoader = new AnnotationLoaderForStubBuilderImpl(JsSerializerProtocol.INSTANCE);
        return new ClsStubBuilderComponents(classDataFinder, annotationLoader, file);
    }
}

