/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDecompiledDeclaration", "findDecompiledFilesForDescriptor", "Lorg/jetbrains/kotlin/idea/decompiler/KtDecompiledFile;", "isLocal", "", "descriptor", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, strings={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDecompiledDeclaration", "findDecompiledFilesForDescriptor", "Lorg/jetbrains/kotlin/idea/decompiler/KtDecompiledFile;", "isLocal", "", "descriptor", "idea-analysis"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)referencedDescriptor, (String)"referencedDescriptor");
        if (ErrorUtils.isError(referencedDescriptor)) {
            return null;
        }
        if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
            return null;
        }
        if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
            return null;
        }
        Collection<KtDecompiledFile> decompiledFiles = FindDecompiledDeclarationKt.findDecompiledFilesForDescriptor(project, referencedDescriptor);
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), (Function1)((Function1)new Function1<KtDecompiledFile, KtDeclaration>(referencedDescriptor){
            final /* synthetic */ DeclarationDescriptor $referencedDescriptor;

            @Nullable
            public final KtDeclaration invoke(@NotNull KtDecompiledFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getDeclarationForDescriptor(this.$referencedDescriptor);
            }
            {
                this.$referencedDescriptor = declarationDescriptor;
                super(1);
            }
        })));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            return FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        }
        return DescriptorUtils.isLocal(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KtDecompiledFile> findDecompiledFilesForDescriptor(Project project, DeclarationDescriptor referencedDescriptor) {
        void var3_3;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(project, referencedDescriptor);
        Collection destination$iv = new LinkedHashSet();
        void var4_4 = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Boolean bl;
            KtDeclaration it;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            KtDeclaration ktDeclaration = it = (KtDeclaration)element$iv;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if (!(object instanceof KtDecompiledFile)) {
                object = null;
            }
            if ((KtDecompiledFile)object != null) {
                void $receiver$iv$iv2;
                void it$iv = $receiver$iv$iv2;
                bl = destination$iv.add(it$iv);
                continue;
            }
            bl = null;
        }
        return var3_3;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(Project project, DeclarationDescriptor referencedDescriptor) {
        GlobalSearchScope scope2 = KotlinSourceFilterScope.libraryClassFiles(GlobalSearchScope.allScope((Project)project), project);
        ClassDescriptor containingClass = DescriptorUtils.getParentOfType(referencedDescriptor, ClassDescriptor.class, false);
        if (containingClass != null) {
            Collection<KtDeclaration> collection = KotlinFullClassNameIndex.getInstance().get(DescriptorUtilsKt.getFqNameSafe(containingClass).asString(), project, scope2);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFullClassNameIndex\u2026String(), project, scope)");
            return collection;
        }
        PropertyDescriptor propertyDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, PropertyDescriptor.class, false);
        CallableMemberDescriptor callableMemberDescriptor = propertyDescriptor != null ? (CallableMemberDescriptor)propertyDescriptor : (CallableMemberDescriptor)DescriptorUtils.getParentOfType(referencedDescriptor, FunctionDescriptor.class, false);
        if (callableMemberDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        CallableMemberDescriptor topLevelDeclaration = callableMemberDescriptor;
        if (!DescriptorUtils.isTopLevelDeclaration(topLevelDeclaration)) {
            return CollectionsKt.emptyList();
        }
        String fqName2 = DescriptorUtilsKt.getFqNameSafe(topLevelDeclaration).asString();
        CallableMemberDescriptor callableMemberDescriptor2 = topLevelDeclaration;
        if (callableMemberDescriptor2 instanceof FunctionDescriptor) {
            Collection<KtDeclaration> collection = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(fqName2, project, scope2);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinTopLevelFunctionFq\u2026t(fqName, project, scope)");
            return collection;
        }
        if (callableMemberDescriptor2 instanceof PropertyDescriptor) {
            Collection<KtDeclaration> collection = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(fqName2, project, scope2);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinTopLevelPropertyFq\u2026t(fqName, project, scope)");
            return collection;
        }
        Void void_ = PreconditionsKt.error((Object)("Referenced non local declaration that is not inside top level function, property of class:" + "\n" + " " + referencedDescriptor));
        throw null;
    }
}

