/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/MissingConditionFixer;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "keyword", "", "getKeyword", "()Ljava/lang/String;", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "getBody", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getCondition", "getElement", "getLeftParenthesis", "getRightParenthesis", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, strings={"Lorg/jetbrains/kotlin/idea/editor/fixers/MissingConditionFixer;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "keyword", "", "getKeyword", "()Ljava/lang/String;", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "getBody", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getCondition", "getElement", "getLeftParenthesis", "getRightParenthesis", "idea"})
public abstract class MissingConditionFixer<T extends PsiElement>
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        T workElement = this.getElement(element2);
        if (workElement == null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiElement lParen = this.getLeftParenthesis(workElement);
        PsiElement rParen = this.getRightParenthesis(workElement);
        PsiElement condition2 = this.getCondition(workElement);
        if (condition2 == null) {
            if (lParen == null || rParen == null) {
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(FixersUtilKt.getStart(FixersUtilKt.getRange(workElement))));
                PsiElement then = this.getBody(workElement);
                if (then != null) {
                    stopOffset = Math.min(stopOffset, FixersUtilKt.getStart(FixersUtilKt.getRange(then)));
                }
                stopOffset = Math.min(stopOffset, FixersUtilKt.getEnd(FixersUtilKt.getRange(workElement)));
                doc.replaceString(FixersUtilKt.getStart(FixersUtilKt.getRange(workElement)), stopOffset, (CharSequence)(this.getKeyword() + " ()"));
                processor2.registerUnresolvedError(FixersUtilKt.getStart(FixersUtilKt.getRange(workElement)) + (this.getKeyword() + " (").length());
            } else {
                processor2.registerUnresolvedError(FixersUtilKt.getEnd(FixersUtilKt.getRange(lParen)));
            }
        } else if (rParen == null) {
            doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(condition2)), (CharSequence)")");
        }
    }

    @NotNull
    public abstract String getKeyword();

    @Nullable
    public abstract T getElement(@Nullable PsiElement var1);

    @Nullable
    public abstract PsiElement getCondition(@NotNull T var1);

    @Nullable
    public abstract PsiElement getLeftParenthesis(@NotNull T var1);

    @Nullable
    public abstract PsiElement getRightParenthesis(@NotNull T var1);

    @Nullable
    public abstract PsiElement getBody(@NotNull T var1);
}

