/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.idea.filters.KotlinExceptionFilter;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010#\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010&\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/Filter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "exceptionFilter", "Lcom/intellij/execution/filters/ExceptionFilter;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "findClassFileByPath", "Ljava/io/File;", "packageName", "className", "outputDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "patchResult", "result", "readDebugInfo", "bytes", "", "readDebugInfoForInlineFun", "Lcom/intellij/execution/filters/OpenFileHyperlinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFileForInlineCall", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "lineNumber", "getIntervalIfContains", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "destLine", "Companion", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010#\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010&\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, strings={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/Filter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "exceptionFilter", "Lcom/intellij/execution/filters/ExceptionFilter;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "findClassFileByPath", "Ljava/io/File;", "packageName", "className", "outputDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "patchResult", "result", "readDebugInfo", "bytes", "", "readDebugInfoForInlineFun", "Lcom/intellij/execution/filters/OpenFileHyperlinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFileForInlineCall", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "lineNumber", "getIntervalIfContains", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "destLine", "Companion", "idea"})
public final class KotlinExceptionFilter
implements Filter {
    private final ExceptionFilter exceptionFilter;
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN;
    public static final Companion Companion;

    private final HyperlinkInfo createHyperlinkInfo(String line) {
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement element2 = stackTraceElement;
        String fileName = element2.getFileName();
        String fullyQualifiedName = element2.getClassName();
        int lineNumber = element2.getLineNumber() - 1;
        String internalName = StringsKt.replace$default((String)fullyQualifiedName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        JvmClassName jvmClassName2 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        String string = fileName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project3, this.searchScope, jvmClassName2, string);
        if (ktFile == null) {
            return null;
        }
        KtFile file = ktFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        Project project4 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        OpenFileHyperlinkInfo openFileHyperlinkInfo = this.virtualFileForInlineCall(jvmClassName3, virtualFile2, lineNumber + 1, project4);
        return openFileHyperlinkInfo != null ? (HyperlinkInfo)openFileHyperlinkInfo : (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile2, lineNumber);
    }

    private final OpenFileHyperlinkInfo virtualFileForInlineCall(JvmClassName jvmName, VirtualFile file, int lineNumber, Project project) {
        FqName fqName2 = jvmName.getFqNameForClassNameWithoutDollars();
        FqName fqName3 = jvmName.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"jvmName.packageFqName");
        FqName fqNameWithInners = FqNamesUtilKt.tail(fqName2, fqName3);
        if (ProjectRootsUtil.isLibrarySourceFile(project, file)) {
            ClassId classId = new ClassId(jvmName.getPackageFqName(), Name.identifier(fqNameWithInners.asString()));
            JvmVirtualFileFinder fileFinder = JvmVirtualFileFinder.SERVICE.getInstance(project);
            VirtualFile virtualFile = fileFinder.findVirtualFileWithHeader(classId);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile classFile = virtualFile;
            byte[] byArray = classFile.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"classFile.contentsToByteArray()");
            return this.readDebugInfoForInlineFun(byArray, lineNumber, project);
        }
        if (!ProjectRootsUtil.isProjectSourceFile(project, file)) {
            return null;
        }
        PsiFile psiFile = JetRefactoringUtilKt.toPsiFile(file, project);
        if (psiFile == null) {
            return null;
        }
        int linesInFile = JetRefactoringUtilKt.getLineCount((PsiElement)psiFile);
        if (lineNumber <= linesInFile) {
            return null;
        }
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file);
        VirtualFile virtualFile = CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile outputDir = virtualFile;
        String className = StringsKt.replace$default((String)fqNameWithInners.asString(), (char)'.', (char)'$', (boolean)false, (int)4, null);
        String string = jvmName.getPackageFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jvmName.packageFqName.asString()");
        VirtualFile virtualFile2 = outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"outputDir");
        File file2 = this.findClassFileByPath(string, className, virtualFile2);
        if (file2 == null) {
            return null;
        }
        File classByByDirectory = file2;
        return this.readDebugInfoForInlineFun(FilesKt.readBytes((File)classByByDirectory), lineNumber, project);
    }

    private final File findClassFileByPath(String packageName, String className, VirtualFile outputDir) {
        File file = AddToStdlibKt.check(new File(outputDir.getPath()), findClassFileByPath.outDirFile.1.INSTANCE);
        if (file == null) {
            return null;
        }
        File outDirFile2 = file;
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        File parentDirectory = new File(outDirFile2, StringsKt.replace$default((String)packageName, (String)".", (String)string, (boolean)false, (int)4, null));
        if (!parentDirectory.exists()) {
            return null;
        }
        File classFile = new File(parentDirectory, className + ".class");
        if (classFile.exists()) {
            return classFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final OpenFileHyperlinkInfo readDebugInfoForInlineFun(byte[] bytes2, int line, Project project) {
        JvmClassName newJvmName;
        Object v1;
        block5: {
            void $receiver$iv;
            String string = this.readDebugInfo(bytes2);
            if (string == null) {
                return null;
            }
            String debugInfo = string;
            SMAP mappings = SMAPParser.parse(debugInfo);
            Iterable iterable = mappings.getFileMappings();
            for (Object element$iv : $receiver$iv) {
                FileMapping it = (FileMapping)element$iv;
                if (!(this.getIntervalIfContains(it, line) != null)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        FileMapping fileMapping = v1;
        if (fileMapping == null) {
            return null;
        }
        FileMapping mappingInfo = fileMapping;
        JvmClassName jvmClassName = newJvmName = JvmClassName.byInternalName(mappingInfo.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"newJvmName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project, this.searchScope, jvmClassName, mappingInfo.getName());
        if (ktFile == null) {
            return null;
        }
        KtFile newSourceFile = ktFile;
        VirtualFile virtualFile = newSourceFile.getVirtualFile();
        RangeMapping rangeMapping = this.getIntervalIfContains(mappingInfo, line);
        if (rangeMapping == null) {
            Intrinsics.throwNpe();
        }
        return new OpenFileHyperlinkInfo(project, virtualFile, rangeMapping.map(line) - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final String readDebugInfo(byte[] bytes2) {
        void debugInfo;
        ClassReader cr = new ClassReader(bytes2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        cr.accept(new ClassVisitor((Ref.ObjectRef)debugInfo, 327680){
            final /* synthetic */ Ref.ObjectRef $debugInfo;

            public void visitSource(@Nullable String source, @Nullable String debug) {
                this.$debugInfo.element = debug;
            }
            {
                this.$debugInfo = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }, 4 & 1);
        return (String)debugInfo.element;
    }

    private final RangeMapping getIntervalIfContains(FileMapping $receiver, int destLine) {
        Object v0;
        block1: {
            Iterable $receiver$iv = $receiver.getLineMappings();
            for (Object element$iv : $receiver$iv) {
                RangeMapping it = (RangeMapping)element$iv;
                if (!it.contains(destLine)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Filter.Result result3;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        Iterable iterable = result2.getResultItems();
        Filter.Result result4 = result3;
        Filter.Result result5 = result3;
        void var5_7 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            list2 = destination$iv$iv;
            Filter.ResultItem resultItem2 = new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes());
            list2.add(resultItem2);
        }
        list2 = (List)destination$iv$iv;
        result4(list2);
        return result5;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Filter.Result result2 = this.exceptionFilter.applyFilter(line, entireLength);
        return result2 == null ? (Filter.Result)null : this.patchResult(result2, line);
    }

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        this.searchScope = searchScope2;
        this.exceptionFilter = new ExceptionFilter(this.searchScope);
    }

    static {
        Companion = new Companion(null);
        STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter$Companion;", "", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getSTACK_TRACE_ELEMENT_PATTERN", "()Ljava/util/regex/Pattern;", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, strings={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter$Companion;", "", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getSTACK_TRACE_ELEMENT_PATTERN", "()Ljava/util/regex/Pattern;", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "", "idea"})
    public static final class Companion {
        private final Pattern getSTACK_TRACE_ELEMENT_PATTERN() {
            return STACK_TRACE_ELEMENT_PATTERN;
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = this.getSTACK_TRACE_ELEMENT_PATTERN().matcher(line);
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumber = matcher2.group(4);
                return new StackTraceElement(declaringClass, methodName, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

