/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \t*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/NoDeclarationDescriptorsChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "idea-analysis"})
@KotlinClass(version={1, 1, 0}, data={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \t*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, strings={"Lorg/jetbrains/kotlin/idea/highlighter/NoDeclarationDescriptorsChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "idea-analysis"})
public final class NoDeclarationDescriptorsChecker {
    private static final Logger LOG;
    private static final Set<Class<?>> checkedQuickFixClasses;
    public static final NoDeclarationDescriptorsChecker INSTANCE;

    public final void check(@NotNull Class<?> quickFixClass) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(quickFixClass, (String)"quickFixClass");
        if (!checkedQuickFixClasses.add(quickFixClass)) {
            return;
        }
        Field[] fieldArray = quickFixClass.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field2 = fieldArray[i];
            Type type2 = field2.getGenericType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"field.genericType");
            Field field3 = field2;
            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
            this.checkType(type2, field3);
        }
        Class<?> clazz = quickFixClass.getSuperclass();
        if (clazz != null) {
            Class<?> $receiver$iv = clazz;
            Class<?> it = $receiver$iv;
            INSTANCE.check(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkType(Type type2, Field field2) {
        block5: {
            Type type3;
            block7: {
                void $receiver$iv;
                block6: {
                    block4: {
                        type3 = type2;
                        if (!(type3 instanceof Class)) break block4;
                        if (!DeclarationDescriptor.class.isAssignableFrom((Class)type2)) break block5;
                        LOG.error("QuickFix class " + field2.getDeclaringClass().getName() + " contains field " + field2.getName() + " that holds DeclarationDescriptor");
                        break block5;
                    }
                    if (!(type3 instanceof GenericArrayType)) break block6;
                    Type type4 = ((GenericArrayType)type2).getGenericComponentType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"type.genericComponentType");
                    this.checkType(type4, field2);
                    break block5;
                }
                if (!(type3 instanceof ParameterizedType)) break block7;
                Type type5 = ((ParameterizedType)type2).getRawType();
                if (type5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                if (!Collection.class.isAssignableFrom((Class)type5)) break block5;
                Object[] objectArray = ((ParameterizedType)type2).getActualTypeArguments();
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    Type it;
                    void element$iv = $receiver$iv[i];
                    Type type6 = it = (Type)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"it");
                    INSTANCE.checkType(type6, field2);
                }
                break block5;
            }
            if (type3 instanceof WildcardType) {
                Object[] $receiver$iv = ((WildcardType)type2).getUpperBounds();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Type it;
                    Object element$iv = $receiver$iv[i];
                    Type type7 = it = (Type)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"it");
                    INSTANCE.checkType(type7, field2);
                }
            }
        }
    }

    private NoDeclarationDescriptorsChecker() {
        INSTANCE = this;
        LOG = Logger.getInstance(NoDeclarationDescriptorsChecker.class);
        checkedQuickFixClasses = Collections.synchronizedSet(new HashSet());
    }

    static {
        new NoDeclarationDescriptorsChecker();
    }
}

