/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.KtLightMethodKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridingMethodsUpdater;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001H\u0000\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"getOverriddenDeclarations", "", "T", "mappingToJava", "", "Lcom/intellij/psi/PsiMethod;", "classes", "Lcom/intellij/psi/PsiClass;", "getOverriddenMethodTooltip", "", "method", "navigateToOverriddenMethod", "", "e", "Ljava/awt/event/MouseEvent;", "isMethodWithDeclarationInOtherClass", "", "idea"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u00004\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001H\u0000\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0005H\u0002\u00a8\u0006\u0011"}, strings={"getOverriddenDeclarations", "", "T", "mappingToJava", "", "Lcom/intellij/psi/PsiMethod;", "classes", "Lcom/intellij/psi/PsiClass;", "getOverriddenMethodTooltip", "", "method", "navigateToOverriddenMethod", "", "e", "Ljava/awt/event/MouseEvent;", "isMethodWithDeclarationInOtherClass", "", "idea"})
public final class OverridenFunctionMarkerKt {
    private static final boolean isMethodWithDeclarationInOtherClass(PsiMethod $receiver) {
        return $receiver instanceof KtLightMethod && KtLightMethodKt.isTraitFakeOverride((KtLightMethod)$receiver);
    }

    @NotNull
    public static final <T> Set<T> getOverriddenDeclarations(@NotNull Map<PsiMethod, T> mappingToJava, @NotNull Set<? extends PsiClass> classes2) {
        Intrinsics.checkParameterIsNotNull(mappingToJava, (String)"mappingToJava");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        HashSet overridden = new HashSet();
        for (PsiClass psiClass : classes2) {
            Query query = AllOverridingMethodsSearch.search((PsiClass)psiClass);
            if (query == null) {
                Intrinsics.throwNpe();
            }
            query.forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>(mappingToJava, overridden){
                final /* synthetic */ Map $mappingToJava;
                final /* synthetic */ HashSet $overridden;

                public boolean process(@Nullable Pair<PsiMethod, PsiMethod> pair2) {
                    PsiMethod superMethod;
                    V declaration;
                    ProgressManager.checkCanceled();
                    Pair<PsiMethod, PsiMethod> pair3 = pair2;
                    if (pair3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!OverridenFunctionMarkerKt.access$isMethodWithDeclarationInOtherClass((PsiMethod)pair3.getSecond()) && (declaration = this.$mappingToJava.get(superMethod = (PsiMethod)pair2.getFirst())) != null) {
                        this.$mappingToJava.remove(superMethod);
                        this.$overridden.add(declaration);
                    }
                    return !this.$mappingToJava.isEmpty();
                }
                {
                    this.$mappingToJava = $captured_local_variable$0;
                    this.$overridden = $captured_local_variable$1;
                }
            });
        }
        return overridden;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        Comparator comparator2 = new MethodCellRenderer(false).getComparator();
        Iterable iterable = processor2.getCollection();
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator comparator3 = comparator2;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator3, (String)"comparator");
        List overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator3);
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        return GutterIconTooltipHelper.composeText((Iterable)overridingJavaMethods, (String)start, (String)"&nbsp;&nbsp;&nbsp;&nbsp;{1}");
    }

    /*
     * WARNING - void declaration
     */
    public static final void navigateToOverriddenMethod(@Nullable MouseEvent e, @NotNull PsiMethod method) {
        void $receiver$iv;
        void $receiver$iv2;
        void destination$iv$iv;
        Collection $receiver$iv$iv;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (DumbService.isDumb((Project)method.getProject())) {
            Unit unit;
            DumbService dumbService = DumbService.getInstance((Project)method.getProject());
            if (dumbService != null) {
                dumbService.showDumbModeNotification("Navigation to overriding classes is not possible during index update");
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return;
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
        MouseEvent mouseEvent = e;
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(method, processor2){
            final /* synthetic */ PsiMethod $method;
            final /* synthetic */ PsiElementProcessor.CollectElementsWithLimit $processor;

            public final void run() {
                OverridingMethodsSearch.search((PsiMethod)this.$method, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)this.$processor));
            }
            {
                this.$method = psiMethod;
                this.$processor = collectElementsWithLimit;
            }
        }, "Searching for overriding declarations", true, method.getProject(), (JComponent)(mouseEvent != null ? mouseEvent.getComponent() : null))) {
            return;
        }
        Iterable iterable = processor2.getCollection();
        void var5_5 = $receiver$iv3;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overridingJavaMethods = (List)destination$iv$iv;
        if (overridingJavaMethods.isEmpty()) {
            return;
        }
        $receiver$iv$iv = overridingJavaMethods;
        Collection thisCollection$iv = (Collection)$receiver$iv2;
        PsiMethod[] psiMethodArray = thisCollection$iv.toArray(new PsiMethod[thisCollection$iv.size()]);
        if (psiMethodArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])((PsiMethod[])((Object[])psiMethodArray)));
        MethodCellRenderer renderer2 = new MethodCellRenderer(showMethodNames);
        Iterable iterable2 = overridingJavaMethods;
        Comparator comparator2 = renderer2.getComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"renderer.comparator");
        overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, (PsiElementListCellRenderer<? extends PsiElement>)((PsiElementListCellRenderer)renderer2));
        Collection $i$f$toTypedArray = overridingJavaMethods;
        MouseEvent mouseEvent2 = e;
        void v6 = $receiver$iv;
        if (v6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv2 = (Collection)v6;
        PsiMethod[] psiMethodArray2 = thisCollection$iv2.toArray(new PsiMethod[thisCollection$iv2.size()]);
        if (psiMethodArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = psiMethodArray2;
        PsiElementListNavigator.openTargets((MouseEvent)mouseEvent2, (NavigatablePsiElement[])((NavigatablePsiElement[])objectArray), (String)methodsUpdater.getCaption(overridingJavaMethods.size()), (String)("Overriding declarations of " + method.getName()), (ListCellRenderer)((ListCellRenderer)renderer2), (ListBackgroundUpdaterTask)methodsUpdater);
    }

    public static final /* synthetic */ boolean access$isMethodWithDeclarationInOtherClass(PsiMethod $receiver) {
        return OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass($receiver);
    }
}

