/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.MethodFQName;
import org.jetbrains.kotlin.idea.inspections.OldStdlibApiFix;
import org.jetbrains.kotlin.idea.inspections.StdlibMigrationMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/OldStdlibApiInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkReference", "Lcom/intellij/codeInspection/LocalQuickFix;", "reference", "Lcom/intellij/psi/PsiReference;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, strings={"Lorg/jetbrains/kotlin/idea/inspections/OldStdlibApiInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkReference", "Lcom/intellij/codeInspection/LocalQuickFix;", "reference", "Lcom/intellij/psi/PsiReference;", "idea"})
public final class OldStdlibApiInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ OldStdlibApiInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element2) {
                void strict$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (Intrinsics.areEqual((Object)element2.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE))) {
                    return;
                }
                PsiElement psiElement2 = element2;
                int n = 0;
                PsiImportStatement importStatement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, PsiImportStatement.class, (boolean)strict$iv);
                if (importStatement != null) {
                    return;
                }
                PsiReference[] psiReferenceArray = element2.getReferences();
                for (n = 0; n < psiReferenceArray.length; ++n) {
                    Unit unit;
                    PsiReference reference2;
                    PsiReference psiReference = reference2 = psiReferenceArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"reference");
                    if (OldStdlibApiInspection.access$checkReference(this.this$0, psiReference) != null) {
                        void $receiver$iv2;
                        LocalQuickFix it = (LocalQuickFix)$receiver$iv2;
                        this.$holder.registerProblem(element2, "Usage of the Kotlin standard library through a deprecated qualified name", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[]{it});
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final LocalQuickFix checkReference(PsiReference reference2) {
        PsiElement resolveResult = reference2.resolve();
        if (resolveResult instanceof PsiClass) {
            String fqName2 = ((PsiClass)resolveResult).getQualifiedName();
            String newFqName = (String)MapsKt.get((Map)StdlibMigrationMap.INSTANCE.getClassMap(), (Object)fqName2);
            if (newFqName != null) {
                return new OldStdlibApiFix((Function2<? super Project, ? super GlobalSearchScope, ? extends PsiElement>)((Function2)new Function2<Project, GlobalSearchScope, PsiClass>(newFqName){
                    final /* synthetic */ String $newFqName;

                    @Nullable
                    public final PsiClass invoke(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                        return JavaPsiFacade.getInstance((Project)project).findClass(this.$newFqName, scope2);
                    }
                    {
                        this.$newFqName = string;
                        super(2);
                    }
                }));
            }
        } else if (resolveResult instanceof PsiMethod) {
            PsiClass psiClass = ((PsiMethod)resolveResult).getContainingClass();
            if (psiClass == null) {
                return null;
            }
            PsiClass containingClass = psiClass;
            String string = containingClass.getQualifiedName();
            if (string == null) {
                return null;
            }
            String string2 = ((PsiMethod)resolveResult).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resolveResult.name");
            MethodFQName fqName3 = new MethodFQName(string, string2);
            MethodFQName newFqName = StdlibMigrationMap.INSTANCE.getMethodMap().get(fqName3);
            if (newFqName != null) {
                return new OldStdlibApiFix((Function2<? super Project, ? super GlobalSearchScope, ? extends PsiElement>)((Function2)new Function2<Project, GlobalSearchScope, PsiMethod>(newFqName){
                    final /* synthetic */ MethodFQName $newFqName;

                    @Nullable
                    public final PsiMethod invoke(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                        PsiMethod[] psiMethodArray = JavaPsiFacade.getInstance((Project)project).findClass(this.$newFqName.getClassName(), scope2);
                        return psiMethodArray != null && (psiMethodArray = psiMethodArray.findMethodsByName(this.$newFqName.getMethodName(), false)) != null ? (PsiMethod)ArraysKt.singleOrNull((Object[])psiMethodArray) : null;
                    }
                    {
                        this.$newFqName = methodFQName;
                        super(2);
                    }
                }));
            }
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ LocalQuickFix access$checkReference(OldStdlibApiInspection $this, @NotNull PsiReference reference2) {
        return $this.checkReference(reference2);
    }
}

