/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "noModifierYetApplicabilityRange", "declaration", "toDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "toVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Internal", "Private", "Protected", "Public", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "noModifierYetApplicabilityRange", "declaration", "toDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "toVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Internal", "Private", "Protected", "Public", "idea"})
public class ChangeVisibilityModifierIntention
extends SelfTargetingRangeIntention<KtDeclaration> {
    @NotNull
    private final KtModifierKeywordToken modifier;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtDeclaration element2) {
        KtModifierList modifierList;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtModifierList ktModifierList = modifierList = element2.getModifierList();
        if (ktModifierList != null ? ktModifierList.hasModifier(this.modifier) : false) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = this.toDescriptor(element2);
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithVisibility)) {
            declarationDescriptor = null;
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)declarationDescriptor;
        if (declarationDescriptorWithVisibility == null) {
            return null;
        }
        DeclarationDescriptorWithVisibility descriptor2 = declarationDescriptorWithVisibility;
        Visibility targetVisibility = this.toVisibility(this.modifier);
        if (Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)targetVisibility)) {
            return null;
        }
        KtModifierList ktModifierList2 = modifierList;
        if (ktModifierList2 != null ? ktModifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false) {
            boolean bl;
            block13: {
                void destination$iv$iv;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = descriptor2;
                if (!(declarationDescriptorWithVisibility2 instanceof CallableDescriptor)) {
                    declarationDescriptorWithVisibility2 = null;
                }
                CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptorWithVisibility2;
                if (callableDescriptor == null) {
                    return null;
                }
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                Iterable iterable = callableDescriptor2.getOverriddenDescriptors();
                Iterator iterator2 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    CallableDescriptor callableDescriptor3 = (CallableDescriptor)item$iv$iv;
                    void var15_12 = destination$iv$iv;
                    Integer n = Visibilities.compare(it.getVisibility(), targetVisibility);
                    var15_12.add(n);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    Integer it = (Integer)element$iv;
                    if (!(it == null || ((Number)it).intValue() > 0)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
        }
        this.setText(this.getDefaultText());
        PsiElement modifierElement = KtPsiUtilKt.visibilityModifier(element2);
        if (modifierElement != null) {
            return modifierElement.getTextRange();
        }
        TextRange textRange = this.noModifierYetApplicabilityRange(element2);
        if (textRange == null) {
            return null;
        }
        TextRange defaultRange = textRange;
        if (element2 instanceof KtPrimaryConstructor && defaultRange.isEmpty()) {
            this.setText("Make primary constructor " + this.modifier.getValue());
        }
        return modifierList != null ? new TextRange(PsiUtilsKt.getStartOffset((PsiElement)modifierList), defaultRange.getEndOffset()) : defaultRange;
    }

    private final DeclarationDescriptor toDescriptor(KtDeclaration $receiver) {
        BindingContext bindingContext2 = ResolutionUtils.analyze$default($receiver, null, 1, null);
        if ($receiver instanceof KtPrimaryConstructor) {
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(((KtPrimaryConstructor)$receiver).getContainingClassOrObject());
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return ((ClassDescriptor)declarationDescriptor).getUnsubstitutedPrimaryConstructor();
        }
        DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return (DeclarationDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, descriptor2);
        }
        return descriptor2;
    }

    @Override
    public void applyTo(@NotNull KtDeclaration element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiModificationUtilsKt.setVisibility(element2, this.modifier);
    }

    private final Visibility toVisibility(KtModifierKeywordToken $receiver) {
        Visibility visibility;
        KtModifierKeywordToken ktModifierKeywordToken = $receiver;
        if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PUBLIC_KEYWORD))) {
            visibility = Visibilities.PUBLIC;
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PRIVATE_KEYWORD))) {
            visibility = Visibilities.PRIVATE;
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PROTECTED_KEYWORD))) {
            visibility = Visibilities.PROTECTED;
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.INTERNAL_KEYWORD))) {
            visibility = Visibilities.INTERNAL;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown visibility modifier:" + (Object)((Object)$receiver));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"when (this) {\n          \u2026odifier:$this\")\n        }");
        return visibility;
    }

    private final TextRange noModifierYetApplicabilityRange(KtDeclaration declaration) {
        Object object;
        if (KtPsiUtil.isLocal(declaration)) {
            return null;
        }
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtNamedFunction) {
            PsiElement psiElement2 = ((KtNamedFunction)declaration).getFunKeyword();
            object = psiElement2 != null ? psiElement2.getTextRange() : null;
        } else if (ktDeclaration instanceof KtProperty) {
            object = ((KtProperty)declaration).getValOrVarKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtClass) {
            PsiElement psiElement3 = ((KtClass)declaration).getClassOrInterfaceKeyword();
            object = psiElement3 != null ? psiElement3.getTextRange() : null;
        } else if (ktDeclaration instanceof KtObjectDeclaration) {
            object = ((KtObjectDeclaration)declaration).getObjectKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtPrimaryConstructor) {
            KtParameterList ktParameterList = ((KtPrimaryConstructor)declaration).getValueParameterList();
            if (ktParameterList != null) {
                KtParameterList $receiver$iv = ktParameterList;
                KtParameterList it = $receiver$iv;
                object = TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)it), (int)0);
            } else {
                object = null;
            }
        } else if (ktDeclaration instanceof KtSecondaryConstructor) {
            object = ((KtSecondaryConstructor)declaration).getConstructorKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtParameter) {
            PsiElement psiElement4 = ((KtParameter)declaration).getValOrVarKeyword();
            object = psiElement4 != null ? psiElement4.getTextRange() : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    protected ChangeVisibilityModifierIntention(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
        super(KtDeclaration.class, "Make " + modifier.getValue(), null, 4, null);
        this.modifier = modifier;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Public;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Public;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "idea"})
    public static final class Public
    extends ChangeVisibilityModifierIntention
    implements HighPriorityAction {
        public Public() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PUBLIC_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Private;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canBePrivate", "", "declaration", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Private;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canBePrivate", "", "declaration", "idea"})
    public static final class Private
    extends ChangeVisibilityModifierIntention
    implements HighPriorityAction {
        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtDeclaration element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return this.canBePrivate(element2) ? super.applicabilityRange(element2) : (TextRange)null;
        }

        private final boolean canBePrivate(KtDeclaration declaration) {
            KtModifierList ktModifierList = declaration.getModifierList();
            return !(ktModifierList != null ? ktModifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD) : false);
        }

        public Private() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PRIVATE_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Protected;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canBeProtected", "", "declaration", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Protected;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canBeProtected", "", "declaration", "idea"})
    public static final class Protected
    extends ChangeVisibilityModifierIntention {
        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtDeclaration element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return this.canBeProtected(element2) ? super.applicabilityRange(element2) : (TextRange)null;
        }

        private final boolean canBeProtected(KtDeclaration declaration) {
            PsiElement parent2 = declaration.getParent();
            if (parent2 instanceof KtClassBody) {
                parent2 = ((KtClassBody)parent2).getParent();
            }
            return parent2 instanceof KtClass;
        }

        public Protected() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PROTECTED_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Internal;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Internal;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "idea"})
    public static final class Internal
    extends ChangeVisibilityModifierIntention {
        public Internal() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.INTERNAL_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }
}

