/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfoKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.FunctionInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.ParameterInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable.CreateCallableMemberFromUsageFactory;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateBinaryOperationActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateCallableMemberFromUsageFactory;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "createCallableInfo", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/callableBuilder/CallableInfo;", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateBinaryOperationActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateCallableMemberFromUsageFactory;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "createCallableInfo", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/callableBuilder/CallableInfo;", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "idea"})
public final class CreateBinaryOperationActionFactory
extends CreateCallableMemberFromUsageFactory<KtBinaryExpression> {
    public static final CreateBinaryOperationActionFactory INSTANCE;

    @Override
    @Nullable
    protected KtBinaryExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement().getParent();
        if (!(psiElement2 instanceof KtBinaryExpression)) {
            psiElement2 = null;
        }
        return (KtBinaryExpression)psiElement2;
    }

    @Override
    @Nullable
    protected CallableInfo createCallableInfo(@NotNull KtBinaryExpression element2, @NotNull Diagnostic diagnostic) {
        List<ParameterInfo> parameters2;
        TypeInfo typeInfo;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        IElementType iElementType = element2.getOperationToken();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
        }
        KtToken token = (KtToken)iElementType;
        KtToken ktToken = token;
        if (Intrinsics.areEqual((Object)((Object)ktToken), (Object)((Object)KtTokens.IDENTIFIER))) {
            string = element2.getOperationReference().getReferencedName();
        } else {
            Name name2 = OperatorConventions.getNameForOperationSymbol(token, false, true);
            string = name2 != null ? name2.asString() : null;
        }
        if (string == null) {
            return null;
        }
        String operationName = string;
        boolean inOperation = CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.IN_OPERATIONS), (Object)((Object)token));
        boolean comparisonOperation = CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.COMPARISON_OPERATIONS), (Object)((Object)token));
        KtExpression ktExpression = element2.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = element2.getRight();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression rightExpr = ktExpression2;
        KtExpression receiverExpr = inOperation ? rightExpr : leftExpr;
        KtExpression argumentExpr = inOperation ? leftExpr : rightExpr;
        KotlinBuiltIns builtIns = PlatformKt.getPlatform(element2).getBuiltIns();
        KtExpression ktExpression3 = receiverExpr;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"receiverExpr");
        TypeInfo receiverType = CallableInfoKt.TypeInfo(ktExpression3, Variance.IN_VARIANCE);
        if (inOperation) {
            KotlinType kotlinType = builtIns.getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"builtIns.booleanType");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType(kotlinType, Variance.INVARIANT));
        } else if (comparisonOperation) {
            KotlinType kotlinType = builtIns.getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"builtIns.intType");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType(kotlinType, Variance.INVARIANT));
        } else {
            typeInfo = CallableInfoKt.TypeInfo(element2, Variance.OUT_VARIANCE);
        }
        TypeInfo returnType2 = typeInfo;
        KtExpression ktExpression4 = argumentExpr;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"argumentExpr");
        List<ParameterInfo> list2 = parameters2 = Collections.singletonList(new ParameterInfo(CallableInfoKt.TypeInfo(ktExpression4, Variance.IN_VARIANCE), null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
        return new FunctionInfo(operationName, receiverType, returnType2, null, list2, null, Intrinsics.areEqual((Object)((Object)token), (Object)((Object)KtTokens.IDENTIFIER)) ^ true, true, 40, null);
    }

    private CreateBinaryOperationActionFactory() {
        super(false, 1, null);
        INSTANCE = this;
    }

    static {
        new CreateBinaryOperationActionFactory();
    }
}

