/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.util.TypeIndexUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a+\u0010\b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"indexTopLevelExtension", "", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinCallableStubBase;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "index", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtTypeElement;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lcom/intellij/psi/stubs/IndexSink;)V", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a+\u0010\b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, strings={"indexTopLevelExtension", "", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinCallableStubBase;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "index", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtTypeElement;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lcom/intellij/psi/stubs/IndexSink;)V", "idea-analysis"})
public final class IndexUtilsKt {
    public static final <TDeclaration extends KtCallableDeclaration> void indexTopLevelExtension(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, (String)"stub");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        if (stub.isExtension()) {
            Unit unit;
            KtCallableDeclaration declaration = (KtCallableDeclaration)stub.getPsi();
            KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KtTypeElement ktTypeElement = ktTypeReference.getTypeElement();
            if (ktTypeElement != null) {
                IndexUtilsKt.index(ktTypeElement, declaration, sink);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <TDeclaration extends KtCallableDeclaration> void index(KtTypeElement $receiver, TDeclaration declaration, IndexSink sink) {
        Function1<String, Unit> occurrence$ = new Function1<String, Unit>(declaration, sink){
            final /* synthetic */ KtCallableDeclaration $declaration;
            final /* synthetic */ IndexSink $sink;

            public final void invoke(@NotNull String typeName) {
                Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                String string = this.$declaration.getName();
                if (string == null) {
                    return;
                }
                String name2 = string;
                StubIndexKey<String, KtCallableDeclaration> stubIndexKey = KotlinTopLevelExtensionsByReceiverTypeIndex.Companion.getINSTANCE().getKey();
                String string2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                this.$sink.occurrence(stubIndexKey, (Object)KotlinTopLevelExtensionsByReceiverTypeIndex.Companion.buildKey(typeName, string2));
            }
            {
                this.$declaration = ktCallableDeclaration;
                this.$sink = indexSink;
                super(1);
            }
        };
        KtTypeElement ktTypeElement = $receiver;
        if (ktTypeElement instanceof KtUserType) {
            Object bound;
            Object v1;
            Object referenceName;
            Object it;
            void $receiver$iv;
            block18: {
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                String string = ((KtUserType)$receiver).getReferencedName();
                if (string == null) {
                    return;
                }
                objectRef.element = string;
                Iterable iterable = declaration.getTypeParameters();
                for (Object element$iv : $receiver$iv) {
                    it = (KtTypeParameter)element$iv;
                    if (!Intrinsics.areEqual((Object)((KtTypeParameter)it).getName(), (Object)((String)referenceName.element))) continue;
                    v1 = element$iv;
                    break block18;
                }
                v1 = null;
            }
            KtTypeParameter typeParameter = v1;
            if (typeParameter != null) {
                bound = typeParameter.getExtendsBound();
                if (bound != null) {
                    Unit unit;
                    KtTypeElement ktTypeElement2 = ((KtTypeReference)bound).getTypeElement();
                    if (ktTypeElement2 != null) {
                        IndexUtilsKt.index(ktTypeElement2, declaration, sink);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    occurrence$.invoke("Any");
                }
                return;
            }
            String string = (String)referenceName.element;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName");
            occurrence$.invoke(string);
            bound = TypeIndexUtilKt.aliasImportMap((KtUserType)$receiver).get((Object)((String)referenceName.element));
            for (Object element$iv : $receiver$iv) {
                Object object = it = (String)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                occurrence$.invoke((String)object);
            }
            referenceName = null;
        } else if (ktTypeElement instanceof KtNullableType) {
            Unit unit;
            KtTypeElement ktTypeElement3 = ((KtNullableType)$receiver).getInnerType();
            if (ktTypeElement3 != null) {
                IndexUtilsKt.index(ktTypeElement3, declaration, sink);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (ktTypeElement instanceof KtFunctionType) {
            int arity = ((KtFunctionType)$receiver).getParameters().size() + (((KtFunctionType)$receiver).getReceiverTypeReference() != null ? 1 : 0);
            occurrence$.invoke("Function" + arity);
        } else if (ktTypeElement instanceof KtDynamicType) {
            occurrence$.invoke("Any");
        } else {
            Void void_ = PreconditionsKt.error((Object)("Unsupported type: " + $receiver));
            throw null;
        }
    }
}

