/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0013J.\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/util/DebuggerUtils;", "", "()V", "KOTLIN_EXTENSIONS", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "bindingContextForFile", "file", "analyzeOnlyReifiedInlineFunctions", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0013J.\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, strings={"Lorg/jetbrains/kotlin/idea/util/DebuggerUtils;", "", "()V", "KOTLIN_EXTENSIONS", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "bindingContextForFile", "file", "analyzeOnlyReifiedInlineFunctions", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "idea"})
public final class DebuggerUtils {
    private static final HashSet<String> KOTLIN_EXTENSIONS;
    public static final DebuggerUtils INSTANCE;

    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope2, @NotNull JvmClassName className, @NotNull String fileName) {
        FqName partFqName;
        List<KtFile> filesWithExactName2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String extension = FileUtilRt.getExtension((String)fileName);
        if (!KOTLIN_EXTENSIONS.contains(extension)) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        List<KtFile> list2 = AddToStdlibKt.check(this.findFilesByNameInPackage(className, fileName, project, searchScope2), findSourceFileForClass.filesWithExactName.1.INSTANCE);
        if (list2 == null) {
            GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.librarySources(GlobalSearchScope.allScope((Project)project), project);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"KotlinSourceFilterScope.\u2026lScope(project), project)");
            list2 = filesWithExactName2 = this.findFilesByNameInPackage(className, fileName, project, globalSearchScope);
        }
        if (filesWithExactName2.isEmpty()) {
            return null;
        }
        if (filesWithExactName2.size() == 1) {
            return (KtFile)CollectionsKt.single(filesWithExactName2);
        }
        FqName fqName2 = partFqName = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"partFqName");
        Collection<KtFile> filesForPart = StaticFacadeIndexUtil.findFilesForFilePart(fqName2, searchScope2, project);
        if (!filesForPart.isEmpty()) {
            for (KtFile file : filesForPart) {
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)fileName)) continue;
                return file;
            }
            return null;
        }
        return (KtFile)CollectionsKt.first(filesWithExactName2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project, GlobalSearchScope searchScope2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        FqName fqName2 = className.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.packageFqName");
        Iterable iterable = PackageIndexUtil.findFilesWithExactPackage(fqName2, searchScope2, project);
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull BindingContext bindingContextForFile, @NotNull KtFile file, boolean analyzeOnlyReifiedInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkParameterIsNotNull((Object)bindingContextForFile, (String)"bindingContextForFile");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context = this.analyzeElementWithInline(resolutionFacadeForFile, bindingContextForFile, file, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file);
        for (KtElement collectedElement : analyzedElements) {
            KtFile containingFile = collectedElement.getContainingKtFile();
            toProcess.add(containingFile);
        }
        return new Pair((Object)context, new ArrayList(toProcess));
    }

    @NotNull
    public final Collection<KtElement> analyzeElementWithInline(@NotNull ResolutionFacade resolutionFacade, @NotNull BindingContext bindingContext2, @NotNull KtNamedFunction function2, boolean analyzeInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        HashSet analyzedElements = new HashSet();
        this.analyzeElementWithInline(resolutionFacade, bindingContext2, function2, 1, analyzedElements, !analyzeInlineFunctions);
        return analyzedElements;
    }

    private final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade, BindingContext bindingContext2, KtElement element2, int deep, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions) {
        Project project = element2.getProject();
        HashSet collectedElements = new HashSet();
        element2.accept(new KtTreeVisitorVoid(bindingContext2, analyzeInlineFunctions, project, analyzedElements, collectedElements){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $collectedElements;

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                Call call = (Call)this.$bindingContext.get(BindingContext.CALL, expression2);
                if (call == null) {
                    return;
                }
                Call call2 = call;
                ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get(BindingContext.RESOLVED_CALL, call2);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkParameterIsNotNull((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                block6: {
                    ? descriptor2;
                    block7: {
                        if (resolvedCall == null) {
                            return;
                        }
                        descriptor2 = resolvedCall.getResultingDescriptor();
                        if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                            return;
                        }
                        if (!InlineUtil.isInline((DeclarationDescriptor)descriptor2)) break block6;
                        if (this.$analyzeInlineFunctions) break block7;
                        ? obj = descriptor2;
                        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"descriptor");
                        if (!DebuggerUtils.access$hasReifiedTypeParameters(DebuggerUtils.INSTANCE, obj)) break block6;
                    }
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)descriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                    PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, declarationDescriptor);
                    if (declaration != null && declaration instanceof KtNamedFunction && !this.$analyzedElements.contains(declaration)) {
                        this.$collectedElements.add(declaration);
                    }
                }
            }
            {
                this.$bindingContext = $captured_local_variable$0;
                this.$analyzeInlineFunctions = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$analyzedElements = $captured_local_variable$3;
                this.$collectedElements = $captured_local_variable$4;
            }
        });
        analyzedElements.add(element2);
        if (!collectedElements.isEmpty() && deep < 10) {
            ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
            for (KtNamedFunction inlineFunctions : collectedElements) {
                KtExpression body2 = inlineFunctions.getBodyExpression();
                if (body2 == null) continue;
                BindingContext bindingContextForFunction = resolutionFacade.analyze(body2, BodyResolveMode.FULL);
                KtElement ktElement = inlineFunctions;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"inlineFunctions");
                innerContexts.add(this.analyzeElementWithInline(resolutionFacade, bindingContextForFunction, ktElement, deep + 1, analyzedElements, analyzeInlineFunctions));
            }
            innerContexts.add(bindingContext2);
            analyzedElements.addAll(collectedElements);
            return CompositeBindingContext.Companion.create((List<? extends BindingContext>)innerContexts);
        }
        return bindingContext2;
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = descriptor2.getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (!it.isReified()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private DebuggerUtils() {
        INSTANCE = this;
        KOTLIN_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"kt", "kts"});
    }

    static {
        new DebuggerUtils();
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(DebuggerUtils $this, @NotNull CallableDescriptor descriptor2) {
        return $this.hasReifiedTypeParameters(descriptor2);
    }
}

