/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0001\u00a8\u0006\n"}, d2={"fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "isAlmostEverything", "", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "ide-common"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0001\u00a8\u0006\n"}, strings={"fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "isAlmostEverything", "", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "ide-common"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(CallableDescriptor $receiver) {
        KotlinType returnType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = returnType2 = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"returnType");
        Collection collection = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"typeParameters");
        return new FuzzyType(kotlinType2, collection);
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(CallableDescriptor $receiver) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReceiverParameterDescriptor receiverParameter = $receiver.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameter.type");
            Collection collection = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"typeParameters");
            fuzzyType = new FuzzyType(kotlinType, collection);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new FuzzyType(TypeUtilsKt.makeNotNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new FuzzyType(TypeUtilsKt.makeNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return TypeUtilsKt.nullability($receiver.getType());
    }

    public static final boolean isAlmostEverything(FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if ($receiver.getFreeParameters().contains(typeParameter) ^ true) {
            return false;
        }
        KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull(typeParameter.getUpperBounds());
        return kotlinType != null ? TypeUtilsKt.isAnyOrNullableAny(kotlinType) : false;
    }
}

