/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Import;
import org.jetbrains.kotlin.j2k.ast.ImportList;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"DEFAULT_IMPORTS", "", "", "getDEFAULT_IMPORTS", "()Ljava/util/Set;", "isUnderDefaultImports", "", "c", "Lorg/jetbrains/kotlin/asJava/KtLightClass;", "convertImport", "Lorg/jetbrains/kotlin/j2k/ast/Import;", "Lorg/jetbrains/kotlin/j2k/Converter;", "anImport", "Lcom/intellij/psi/PsiImportStatementBase;", "filter", "convertImportList", "Lorg/jetbrains/kotlin/j2k/ast/ImportList;", "importList", "Lcom/intellij/psi/PsiImportList;", "filterImport", "name", "ref", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "j2k"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, strings={"DEFAULT_IMPORTS", "", "", "getDEFAULT_IMPORTS", "()Ljava/util/Set;", "isUnderDefaultImports", "", "c", "Lorg/jetbrains/kotlin/asJava/KtLightClass;", "convertImport", "Lorg/jetbrains/kotlin/j2k/ast/Import;", "Lorg/jetbrains/kotlin/j2k/Converter;", "anImport", "Lcom/intellij/psi/PsiImportStatementBase;", "filter", "convertImportList", "Lorg/jetbrains/kotlin/j2k/ast/ImportList;", "importList", "Lcom/intellij/psi/PsiImportList;", "filterImport", "name", "ref", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "j2k"})
public final class ImportsKt {
    @NotNull
    private static final Set<String> DEFAULT_IMPORTS = SetsKt.setOf((Object[])new String[]{"java.lang", "kotlin", "kotlin.annotation", "kotlin.jvm", "kotlin.collections", "kotlin.ranges", "kotlin.sequences", "kotlin.text", "kotlin.io"});

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ImportList convertImportList(Converter $receiver, @NotNull PsiImportList importList) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ImportList importList2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)importList, (String)"importList");
        Object[] objectArray = importList.getAllImportStatements();
        ImportList importList3 = importList2;
        ImportList importList4 = importList2;
        void var3_5 = $receiver$iv;
        Collection collection = new ArrayList();
        void var5_7 = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            Boolean bl;
            PsiImportStatementBase it;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i];
            PsiImportStatementBase psiImportStatementBase = it = (PsiImportStatementBase)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiImportStatementBase, (String)"it");
            if (ImportsKt.convertImport($receiver, psiImportStatementBase, true) != null) {
                void $receiver$iv$iv$iv2;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        List list2 = (List)destination$iv$iv;
        importList3(list2);
        return (ImportList)ElementKt.assignPrototype$default(importList4, (PsiElement)importList, null, 2, null);
    }

    @Nullable
    public static final Import convertImport(Converter $receiver, @NotNull PsiImportStatementBase anImport, boolean filter2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)anImport, (String)"anImport");
        Function0<Import> doConvert$ = new Function0<Import>($receiver, anImport, filter2){
            final /* synthetic */ Converter receiver$0;
            final /* synthetic */ PsiImportStatementBase $anImport;
            final /* synthetic */ boolean $filter;

            @Nullable
            public final Import invoke() {
                Import import_;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.$anImport.getImportReference();
                if (psiJavaCodeReferenceElement == null) {
                    return null;
                }
                PsiJavaCodeReferenceElement reference2 = psiJavaCodeReferenceElement;
                String string = reference2.getQualifiedName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String qualifiedName = UtilsKt.quoteKeywords(string);
                if (this.$anImport.isOnDemand()) {
                    return new Import(qualifiedName + ".*");
                }
                if (this.$filter) {
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement2 = reference2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaCodeReferenceElement2, (String)"reference");
                    String filteredName = ImportsKt.access$filterImport(this.receiver$0, qualifiedName, psiJavaCodeReferenceElement2);
                    import_ = filteredName != null ? new Import(filteredName) : (Import)null;
                } else {
                    import_ = new Import(qualifiedName);
                }
                return import_;
            }
            {
                this.receiver$0 = converter;
                this.$anImport = psiImportStatementBase;
                this.$filter = bl;
                super(0);
            }
        };
        Object object = doConvert$.invoke();
        return object != null ? (Import)ElementKt.assignPrototype$default((Element)object, (PsiElement)anImport, null, 2, null) : null;
    }

    private static final String filterImport(Converter $receiver, String name2, PsiJavaCodeReferenceElement ref) {
        if ($receiver.getAnnotationConverter().isImportNotRequired(name2)) {
            return null;
        }
        if (!JavaToKotlinClassMap.INSTANCE.mapPlatformClass(new FqName(name2)).isEmpty()) {
            return null;
        }
        PsiElement target = ref.resolve();
        if (target instanceof KtLightClassForFacade) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((KtLightClassForFacade)target).getFqName().parent().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.getFqName().parent().toString()");
            return stringBuilder.append(UtilsKt.quoteKeywords(string)).append(".*").toString();
        }
        if (target instanceof KtLightClass) {
            if (UtilsKt.isFacadeClassFromLibrary(target)) {
                return null;
            }
            if (ImportsKt.isUnderDefaultImports((KtLightClass)target)) {
                return null;
            }
        }
        return name2;
    }

    @NotNull
    public static final Set<String> getDEFAULT_IMPORTS() {
        return DEFAULT_IMPORTS;
    }

    public static final boolean isUnderDefaultImports(@NotNull KtLightClass c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return DEFAULT_IMPORTS.contains(c.getFqName().parent().asString());
    }

    @Nullable
    public static final /* synthetic */ String access$filterImport(Converter $receiver, @NotNull String name2, @NotNull PsiJavaCodeReferenceElement ref) {
        return ImportsKt.filterImport($receiver, name2, ref);
    }
}

