/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.AbstractKotlinParsing;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.kotlin.parsing.Consumer;
import org.jetbrains.kotlin.parsing.DoNotBindAnything;
import org.jetbrains.kotlin.parsing.FirstBefore;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.parsing.LastBefore;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderForByClause;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;

public class KotlinParsing
extends AbstractKotlinParsing {
    private static final Logger LOG = Logger.getInstance(KotlinParsing.class);
    public static final Map<String, IElementType> MODIFIER_KEYWORD_MAP = new HashMap<String, IElementType>();
    private static final TokenSet TOP_LEVEL_DECLARATION_FIRST;
    private static final TokenSet DECLARATION_FIRST;
    private static final TokenSet CLASS_NAME_RECOVERY_SET;
    private static final TokenSet TYPE_PARAMETER_GT_RECOVERY_SET;
    private static final TokenSet PARAMETER_NAME_RECOVERY_SET;
    private static final TokenSet PACKAGE_NAME_RECOVERY_SET;
    private static final TokenSet IMPORT_RECOVERY_SET;
    static final TokenSet TYPE_REF_FIRST;
    private static final TokenSet RECEIVER_TYPE_TERMINATORS;
    private static final TokenSet VALUE_PARAMETER_FIRST;
    private static final TokenSet LAMBDA_VALUE_PARAMETER_FIRST;
    private static final TokenSet SOFT_KEYWORDS_AT_MEMBER_START;
    private static final TokenSet ANNOTATION_TARGETS;
    private KotlinExpressionParsing myExpressionParsing;
    private static final TokenSet NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER;

    static KotlinParsing createForTopLevel(SemanticWhitespaceAwarePsiBuilder builder) {
        KotlinParsing jetParsing = new KotlinParsing(builder);
        jetParsing.myExpressionParsing = new KotlinExpressionParsing(builder, jetParsing);
        return jetParsing;
    }

    private static KotlinParsing createForByClause(SemanticWhitespaceAwarePsiBuilder builder) {
        final SemanticWhitespaceAwarePsiBuilderForByClause builderForByClause = new SemanticWhitespaceAwarePsiBuilderForByClause(builder);
        KotlinParsing jetParsing = new KotlinParsing(builderForByClause);
        jetParsing.myExpressionParsing = new KotlinExpressionParsing(builderForByClause, jetParsing){

            @Override
            protected boolean parseCallWithClosure() {
                if (builderForByClause.getStackSize() > 0) {
                    return super.parseCallWithClosure();
                }
                return false;
            }

            @Override
            protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
                return KotlinParsing.createForByClause(builder);
            }
        };
        return jetParsing;
    }

    private KotlinParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        super(builder);
    }

    void parseFile() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        while (!this.eof()) {
            this.parseTopLevelDeclaration();
        }
        fileMarker.done((IElementType)KtNodeTypes.KT_FILE);
    }

    void parseTypeCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.parseTypeRef();
        this.checkForUnexpectedSymbols();
        marker.done((IElementType)KtNodeTypes.TYPE_CODE_FRAGMENT);
    }

    void parseExpressionCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.myExpressionParsing.parseExpression();
        this.checkForUnexpectedSymbols();
        marker.done((IElementType)KtNodeTypes.EXPRESSION_CODE_FRAGMENT);
    }

    void parseBlockCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        if (this.at(KtTokens.PACKAGE_KEYWORD) || this.at(KtTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker err = this.mark();
            this.parsePreamble();
            err.error("Package directive and imports are forbidden in code fragments");
        }
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done((IElementType)KtNodeTypes.BLOCK);
        marker.done((IElementType)KtNodeTypes.BLOCK_CODE_FRAGMENT);
    }

    void parseScript() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        PsiBuilder.Marker scriptMarker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        this.myExpressionParsing.parseStatements(true);
        this.checkForUnexpectedSymbols();
        blockMarker.done((IElementType)KtNodeTypes.BLOCK);
        scriptMarker.done(KtNodeTypes.SCRIPT);
        fileMarker.done((IElementType)KtNodeTypes.KT_FILE);
    }

    private void checkForUnexpectedSymbols() {
        while (!this.eof()) {
            this.errorAndAdvance("unexpected symbol");
        }
    }

    private void parsePreamble() {
        PsiBuilder.Marker firstEntry = this.mark();
        this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_BEFORE_PACKAGE);
        PsiBuilder.Marker packageDirective = this.mark();
        this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        if (this.at(KtTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.parsePackageName();
            firstEntry.drop();
            this.consumeIf(KtTokens.SEMICOLON);
            packageDirective.done(KtNodeTypes.PACKAGE_DIRECTIVE);
        } else {
            firstEntry.rollbackTo();
            this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED);
            packageDirective = this.mark();
            packageDirective.done(KtNodeTypes.PACKAGE_DIRECTIVE);
            packageDirective.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)DoNotBindAnything.INSTANCE, null);
        }
        this.parseImportDirectives();
    }

    private void parsePackageName() {
        PsiBuilder.Marker qualifiedExpression = this.mark();
        boolean simpleName = true;
        while (true) {
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                this.errorWithRecovery("Package name must be a '.'-separated identifier list placed on a single line", PACKAGE_NAME_RECOVERY_SET);
                break;
            }
            if (this.at(KtTokens.DOT)) {
                this.advance();
                qualifiedExpression.error("Package name must be a '.'-separated identifier list");
                qualifiedExpression = this.mark();
                continue;
            }
            PsiBuilder.Marker nsName = this.mark();
            boolean simpleNameFound = this.expect(KtTokens.IDENTIFIER, "Package name must be a '.'-separated identifier list", PACKAGE_NAME_RECOVERY_SET);
            if (simpleNameFound) {
                nsName.done(KtNodeTypes.REFERENCE_EXPRESSION);
            } else {
                nsName.drop();
            }
            if (!simpleName) {
                PsiBuilder.Marker precedingMarker = qualifiedExpression.precede();
                qualifiedExpression.done(KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
                qualifiedExpression = precedingMarker;
            }
            if (!this.at(KtTokens.DOT)) break;
            this.advance();
            if (simpleName && !simpleNameFound) {
                qualifiedExpression.drop();
                qualifiedExpression = this.mark();
                continue;
            }
            simpleName = false;
        }
        qualifiedExpression.drop();
    }

    private void parseImportDirective() {
        assert (this._at(KtTokens.IMPORT_KEYWORD));
        PsiBuilder.Marker importDirective = this.mark();
        this.advance();
        if (this.closeImportWithErrorIfNewline(importDirective, "Expecting qualified name")) {
            return;
        }
        if (!this.at(KtTokens.IDENTIFIER)) {
            PsiBuilder.Marker error = this.mark();
            this.skipUntil(TokenSet.create((IElementType[])new IElementType[]{KtTokens.EOL_OR_SEMICOLON}));
            error.error("Expecting qualified name");
            importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
            this.consumeIf(KtTokens.SEMICOLON);
            return;
        }
        PsiBuilder.Marker qualifiedName = this.mark();
        PsiBuilder.Marker reference2 = this.mark();
        this.advance();
        reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
        while (this.at(KtTokens.DOT) && this.lookahead(1) != KtTokens.MUL) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Import must be placed on a single line")) {
                qualifiedName.drop();
                return;
            }
            reference2 = this.mark();
            if (this.expect(KtTokens.IDENTIFIER, "Qualified name must be a '.'-separated identifier list", IMPORT_RECOVERY_SET)) {
                reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            } else {
                reference2.drop();
            }
            PsiBuilder.Marker precede = qualifiedName.precede();
            qualifiedName.done(KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
            qualifiedName = precede;
        }
        qualifiedName.drop();
        if (this.at(KtTokens.DOT)) {
            this.advance();
            assert (this._at(KtTokens.MUL));
            this.advance();
            if (this.at(KtTokens.AS_KEYWORD)) {
                PsiBuilder.Marker as = this.mark();
                this.advance();
                if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                    as.drop();
                    return;
                }
                this.consumeIf(KtTokens.IDENTIFIER);
                as.error("Cannot rename all imported items to one identifier");
            }
        }
        if (this.at(KtTokens.AS_KEYWORD)) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                return;
            }
            this.expect(KtTokens.IDENTIFIER, "Expecting identifier", TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON}));
        }
        this.consumeIf(KtTokens.SEMICOLON);
        importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
        importDirective.setCustomEdgeTokenBinders(null, (WhitespacesAndCommentsBinder)TrailingCommentsBinder.INSTANCE);
    }

    private boolean closeImportWithErrorIfNewline(PsiBuilder.Marker importDirective, String errorMessage) {
        if (this.myBuilder.newlineBeforeCurrentToken()) {
            this.error(errorMessage);
            importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
            return true;
        }
        return false;
    }

    private void parseImportDirectives() {
        PsiBuilder.Marker importList = this.mark();
        if (!this.at(KtTokens.IMPORT_KEYWORD)) {
            importList.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)DoNotBindAnything.INSTANCE, null);
        }
        while (this.at(KtTokens.IMPORT_KEYWORD)) {
            this.parseImportDirective();
        }
        importList.done(KtNodeTypes.IMPORT_LIST);
    }

    private void parseTopLevelDeclaration() {
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        ModifierDetector detector2 = new ModifierDetector();
        this.parseModifierList(detector2, AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == KtTokens.CLASS_KEYWORD || keywordToken == KtTokens.INTERFACE_KEYWORD) {
            declType = this.parseClass(detector2.isEnumDetected());
        } else if (keywordToken == KtTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == KtTokens.VAL_KEYWORD || keywordToken == KtTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == KtTokens.OBJECT_KEYWORD) {
            this.parseObject(NameParsingMode.REQUIRED, true);
            declType = KtNodeTypes.OBJECT_DECLARATION;
        } else if (this.at(KtTokens.LBRACE)) {
            this.error("Expecting a top level declaration");
            this.parseBlock();
            declType = KtNodeTypes.FUN;
        }
        if (declType == null) {
            this.errorAndAdvance("Expecting a top level declaration");
            decl.drop();
        } else {
            KotlinParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    boolean parseModifierList(@NotNull AnnotationParsingMode annotationParsingMode, @NotNull TokenSet noModifiersBefore) {
        if (annotationParsingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParsingMode", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseModifierList"));
        }
        if (noModifiersBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noModifiersBefore", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseModifierList"));
        }
        return this.parseModifierList(null, annotationParsingMode, noModifiersBefore);
    }

    boolean parseModifierList(@Nullable Consumer<IElementType> tokenConsumer, @NotNull AnnotationParsingMode annotationParsingMode, @NotNull TokenSet noModifiersBefore) {
        if (annotationParsingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParsingMode", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseModifierList"));
        }
        if (noModifiersBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noModifiersBefore", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseModifierList"));
        }
        PsiBuilder.Marker list2 = this.mark();
        boolean empty2 = true;
        while (!this.eof()) {
            if (this.at(KtTokens.AT) && annotationParsingMode.allowAnnotations) {
                this.parseAnnotationOrList(annotationParsingMode);
            } else if (!this.tryParseModifier(tokenConsumer, noModifiersBefore)) {
                if (!annotationParsingMode.allowShortAnnotations || !this.at(KtTokens.IDENTIFIER)) break;
                this.error("Use '@' symbol before annotations");
                this.parseAnnotation(annotationParsingMode);
            }
            empty2 = false;
        }
        if (empty2) {
            list2.drop();
        } else {
            list2.done(KtNodeTypes.MODIFIER_LIST);
        }
        return !empty2;
    }

    private boolean tryParseModifier(@Nullable Consumer<IElementType> tokenConsumer, @NotNull TokenSet noModifiersBefore) {
        IElementType lookahead;
        if (noModifiersBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noModifiersBefore", "org/jetbrains/kotlin/parsing/KotlinParsing", "tryParseModifier"));
        }
        PsiBuilder.Marker marker = this.mark();
        if (this.atSet(KtTokens.MODIFIER_KEYWORDS) && (lookahead = this.lookahead(1)) != null && !noModifiersBefore.contains(lookahead)) {
            IElementType tt = this.tt();
            if (tokenConsumer != null) {
                tokenConsumer.consume(tt);
            }
            this.advance();
            marker.collapse(tt);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    private void parseFileAnnotationList(AnnotationParsingMode mode) {
        if (!mode.isFileAnnotationParsingMode) {
            LOG.error("expected file annotation parsing mode, but:" + (Object)((Object)mode));
        }
        PsiBuilder.Marker fileAnnotationsList = this.mark();
        if (this.parseAnnotations(mode)) {
            fileAnnotationsList.done(KtNodeTypes.FILE_ANNOTATION_LIST);
        } else {
            fileAnnotationsList.drop();
        }
    }

    boolean parseAnnotations(AnnotationParsingMode mode) {
        if (!this.parseAnnotationOrList(mode)) {
            return false;
        }
        while (this.parseAnnotationOrList(mode)) {
        }
        return true;
    }

    private boolean parseAnnotationOrList(AnnotationParsingMode mode) {
        if (this.at(KtTokens.AT)) {
            IElementType nextRawToken;
            IElementType tokenToMatch = nextRawToken = this.myBuilder.rawLookup(1);
            boolean isTargetedAnnotation = false;
            if ((nextRawToken == KtTokens.IDENTIFIER || ANNOTATION_TARGETS.contains(nextRawToken)) && this.lookahead(2) == KtTokens.COLON) {
                tokenToMatch = this.lookahead(3);
                isTargetedAnnotation = true;
            } else if (this.lookahead(1) == KtTokens.COLON) {
                isTargetedAnnotation = true;
                tokenToMatch = this.lookahead(2);
            }
            if (tokenToMatch == KtTokens.IDENTIFIER) {
                return this.parseAnnotation(mode);
            }
            if (tokenToMatch == KtTokens.LBRACKET) {
                return this.parseAnnotationList(mode);
            }
            if (isTargetedAnnotation) {
                if (this.lookahead(1) == KtTokens.COLON) {
                    this.errorAndAdvance("Expected annotation identifier after ':'", 2);
                } else {
                    this.errorAndAdvance("Expected annotation identifier after ':'", 3);
                }
            } else {
                this.errorAndAdvance("Expected annotation identifier after '@'", 1);
            }
            return true;
        }
        return false;
    }

    private boolean parseAnnotationList(AnnotationParsingMode mode) {
        assert (this._at(KtTokens.AT));
        PsiBuilder.Marker annotation2 = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.parseAnnotationTargetIfNeeded(mode)) {
            annotation2.rollbackTo();
            this.myBuilder.restoreNewlinesState();
            return false;
        }
        assert (this._at(KtTokens.LBRACKET));
        this.advance();
        if (!this.at(KtTokens.IDENTIFIER) && !this.at(KtTokens.AT)) {
            this.error("Expecting a list of annotations");
        } else {
            while (this.at(KtTokens.IDENTIFIER) || this.at(KtTokens.AT)) {
                if (this.at(KtTokens.AT)) {
                    this.errorAndAdvance("No '@' needed in annotation list");
                    continue;
                }
                this.parseAnnotation(AnnotationParsingMode.IN_ANNOTATION_LIST);
                while (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("No commas needed to separate annotations");
                }
            }
        }
        this.expect(KtTokens.RBRACKET, "Expecting ']' to close the annotation list");
        this.myBuilder.restoreNewlinesState();
        annotation2.done(KtNodeTypes.ANNOTATION);
        return true;
    }

    private boolean parseAnnotationTargetIfNeeded(AnnotationParsingMode mode) {
        String expectedAnnotationTargetBeforeColon = "Expected annotation target before ':'";
        if (this.at(KtTokens.COLON)) {
            this.errorAndAdvance(expectedAnnotationTargetBeforeColon);
            return true;
        }
        KtKeywordToken targetKeyword = this.atTargetKeyword();
        if (mode == AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED && (targetKeyword != KtTokens.FILE_KEYWORD || this.lookahead(1) != KtTokens.COLON)) {
            return false;
        }
        if (this.lookahead(1) == KtTokens.COLON && targetKeyword == null && this.at(KtTokens.IDENTIFIER)) {
            this.errorAndAdvance(expectedAnnotationTargetBeforeColon);
            this.advance();
            return true;
        }
        if (targetKeyword == null && mode.isFileAnnotationParsingMode) {
            this.parseAnnotationTarget(mode, KtTokens.FILE_KEYWORD);
        } else if (targetKeyword != null) {
            this.parseAnnotationTarget(mode, targetKeyword);
        }
        return true;
    }

    private void parseAnnotationTarget(AnnotationParsingMode mode, KtKeywordToken keyword) {
        if (keyword == KtTokens.FILE_KEYWORD && !mode.isFileAnnotationParsingMode && this.at(keyword) && this.lookahead(1) == KtTokens.COLON) {
            this.errorAndAdvance(KtTokens.AT.getValue() + keyword.getValue() + " annotations are only allowed before package declaration", 2);
            return;
        }
        String message2 = "Expecting \"" + keyword.getValue() + KtTokens.COLON.getValue() + "\" prefix for " + keyword.getValue() + " annotations";
        PsiBuilder.Marker marker = this.mark();
        if (!this.expect(keyword, message2)) {
            marker.drop();
        } else {
            marker.done(KtNodeTypes.ANNOTATION_TARGET);
        }
        this.expect(KtTokens.COLON, message2, TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.RBRACKET, KtTokens.LBRACKET}));
    }

    @Nullable
    private KtKeywordToken atTargetKeyword() {
        for (IElementType target : ANNOTATION_TARGETS.getTypes()) {
            if (!this.at(target)) continue;
            return (KtKeywordToken)target;
        }
        return null;
    }

    private boolean parseAnnotation(AnnotationParsingMode mode) {
        assert (this._at(KtTokens.IDENTIFIER) || this._at(KtTokens.AT) && !KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(1)));
        PsiBuilder.Marker annotation2 = this.mark();
        boolean atAt = this.at(KtTokens.AT);
        if (atAt) {
            this.advance();
        }
        if (atAt && !this.parseAnnotationTargetIfNeeded(mode)) {
            annotation2.rollbackTo();
            return false;
        }
        PsiBuilder.Marker reference2 = this.mark();
        PsiBuilder.Marker typeReference = this.mark();
        this.parseUserType();
        typeReference.done(KtNodeTypes.TYPE_REFERENCE);
        reference2.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
        this.parseTypeArgumentList();
        if (this.at(KtTokens.LPAR)) {
            this.myExpressionParsing.parseValueArgumentList();
        }
        annotation2.done(KtNodeTypes.ANNOTATION_ENTRY);
        return true;
    }

    IElementType parseClassOrObject(boolean object, NameParsingMode nameParsingMode, boolean optionalBody, boolean enumClass) {
        if (object ? !$assertionsDisabled && !this._at(KtTokens.OBJECT_KEYWORD) : !$assertionsDisabled && !this._atSet(KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD)) {
            throw new AssertionError();
        }
        this.advance();
        if (nameParsingMode == NameParsingMode.REQUIRED) {
            this.expect(KtTokens.IDENTIFIER, "Name expected", CLASS_NAME_RECOVERY_SET);
        } else {
            assert (object) : "Must be an object to be nameless";
            if (this.at(KtTokens.IDENTIFIER)) {
                if (nameParsingMode == NameParsingMode.PROHIBITED) {
                    this.errorAndAdvance("An object expression cannot bind a name");
                } else {
                    assert (nameParsingMode == NameParsingMode.ALLOWED);
                    this.advance();
                }
            }
        }
        AbstractKotlinParsing.OptionalMarker typeParamsMarker = new AbstractKotlinParsing.OptionalMarker(this, object);
        boolean typeParametersDeclared = this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        typeParamsMarker.error("Type parameters are not allowed for objects");
        PsiBuilder.Marker beforeConstructorModifiers = this.mark();
        PsiBuilder.Marker primaryConstructorMarker = this.mark();
        boolean hasConstructorModifiers = this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        if (hasConstructorModifiers && !this.atSet(KtTokens.LPAR, KtTokens.LBRACE, KtTokens.COLON, KtTokens.CONSTRUCTOR_KEYWORD)) {
            beforeConstructorModifiers.rollbackTo();
            return object ? KtNodeTypes.OBJECT_DECLARATION : KtNodeTypes.CLASS;
        }
        beforeConstructorModifiers.drop();
        boolean hasConstructorKeyword = this.at(KtTokens.CONSTRUCTOR_KEYWORD);
        if (hasConstructorKeyword) {
            this.advance();
        }
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, true, TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.RBRACE}));
            primaryConstructorMarker.done(KtNodeTypes.PRIMARY_CONSTRUCTOR);
        } else if (hasConstructorModifiers || hasConstructorKeyword) {
            primaryConstructorMarker.done(KtNodeTypes.PRIMARY_CONSTRUCTOR);
            if (hasConstructorKeyword) {
                this.error("Expecting primary constructor parameter list");
            } else {
                this.error("Expecting 'constructor' keyword");
            }
        } else {
            primaryConstructorMarker.drop();
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseDelegationSpecifierList();
        }
        AbstractKotlinParsing.OptionalMarker whereMarker = new AbstractKotlinParsing.OptionalMarker(this, object);
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        whereMarker.error("Where clause is not allowed for objects");
        if (this.at(KtTokens.LBRACE)) {
            if (enumClass) {
                this.parseEnumClassBody();
            } else {
                this.parseClassBody();
            }
        } else if (!optionalBody) {
            PsiBuilder.Marker fakeBody = this.mark();
            this.error("Expecting a class body");
            fakeBody.done(KtNodeTypes.CLASS_BODY);
        }
        return object ? KtNodeTypes.OBJECT_DECLARATION : KtNodeTypes.CLASS;
    }

    IElementType parseClass(boolean enumClass) {
        return this.parseClassOrObject(false, NameParsingMode.REQUIRED, true, enumClass);
    }

    void parseObject(NameParsingMode nameParsingMode, boolean optionalBody) {
        this.parseClassOrObject(true, nameParsingMode, optionalBody, false);
    }

    private void parseEnumClassBody() {
        if (!this.at(KtTokens.LBRACE)) {
            return;
        }
        PsiBuilder.Marker body2 = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        if (!this.parseEnumEntries() && !this.at(KtTokens.RBRACE)) {
            this.error("Expecting ';' after the last enum entry or '}' to close enum class body");
        }
        this.parseMembers();
        this.expect(KtTokens.RBRACE, "Expecting '}' to close enum class body");
        this.myBuilder.restoreNewlinesState();
        body2.done(KtNodeTypes.CLASS_BODY);
    }

    private boolean parseEnumEntries() {
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            switch (this.parseEnumEntry()) {
                case FAILED: {
                    if (this.at(KtTokens.SEMICOLON)) {
                        this.advance();
                        return true;
                    }
                    return false;
                }
                case NO_DELIMITER: {
                    return false;
                }
                case COMMA_DELIMITER: {
                    break;
                }
                case SEMICOLON_DELIMITER: {
                    return true;
                }
            }
        }
        return false;
    }

    private ParseEnumEntryResult parseEnumEntry() {
        PsiBuilder.Marker entry = this.mark();
        this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.COMMA, KtTokens.SEMICOLON, KtTokens.RBRACE}));
        if (!this.atSet(SOFT_KEYWORDS_AT_MEMBER_START) && this.at(KtTokens.IDENTIFIER)) {
            boolean semicolonFound;
            boolean commaFound;
            this.advance();
            if (this.at(KtTokens.LPAR)) {
                PsiBuilder.Marker initializerList = this.mark();
                PsiBuilder.Marker delegatorSuperCall = this.mark();
                PsiBuilder.Marker callee = this.mark();
                PsiBuilder.Marker typeReference = this.mark();
                PsiBuilder.Marker type2 = this.mark();
                PsiBuilder.Marker referenceExpr = this.mark();
                referenceExpr.done(KtNodeTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION);
                type2.done(KtNodeTypes.USER_TYPE);
                typeReference.done(KtNodeTypes.TYPE_REFERENCE);
                callee.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
                this.myExpressionParsing.parseValueArgumentList();
                delegatorSuperCall.done(KtNodeTypes.SUPER_TYPE_CALL_ENTRY);
                initializerList.done(KtNodeTypes.INITIALIZER_LIST);
            }
            if (this.at(KtTokens.LBRACE)) {
                this.parseClassBody();
            }
            if (commaFound = this.at(KtTokens.COMMA)) {
                this.advance();
            }
            if (semicolonFound = this.at(KtTokens.SEMICOLON)) {
                this.advance();
            }
            KotlinParsing.closeDeclarationWithCommentBinders(entry, KtNodeTypes.ENUM_ENTRY, true);
            return semicolonFound ? ParseEnumEntryResult.SEMICOLON_DELIMITER : (commaFound ? ParseEnumEntryResult.COMMA_DELIMITER : ParseEnumEntryResult.NO_DELIMITER);
        }
        entry.rollbackTo();
        return ParseEnumEntryResult.FAILED;
    }

    private void parseClassBody() {
        PsiBuilder.Marker body2 = this.mark();
        this.myBuilder.enableNewlines();
        if (this.expect(KtTokens.LBRACE, "Expecting a class body")) {
            this.parseMembers();
            this.expect(KtTokens.RBRACE, "Missing '}");
        }
        this.myBuilder.restoreNewlinesState();
        body2.done(KtNodeTypes.CLASS_BODY);
    }

    private void parseMembers() {
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            this.parseMemberDeclaration();
        }
    }

    private void parseMemberDeclaration() {
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        ModifierDetector detector2 = new ModifierDetector();
        this.parseModifierList(detector2, AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        IElementType declType = this.parseMemberDeclarationRest(detector2.isEnumDetected(), detector2.isDefaultDetected());
        if (declType == null) {
            this.errorWithRecovery("Expecting member declaration", TokenSet.EMPTY);
            decl.drop();
        } else {
            KotlinParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    private IElementType parseMemberDeclarationRest(boolean isEnum, boolean isDefault) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == KtTokens.CLASS_KEYWORD || keywordToken == KtTokens.INTERFACE_KEYWORD) {
            declType = this.parseClass(isEnum);
        } else if (keywordToken == KtTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == KtTokens.VAL_KEYWORD || keywordToken == KtTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == KtTokens.OBJECT_KEYWORD) {
            this.parseObject(isDefault ? NameParsingMode.ALLOWED : NameParsingMode.REQUIRED, true);
            declType = KtNodeTypes.OBJECT_DECLARATION;
        } else if (this.at(KtTokens.INIT_KEYWORD)) {
            this.advance();
            if (this.at(KtTokens.LBRACE)) {
                this.parseBlock();
            } else {
                this.mark().error("Expecting '{' after 'init'");
            }
            declType = KtNodeTypes.CLASS_INITIALIZER;
        } else if (this.at(KtTokens.CONSTRUCTOR_KEYWORD)) {
            this.parseSecondaryConstructor();
            declType = KtNodeTypes.SECONDARY_CONSTRUCTOR;
        } else if (this.at(KtTokens.LBRACE)) {
            this.error("Expecting member declaration");
            this.parseBlock();
            declType = KtNodeTypes.FUN;
        }
        return declType;
    }

    private void parseSecondaryConstructor() {
        assert (this._at(KtTokens.CONSTRUCTOR_KEYWORD));
        this.advance();
        TokenSet valueArgsRecoverySet = TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.SEMICOLON, KtTokens.RPAR, KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE});
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, true, valueArgsRecoverySet);
        } else {
            this.errorWithRecovery("Expecting '('", TokenSet.orSet((TokenSet[])new TokenSet[]{valueArgsRecoverySet, TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON})}));
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            PsiBuilder.Marker delegationCall = this.mark();
            if (this.at(KtTokens.THIS_KEYWORD) || this.at(KtTokens.SUPER_KEYWORD)) {
                this.parseThisOrSuper();
                this.myExpressionParsing.parseValueArgumentList();
            } else {
                this.error("Expecting a 'this' or 'super' constructor call");
                PsiBuilder.Marker beforeWrongDelegationCallee = null;
                if (!this.at(KtTokens.LPAR)) {
                    beforeWrongDelegationCallee = this.mark();
                    this.advance();
                }
                this.myExpressionParsing.parseValueArgumentList();
                if (beforeWrongDelegationCallee != null) {
                    if (this.at(KtTokens.LBRACE)) {
                        beforeWrongDelegationCallee.drop();
                    } else {
                        beforeWrongDelegationCallee.rollbackTo();
                    }
                }
            }
            delegationCall.done(KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        } else {
            PsiBuilder.Marker emptyDelegationCall = this.mark();
            this.mark().done((IElementType)KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
            emptyDelegationCall.done(KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        }
        if (this.at(KtTokens.LBRACE)) {
            this.parseBlock();
        }
    }

    private void parseThisOrSuper() {
        assert (this._at(KtTokens.THIS_KEYWORD) || this._at(KtTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done((IElementType)KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
    }

    private IElementType parseProperty() {
        return this.parseProperty(false);
    }

    public IElementType parseProperty(boolean local) {
        assert (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD));
        this.advance();
        boolean typeParametersDeclared = this.at(KtTokens.LT) && this.parseTypeParameterList(TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.EQ, KtTokens.COLON, KtTokens.SEMICOLON}));
        TokenSet propertyNameFollow = TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.EQ, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.SEMICOLON, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.CLASS_KEYWORD});
        this.myBuilder.disableJoiningComplexTokens();
        PsiBuilder.Marker receiver = this.mark();
        boolean receiverTypeDeclared = this.parseReceiverType("property", propertyNameFollow);
        boolean multiDeclaration = this.at(KtTokens.LPAR);
        KotlinParsing.errorIf(receiver, multiDeclaration && receiverTypeDeclared, "Receiver type is not allowed on a destructuring declaration");
        if (multiDeclaration) {
            PsiBuilder.Marker multiDecl = this.mark();
            this.parseMultiDeclarationName(propertyNameFollow);
            KotlinParsing.errorIf(multiDecl, !local, "Destructuring declarations are only allowed for local variables/values");
        } else {
            this.parseFunctionOrPropertyName(receiverTypeDeclared, "property", propertyNameFollow, false);
        }
        this.myBuilder.restoreJoiningComplexTokensState();
        if (this.at(KtTokens.COLON)) {
            PsiBuilder.Marker type2 = this.mark();
            this.advance();
            this.parseTypeRef();
            KotlinParsing.errorIf(type2, multiDeclaration, "Type annotations are not allowed on destructuring declarations");
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (local) {
            if (this.at(KtTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
            } else if (this.at(KtTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
            }
        } else {
            if (this.at(KtTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
                this.consumeIf(KtTokens.SEMICOLON);
            } else if (this.at(KtTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
                this.consumeIf(KtTokens.SEMICOLON);
            }
            AccessorKind accessorKind = this.parsePropertyGetterOrSetter(null);
            if (accessorKind != null) {
                this.parsePropertyGetterOrSetter(accessorKind);
            }
            if (!this.atSet(KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE)) {
                if (this.getLastToken() != KtTokens.SEMICOLON) {
                    this.errorUntil("Property getter or setter expected", TokenSet.create((IElementType[])new IElementType[]{KtTokens.EOL_OR_SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE}));
                }
            } else {
                this.consumeIf(KtTokens.SEMICOLON);
            }
        }
        return multiDeclaration ? KtNodeTypes.DESTRUCTURING_DECLARATION : KtNodeTypes.PROPERTY;
    }

    private void parsePropertyDelegate() {
        assert (this._at(KtTokens.BY_KEYWORD));
        PsiBuilder.Marker delegate2 = this.mark();
        this.advance();
        this.myExpressionParsing.parseExpression();
        delegate2.done((IElementType)KtNodeTypes.PROPERTY_DELEGATE);
    }

    public void parseMultiDeclarationName(TokenSet follow) {
        this.myBuilder.disableNewlines();
        this.advance();
        TokenSet recoverySet = TokenSet.orSet((TokenSet[])new TokenSet[]{PARAMETER_NAME_RECOVERY_SET, follow});
        if (!this.atSet(follow)) {
            while (true) {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a name");
                } else if (this.at(KtTokens.RPAR)) {
                    this.error("Expecting a name");
                    break;
                }
                PsiBuilder.Marker property2 = this.mark();
                this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.COMMA, KtTokens.RPAR, KtTokens.COLON, KtTokens.EQ}));
                this.expect(KtTokens.IDENTIFIER, "Expecting a name", recoverySet);
                if (this.at(KtTokens.COLON)) {
                    this.advance();
                    this.parseTypeRef(follow);
                }
                property2.done(KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY);
                if (!this.at(KtTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(KtTokens.RPAR, "Expecting ')'", follow);
        this.myBuilder.restoreNewlinesState();
    }

    @Nullable
    private AccessorKind parsePropertyGetterOrSetter(@Nullable AccessorKind notAllowedKind) {
        AccessorKind accessorKind;
        PsiBuilder.Marker getterOrSetter = this.mark();
        this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        if (this.at(KtTokens.GET_KEYWORD)) {
            accessorKind = AccessorKind.GET;
        } else if (this.at(KtTokens.SET_KEYWORD)) {
            accessorKind = AccessorKind.SET;
        } else {
            getterOrSetter.rollbackTo();
            return null;
        }
        if (accessorKind == notAllowedKind) {
            getterOrSetter.rollbackTo();
            return null;
        }
        this.advance();
        if (!this.at(KtTokens.LPAR)) {
            TokenSet ACCESSOR_FIRST_OR_PROPERTY_END = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.MODIFIER_KEYWORDS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.AT, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE})});
            if (!this.atSet(ACCESSOR_FIRST_OR_PROPERTY_END)) {
                this.errorUntil("Accessor body expected", TokenSet.orSet((TokenSet[])new TokenSet[]{ACCESSOR_FIRST_OR_PROPERTY_END, TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.LPAR, KtTokens.EQ})}));
            } else {
                KotlinParsing.closeDeclarationWithCommentBinders(getterOrSetter, KtNodeTypes.PROPERTY_ACCESSOR, false);
                return accessorKind;
            }
        }
        this.myBuilder.disableNewlines();
        this.expect(KtTokens.LPAR, "Expecting '('", TokenSet.create((IElementType[])new IElementType[]{KtTokens.RPAR, KtTokens.IDENTIFIER, KtTokens.COLON, KtTokens.LBRACE, KtTokens.EQ}));
        if (accessorKind == AccessorKind.SET) {
            PsiBuilder.Marker parameterList2 = this.mark();
            PsiBuilder.Marker setterParameter = this.mark();
            this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.COMMA, KtTokens.COLON, KtTokens.RPAR}));
            this.expect(KtTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create((IElementType[])new IElementType[]{KtTokens.RPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.EQ}));
            if (this.at(KtTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            }
            setterParameter.done(KtNodeTypes.VALUE_PARAMETER);
            parameterList2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
        }
        if (!this.at(KtTokens.RPAR)) {
            this.errorUntil("Expecting ')'", TokenSet.create((IElementType[])new IElementType[]{KtTokens.RPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.EQ, KtTokens.EOL_OR_SEMICOLON}));
        }
        if (this.at(KtTokens.RPAR)) {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseFunctionBody();
        KotlinParsing.closeDeclarationWithCommentBinders(getterOrSetter, KtNodeTypes.PROPERTY_ACCESSOR, false);
        return accessorKind;
    }

    IElementType parseFunction() {
        assert (this._at(KtTokens.FUN_KEYWORD));
        this.advance();
        if (this.at(KtTokens.RBRACE)) {
            this.error("Function body expected");
            return KtNodeTypes.FUN;
        }
        boolean typeParameterListOccurred = false;
        if (this.at(KtTokens.LT)) {
            this.parseTypeParameterList(TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACKET, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.LPAR}));
            typeParameterListOccurred = true;
        }
        this.myBuilder.disableJoiningComplexTokens();
        TokenSet functionNameFollow = TokenSet.create((IElementType[])new IElementType[]{KtTokens.LT, KtTokens.LPAR, KtTokens.RPAR, KtTokens.COLON, KtTokens.EQ});
        boolean receiverFound = this.parseReceiverType("function", functionNameFollow);
        this.parseFunctionOrPropertyName(receiverFound, "function", functionNameFollow, true);
        this.myBuilder.restoreJoiningComplexTokensState();
        TokenSet valueParametersFollow = TokenSet.create((IElementType[])new IElementType[]{KtTokens.EQ, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.SEMICOLON, KtTokens.RPAR});
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeParameterList(TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.LPAR}), valueParametersFollow}));
            KotlinParsing.errorIf(error, typeParameterListOccurred, "Only one type parameter list is allowed for a function");
            typeParameterListOccurred = true;
        }
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, false, valueParametersFollow);
        } else {
            this.error("Expecting '('");
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseTypeConstraintsGuarded(typeParameterListOccurred);
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
        } else if (this.at(KtTokens.EQ) || this.at(KtTokens.LBRACE)) {
            this.parseFunctionBody();
        }
        return KtNodeTypes.FUN;
    }

    private boolean parseReceiverType(String title, TokenSet nameFollow) {
        boolean receiverPresent;
        PsiBuilder.Marker annotations2 = this.mark();
        boolean annotationsPresent = this.parseAnnotations(AnnotationParsingMode.DEFAULT);
        int lastDot = this.lastDotAfterReceiver();
        boolean bl = receiverPresent = lastDot != -1;
        if (annotationsPresent) {
            if (receiverPresent) {
                annotations2.rollbackTo();
            } else {
                annotations2.error("Annotations are not allowed in this position");
            }
        } else {
            annotations2.drop();
        }
        if (!receiverPresent) {
            return false;
        }
        this.createTruncatedBuilder(lastDot).parseTypeRef();
        if (this.atSet(RECEIVER_TYPE_TERMINATORS)) {
            this.advance();
        } else {
            this.errorWithRecovery("Expecting '.' before a " + title + " name", nameFollow);
        }
        return true;
    }

    private int lastDotAfterReceiver() {
        if (this.at(KtTokens.LPAR)) {
            return this.matchTokenStreamPredicate(new FirstBefore(new AbstractKotlinParsing.AtSet(this, RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

                @Override
                public boolean matching(boolean topLevel) {
                    if (topLevel && KotlinParsing.this.definitelyOutOfReceiver()) {
                        return true;
                    }
                    return topLevel && !KotlinParsing.this.at(KtTokens.QUEST) && !KotlinParsing.this.at(KtTokens.LPAR) && !KotlinParsing.this.at(KtTokens.RPAR);
                }
            }));
        }
        return this.matchTokenStreamPredicate(new LastBefore(new AbstractKotlinParsing.AtSet(this, RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

            @Override
            public boolean matching(boolean topLevel) {
                if (topLevel && (KotlinParsing.this.definitelyOutOfReceiver() || KotlinParsing.this.at(KtTokens.LPAR))) {
                    return true;
                }
                if (topLevel && KotlinParsing.this.at(KtTokens.IDENTIFIER)) {
                    IElementType lookahead = KotlinParsing.this.lookahead(1);
                    return lookahead != KtTokens.LT && lookahead != KtTokens.DOT && lookahead != KtTokens.SAFE_ACCESS && lookahead != KtTokens.QUEST;
                }
                return false;
            }
        }));
    }

    private boolean definitelyOutOfReceiver() {
        return this.atSet(KtTokens.EQ, KtTokens.COLON, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.BY_KEYWORD) || this.atSet(TOP_LEVEL_DECLARATION_FIRST);
    }

    private void parseFunctionOrPropertyName(boolean receiverFound, String title, TokenSet nameFollow, boolean nameRequired) {
        if (nameRequired && this.atSet(nameFollow)) {
            return;
        }
        TokenSet recoverySet = TokenSet.orSet((TokenSet[])new TokenSet[]{nameFollow, TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.RBRACE}), TOP_LEVEL_DECLARATION_FIRST});
        if (!receiverFound) {
            this.expect(KtTokens.IDENTIFIER, "Expecting " + title + " name or receiver type", recoverySet);
        } else {
            this.expect(KtTokens.IDENTIFIER, "Expecting " + title + " name", recoverySet);
        }
    }

    private void parseFunctionBody() {
        if (this.at(KtTokens.LBRACE)) {
            this.parseBlock();
        } else if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(KtTokens.SEMICOLON);
        } else {
            this.error("Expecting function body");
        }
    }

    void parseBlock() {
        PsiBuilder.Marker block = this.mark();
        this.myBuilder.enableNewlines();
        this.expect(KtTokens.LBRACE, "Expecting '{' to open a block");
        this.myExpressionParsing.parseStatements();
        this.expect(KtTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        block.done((IElementType)KtNodeTypes.BLOCK);
    }

    void parseDelegationSpecifierList() {
        PsiBuilder.Marker list2 = this.mark();
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting a delegation specifier");
                continue;
            }
            this.parseDelegationSpecifier();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        list2.done(KtNodeTypes.SUPER_TYPE_LIST);
    }

    private void parseDelegationSpecifier() {
        PsiBuilder.Marker delegator = this.mark();
        PsiBuilder.Marker reference2 = this.mark();
        this.parseTypeRef();
        if (this.at(KtTokens.BY_KEYWORD)) {
            reference2.drop();
            this.advance();
            KotlinParsing.createForByClause((SemanticWhitespaceAwarePsiBuilder)this.myBuilder).myExpressionParsing.parseExpression();
            delegator.done(KtNodeTypes.DELEGATED_SUPER_TYPE_ENTRY);
        } else if (this.at(KtTokens.LPAR)) {
            reference2.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
            this.myExpressionParsing.parseValueArgumentList();
            delegator.done(KtNodeTypes.SUPER_TYPE_CALL_ENTRY);
        } else {
            reference2.drop();
            delegator.done(KtNodeTypes.SUPER_TYPE_ENTRY);
        }
    }

    private boolean parseTypeParameterList(TokenSet recoverySet) {
        boolean result2 = false;
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker list2 = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            while (true) {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting type parameter declaration");
                }
                this.parseTypeParameter();
                if (!this.at(KtTokens.COMMA)) break;
                this.advance();
            }
            this.expect(KtTokens.GT, "Missing '>'", recoverySet);
            this.myBuilder.restoreNewlinesState();
            result2 = true;
            list2.done(KtNodeTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    private void parseTypeConstraintsGuarded(boolean typeParameterListOccurred) {
        PsiBuilder.Marker error = this.mark();
        boolean constraints = this.parseTypeConstraints();
        KotlinParsing.errorIf(error, constraints && !typeParameterListOccurred, "Type constraints are not allowed when no type parameters declared");
    }

    private boolean parseTypeConstraints() {
        if (this.at(KtTokens.WHERE_KEYWORD)) {
            this.parseTypeConstraintList();
            return true;
        }
        return false;
    }

    private void parseTypeConstraintList() {
        assert (this._at(KtTokens.WHERE_KEYWORD));
        this.advance();
        PsiBuilder.Marker list2 = this.mark();
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Type constraint expected");
            }
            this.parseTypeConstraint();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        list2.done(KtNodeTypes.TYPE_CONSTRAINT_LIST);
    }

    private void parseTypeConstraint() {
        PsiBuilder.Marker constraint = this.mark();
        this.parseAnnotations(AnnotationParsingMode.DEFAULT);
        PsiBuilder.Marker reference2 = this.mark();
        if (this.expect(KtTokens.IDENTIFIER, "Expecting type parameter name", TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.COMMA, KtTokens.LBRACE, KtTokens.RBRACE}), TYPE_REF_FIRST}))) {
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
        } else {
            reference2.drop();
        }
        this.expect(KtTokens.COLON, "Expecting ':' before the upper bound", TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.RBRACE}), TYPE_REF_FIRST}));
        this.parseTypeRef();
        constraint.done(KtNodeTypes.TYPE_CONSTRAINT);
    }

    private void parseTypeParameter() {
        if (this.atSet(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.error("Type parameter declaration expected");
            return;
        }
        PsiBuilder.Marker mark = this.mark();
        this.parseModifierList(AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.GT, KtTokens.COMMA, KtTokens.COLON}));
        this.expect(KtTokens.IDENTIFIER, "Type parameter name expected", TokenSet.EMPTY);
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        mark.done(KtNodeTypes.TYPE_PARAMETER);
    }

    void parseTypeRef() {
        this.parseTypeRef(TokenSet.EMPTY);
    }

    void parseTypeRef(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.parseTypeRefContents(extraRecoverySet);
        typeRefMarker.done(KtNodeTypes.TYPE_REFERENCE);
    }

    private PsiBuilder.Marker parseTypeRefContents(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.mark();
        this.parseAnnotations(AnnotationParsingMode.DEFAULT);
        PsiBuilder.Marker typeElementMarker = this.mark();
        IElementType lookahead = this.lookahead(1);
        IElementType lookahead2 = this.lookahead(2);
        boolean typeBeforeDot = true;
        if (this.at(KtTokens.IDENTIFIER) && (lookahead != KtTokens.DOT || lookahead2 != KtTokens.IDENTIFIER) && lookahead != KtTokens.LT && this.at(KtTokens.DYNAMIC_KEYWORD)) {
            PsiBuilder.Marker dynamicType = this.mark();
            this.advance();
            dynamicType.done(KtNodeTypes.DYNAMIC_TYPE);
        } else if (this.at(KtTokens.IDENTIFIER) || this.at(KtTokens.PACKAGE_KEYWORD) || this.atParenthesizedMutableForPlatformTypes(0)) {
            this.parseUserType();
        } else if (this.at(KtTokens.LPAR)) {
            PsiBuilder.Marker functionOrParenthesizedType = this.mark();
            this.advance();
            this.parseTypeRefContents(TokenSet.EMPTY).drop();
            if (this.at(KtTokens.RPAR)) {
                this.advance();
                if (this.at(KtTokens.ARROW)) {
                    functionOrParenthesizedType.rollbackTo();
                    this.parseFunctionType();
                } else {
                    functionOrParenthesizedType.drop();
                }
            } else {
                functionOrParenthesizedType.rollbackTo();
                this.parseFunctionType();
            }
        } else {
            this.errorWithRecovery("Type expected", TokenSet.orSet((TokenSet[])new TokenSet[]{TOP_LEVEL_DECLARATION_FIRST, TokenSet.create((IElementType[])new IElementType[]{KtTokens.EQ, KtTokens.COMMA, KtTokens.GT, KtTokens.RBRACKET, KtTokens.DOT, KtTokens.RPAR, KtTokens.RBRACE, KtTokens.LBRACE, KtTokens.SEMICOLON}), extraRecoverySet}));
            typeBeforeDot = false;
        }
        this.myBuilder.disableJoiningComplexTokens();
        typeElementMarker = this.parseNullableTypeSuffix(typeElementMarker);
        this.myBuilder.restoreJoiningComplexTokensState();
        if (typeBeforeDot && this.at(KtTokens.DOT)) {
            PsiBuilder.Marker functionType = typeRefMarker.precede();
            PsiBuilder.Marker receiverType = typeRefMarker.precede();
            typeRefMarker.done(KtNodeTypes.TYPE_REFERENCE);
            receiverType.done(KtNodeTypes.FUNCTION_TYPE_RECEIVER);
            this.advance();
            if (this.at(KtTokens.LPAR)) {
                this.parseFunctionTypeContents().drop();
            } else {
                this.error("Expecting function type");
            }
            typeRefMarker = functionType.precede();
            functionType.done(KtNodeTypes.FUNCTION_TYPE);
        }
        typeElementMarker.drop();
        return typeRefMarker;
    }

    @NotNull
    PsiBuilder.Marker parseNullableTypeSuffix(@NotNull PsiBuilder.Marker typeElementMarker) {
        if (typeElementMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElementMarker", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseNullableTypeSuffix"));
        }
        while (this.at(KtTokens.QUEST) && this.myBuilder.rawLookup(1) != KtTokens.COLON) {
            PsiBuilder.Marker precede = typeElementMarker.precede();
            this.advance();
            typeElementMarker.done(KtNodeTypes.NULLABLE_TYPE);
            typeElementMarker = precede;
        }
        PsiBuilder.Marker marker = typeElementMarker;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParsing", "parseNullableTypeSuffix"));
        }
        return marker;
    }

    void parseUserType() {
        PsiBuilder.Marker userType = this.mark();
        if (this.at(KtTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.expect(KtTokens.DOT, "Expecting '.'", TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.LBRACE, KtTokens.RBRACE}));
        }
        PsiBuilder.Marker reference2 = this.mark();
        while (true) {
            this.recoverOnParenthesizedWordForPlatformTypes(0, "Mutable", true);
            if (!this.expect(KtTokens.IDENTIFIER, "Expecting type name", TokenSet.orSet((TokenSet[])new TokenSet[]{KotlinExpressionParsing.EXPRESSION_FIRST, KotlinExpressionParsing.EXPRESSION_FOLLOW, DECLARATION_FIRST}))) {
                reference2.drop();
                break;
            }
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            this.parseTypeArgumentList();
            this.recoverOnPlatformTypeSuffix();
            if (!this.at(KtTokens.DOT) || this.lookahead(1) == KtTokens.LPAR && !this.atParenthesizedMutableForPlatformTypes(1)) break;
            PsiBuilder.Marker precede = userType.precede();
            userType.done(KtNodeTypes.USER_TYPE);
            userType = precede;
            this.advance();
            reference2 = this.mark();
        }
        userType.done(KtNodeTypes.USER_TYPE);
    }

    private boolean atParenthesizedMutableForPlatformTypes(int offset2) {
        return this.recoverOnParenthesizedWordForPlatformTypes(offset2, "Mutable", false);
    }

    private boolean recoverOnParenthesizedWordForPlatformTypes(int offset2, String word, boolean consume2) {
        if (this.lookahead(offset2) == KtTokens.LPAR && this.lookahead(offset2 + 1) == KtTokens.IDENTIFIER && this.lookahead(offset2 + 2) == KtTokens.RPAR && this.lookahead(offset2 + 3) == KtTokens.IDENTIFIER) {
            PsiBuilder.Marker error = this.mark();
            this.advance(offset2);
            this.advance();
            if (!word.equals(this.myBuilder.getTokenText())) {
                error.rollbackTo();
                return false;
            }
            this.advance();
            this.advance();
            if (consume2) {
                error.error("Unexpected tokens");
            } else {
                error.rollbackTo();
            }
            return true;
        }
        return false;
    }

    private void recoverOnPlatformTypeSuffix() {
        if (this.at(KtTokens.EXCL)) {
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error("Unexpected token");
        }
    }

    private PsiBuilder.Marker parseTypeArgumentList() {
        if (!this.at(KtTokens.LT)) {
            return null;
        }
        PsiBuilder.Marker list2 = this.mark();
        this.tryParseTypeArgumentList(TokenSet.EMPTY);
        list2.done(KtNodeTypes.TYPE_ARGUMENT_LIST);
        return list2;
    }

    boolean tryParseTypeArgumentList(TokenSet extraRecoverySet) {
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            PsiBuilder.Marker projection = this.mark();
            this.recoverOnParenthesizedWordForPlatformTypes(0, "out", true);
            this.parseModifierList(AnnotationParsingMode.NO_ANNOTATIONS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.COMMA, KtTokens.COLON, KtTokens.GT}));
            if (this.at(KtTokens.MUL)) {
                this.advance();
            } else {
                this.parseTypeRef(extraRecoverySet);
            }
            projection.done(KtNodeTypes.TYPE_PROJECTION);
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        boolean atGT = this.at(KtTokens.GT);
        if (!atGT) {
            this.error("Expecting a '>'");
        } else {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        return atGT;
    }

    private void parseFunctionType() {
        this.parseFunctionTypeContents().done(KtNodeTypes.FUNCTION_TYPE);
    }

    private PsiBuilder.Marker parseFunctionTypeContents() {
        assert (this._at(KtTokens.LPAR)) : this.tt();
        PsiBuilder.Marker functionType = this.mark();
        this.parseValueParameterList(true, true, TokenSet.EMPTY);
        this.expect(KtTokens.ARROW, "Expecting '->' to specify return type of a function type", TYPE_REF_FIRST);
        this.parseTypeRef();
        return functionType;
    }

    void parseValueParameterList(boolean isFunctionTypeContents, boolean typeRequired, TokenSet recoverySet) {
        assert (this._at(KtTokens.LPAR));
        PsiBuilder.Marker parameters2 = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.at(KtTokens.RPAR) && !this.atSet(recoverySet)) {
            while (true) {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a parameter declaration");
                } else if (this.at(KtTokens.RPAR)) {
                    this.error("Expecting a parameter declaration");
                    break;
                }
                if (isFunctionTypeContents) {
                    if (!this.tryParseValueParameter(typeRequired)) {
                        PsiBuilder.Marker valueParameter = this.mark();
                        this.parseModifierList(AnnotationParsingMode.DEFAULT, NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER);
                        this.parseTypeRef();
                        KotlinParsing.closeDeclarationWithCommentBinders(valueParameter, KtNodeTypes.VALUE_PARAMETER, false);
                    }
                } else {
                    this.parseValueParameter(typeRequired);
                }
                if (this.at(KtTokens.COMMA)) {
                    this.advance();
                    continue;
                }
                if (!this.at(KtTokens.RPAR)) {
                    this.error("Expecting comma or ')'");
                }
                if (!this.atSet(isFunctionTypeContents ? LAMBDA_VALUE_PARAMETER_FIRST : VALUE_PARAMETER_FIRST)) break;
            }
        }
        this.expect(KtTokens.RPAR, "Expecting ')'", recoverySet);
        this.myBuilder.restoreNewlinesState();
        parameters2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean tryParseValueParameter(boolean typeRequired) {
        return this.parseValueParameter(true, typeRequired);
    }

    public void parseValueParameter(boolean typeRequired) {
        this.parseValueParameter(false, typeRequired);
    }

    private boolean parseValueParameter(boolean rollbackOnFailure, boolean typeRequired) {
        PsiBuilder.Marker parameter = this.mark();
        this.parseModifierList(AnnotationParsingMode.DEFAULT, NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER);
        if (this.at(KtTokens.VAR_KEYWORD) || this.at(KtTokens.VAL_KEYWORD)) {
            this.advance();
        }
        if (!this.parseFunctionParameterRest(typeRequired) && rollbackOnFailure) {
            parameter.rollbackTo();
            return false;
        }
        KotlinParsing.closeDeclarationWithCommentBinders(parameter, KtNodeTypes.VALUE_PARAMETER, false);
        return true;
    }

    private boolean parseFunctionParameterRest(boolean typeRequired) {
        boolean noErrors = true;
        if (this.at(KtTokens.IDENTIFIER) && this.lookahead(1) == KtTokens.LT || this.at(KtTokens.COLON)) {
            this.error("Parameter name expected");
            if (this.at(KtTokens.COLON)) {
                this.advance();
            } else {
                noErrors = false;
            }
            this.parseTypeRef();
        } else {
            this.expect(KtTokens.IDENTIFIER, "Parameter name expected", PARAMETER_NAME_RECOVERY_SET);
            if (this.at(KtTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            } else if (typeRequired) {
                this.errorWithRecovery("Parameters must have type annotation", PARAMETER_NAME_RECOVERY_SET);
                noErrors = false;
            }
        }
        if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
        }
        return noErrors;
    }

    @Override
    protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return KotlinParsing.createForTopLevel(builder);
    }

    static {
        for (IElementType softKeyword : KtTokens.MODIFIER_KEYWORDS.getTypes()) {
            MODIFIER_KEYWORD_MAP.put(((KtKeywordToken)softKeyword).getValue(), softKeyword);
        }
        TOP_LEVEL_DECLARATION_FIRST = TokenSet.create((IElementType[])new IElementType[]{KtTokens.TYPE_ALIAS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.PACKAGE_KEYWORD});
        DECLARATION_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{TOP_LEVEL_DECLARATION_FIRST, TokenSet.create((IElementType[])new IElementType[]{KtTokens.INIT_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.CONSTRUCTOR_KEYWORD})});
        CLASS_NAME_RECOVERY_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.LT, KtTokens.LPAR, KtTokens.COLON, KtTokens.LBRACE}), TOP_LEVEL_DECLARATION_FIRST});
        TYPE_PARAMETER_GT_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.WHERE_KEYWORD, KtTokens.LPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.GT});
        PARAMETER_NAME_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.EQ, KtTokens.COMMA, KtTokens.RPAR});
        PACKAGE_NAME_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.EOL_OR_SEMICOLON});
        IMPORT_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.AS_KEYWORD, KtTokens.DOT, KtTokens.EOL_OR_SEMICOLON});
        TYPE_REF_FIRST = TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACKET, KtTokens.IDENTIFIER, KtTokens.LPAR, KtTokens.HASH, KtTokens.DYNAMIC_KEYWORD});
        RECEIVER_TYPE_TERMINATORS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
        VALUE_PARAMETER_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.LBRACKET, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD}), KtTokens.MODIFIER_KEYWORDS});
        LAMBDA_VALUE_PARAMETER_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.LBRACKET}), KtTokens.MODIFIER_KEYWORDS});
        SOFT_KEYWORDS_AT_MEMBER_START = TokenSet.create((IElementType[])new IElementType[]{KtTokens.CONSTRUCTOR_KEYWORD, KtTokens.INIT_KEYWORD});
        ANNOTATION_TARGETS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.FILE_KEYWORD, KtTokens.FIELD_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.PROPERTY_KEYWORD, KtTokens.RECEIVER_KEYWORD, KtTokens.PARAM_KEYWORD, KtTokens.SETPARAM_KEYWORD, KtTokens.DELEGATE_KEYWORD});
        NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER = TokenSet.create((IElementType[])new IElementType[]{KtTokens.COMMA, KtTokens.COLON, KtTokens.EQ, KtTokens.RPAR});
    }

    static enum AnnotationParsingMode {
        DEFAULT(false, false, true),
        FILE_ANNOTATIONS_BEFORE_PACKAGE(false, true, true),
        FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED(false, true, true),
        IN_ANNOTATION_LIST(true, false, true),
        NO_ANNOTATIONS(false, false, false);

        boolean allowShortAnnotations;
        boolean isFileAnnotationParsingMode;
        boolean allowAnnotations;

        private AnnotationParsingMode(boolean allowShortAnnotations, boolean isFileAnnotationParsingMode, boolean allowAnnotations) {
            this.allowShortAnnotations = allowShortAnnotations;
            this.isFileAnnotationParsingMode = isFileAnnotationParsingMode;
            this.allowAnnotations = allowAnnotations;
        }
    }

    static class ModifierDetector
    implements Consumer<IElementType> {
        private boolean enumDetected = false;
        private boolean defaultDetected = false;

        ModifierDetector() {
        }

        @Override
        public void consume(IElementType item) {
            if (item == KtTokens.ENUM_KEYWORD) {
                this.enumDetected = true;
            } else if (item == KtTokens.COMPANION_KEYWORD) {
                this.defaultDetected = true;
            }
        }

        public boolean isEnumDetected() {
            return this.enumDetected;
        }

        public boolean isDefaultDetected() {
            return this.defaultDetected;
        }
    }

    private static enum AccessorKind {
        GET,
        SET;

    }

    private static enum ParseEnumEntryResult {
        FAILED,
        NO_DELIMITER,
        COMMA_DELIMITER,
        SEMICOLON_DELIMITER;

    }

    public static enum DeclarationParsingMode {
        TOP_LEVEL,
        CLASS_MEMBER,
        LOCAL;

    }

    public static enum NameParsingMode {
        REQUIRED,
        ALLOWED,
        PROHIBITED;

    }
}

