/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtCallExpression
extends KtExpressionImpl
implements KtCallElement,
KtReferenceExpression {
    public KtCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtCallExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtCallExpression", "accept"));
        }
        return visitor2.visitCallExpression(this, data);
    }

    @Override
    @Nullable
    public KtExpression getCalleeExpression() {
        return (KtExpression)this.findChildByClass(KtExpression.class);
    }

    @Override
    @Nullable
    public KtValueArgumentList getValueArgumentList() {
        return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public KtTypeArgumentList getTypeArgumentList() {
        return (KtTypeArgumentList)this.findChildByType(KtNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<KtLambdaArgument> getLambdaArguments() {
        List list2 = this.findChildrenByType(KtNodeTypes.LAMBDA_ARGUMENT);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtCallExpression", "getLambdaArguments"));
        }
        return list2;
    }

    @NotNull
    public List<KtValueArgument> getValueArguments() {
        KtValueArgumentList list2 = this.getValueArgumentList();
        List<KtValueArgument> valueArgumentsInParentheses = list2 != null ? list2.getArguments() : Collections.emptyList();
        List<KtLambdaArgument> functionLiteralArguments = this.getLambdaArguments();
        if (functionLiteralArguments.isEmpty()) {
            List<KtValueArgument> list3 = valueArgumentsInParentheses;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtCallExpression", "getValueArguments"));
            }
            return list3;
        }
        ArrayList allValueArguments2 = Lists.newArrayList();
        allValueArguments2.addAll(valueArgumentsInParentheses);
        allValueArguments2.addAll(functionLiteralArguments);
        ArrayList arrayList = allValueArguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtCallExpression", "getValueArguments"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList list2 = this.getTypeArgumentList();
        List<KtTypeProjection> list3 = list2 != null ? list2.getArguments() : Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtCallExpression", "getTypeArguments"));
        }
        return list3;
    }
}

