/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"qualifiedNameForSourceCode", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "qualifierName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderFqName", "pathSegments", "", "Lorg/jetbrains/kotlin/name/Name;", "render", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "shouldBeEscaped", "", "descriptors"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\tH\u0002\u00a8\u0006\u000f"}, strings={"qualifiedNameForSourceCode", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "qualifierName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderFqName", "pathSegments", "", "Lorg/jetbrains/kotlin/name/Name;", "render", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "shouldBeEscaped", "", "descriptors"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String qualifiedNameForSourceCode(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String nameString = RenderingUtilsKt.render(descriptor2.getName());
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return nameString;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        String qualifier2 = RenderingUtilsKt.qualifierName(declarationDescriptor);
        return qualifier2 != null && Intrinsics.areEqual((Object)qualifier2, (Object)"") ^ true ? qualifier2 + "." + nameString : nameString;
    }

    private static final String qualifierName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? RenderingUtilsKt.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe()) : (String)null);
    }

    @NotNull
    public static final String render(Name $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (RenderingUtilsKt.shouldBeEscaped($receiver)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"asString()");
            string = stringBuilder.append(CharsKt.plus((char)'`', (String)string2)).append('`').toString();
        } else {
            String string3 = $receiver.asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $receiver) {
        boolean bl;
        if ($receiver.isSpecial()) {
            return false;
        }
        String string = $receiver.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        CharSequence $receiver$iv = string;
        CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
        do {
            if (!charIterator.hasNext()) return false;
            char element$iv = charIterator.nextChar();
            char it = element$iv;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(FqNameUnsafe $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list2 = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list2);
    }

    @NotNull
    public static final String render(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list2 = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        for (Name element2 : pathSegments) {
            if ($receiver.length() > 0) {
                $receiver.append(".");
            }
            $receiver.append(RenderingUtilsKt.render(element2));
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

