/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "containsArrayOfNothing", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
@KotlinClass(version={1, 1, 0}, data={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "containsArrayOfNothing", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class CallReturnsArrayOfNothingChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KotlinType returnType2 = resolvedCall.getResultingDescriptor().getReturnType();
        if (this.containsArrayOfNothing(returnType2)) {
            KtElement callElement2 = resolvedCall.getCall().getCallElement();
            ParametrizedDiagnostic<PsiElement> diagnostic = Errors.UNSUPPORTED.on((PsiElement)callElement2, "Array<Nothing> in return type is illegal");
            context.trace.report(diagnostic);
        }
    }

    private final boolean containsArrayOfNothing(KotlinType $receiver) {
        boolean bl;
        block3: {
            if ($receiver == null || $receiver instanceof DeferredType && ((DeferredType)$receiver).isComputing()) {
                return false;
            }
            if (TypeUtilsKt.isArrayOfNothing($receiver)) {
                return true;
            }
            Iterable $receiver$iv = $receiver.getArguments();
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(!it.isStarProjection() && this.containsArrayOfNothing(it.getType()))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }
}

