/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006 \u0017*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00180\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "assignedNames", "Lcom/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "currentDeclaration", "hasWriters", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitDeclaration", "declaration", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "writers", "", "kotlin.jvm.PlatformType", "", "frontend"})
@KotlinClass(version={1, 1, 0}, data={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006 \u0017*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00180\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "assignedNames", "Lcom/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "currentDeclaration", "hasWriters", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitDeclaration", "declaration", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "writers", "", "kotlin.jvm.PlatformType", "", "frontend"})
public abstract class AssignedVariablesSearcher
extends KtTreeVisitorVoid {
    private final SetMultimap<Name, KtDeclaration> assignedNames;
    private KtDeclaration currentDeclaration;

    public Set<KtDeclaration> writers(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        return this.assignedNames.get((Object)variableDescriptor.getName());
    }

    public final boolean hasWriters(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        return CollectionsKt.isNotEmpty((Collection)this.writers(variableDescriptor));
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        KtDeclaration previous = this.currentDeclaration;
        if (declaration instanceof KtDeclarationWithBody || declaration instanceof KtClassOrObject) {
            this.currentDeclaration = declaration;
        } else if (declaration instanceof KtAnonymousInitializer) {
            PsiElement psiElement2 = ((KtAnonymousInitializer)declaration).getParent().getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            this.currentDeclaration = (KtDeclaration)psiElement2;
        }
        super.visitDeclaration(declaration);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkParameterIsNotNull((Object)lambdaExpression, (String)"lambdaExpression");
        KtDeclaration previous = this.currentDeclaration;
        this.currentDeclaration = lambdaExpression.getFunctionLiteral();
        super.visitLambdaExpression(lambdaExpression);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
        KtExpression left;
        Intrinsics.checkParameterIsNotNull((Object)binaryExpression, (String)"binaryExpression");
        if (binaryExpression.getOperationToken() == KtTokens.EQ && (left = KtPsiUtil.deparenthesize(binaryExpression.getLeft())) instanceof KtNameReferenceExpression) {
            this.assignedNames.put((Object)((KtNameReferenceExpression)left).getReferencedNameAsName(), (Object)this.currentDeclaration);
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public AssignedVariablesSearcher() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMultimap, (String)"LinkedHashMultimap.create()");
        this.assignedNames = (SetMultimap)linkedHashMultimap;
    }
}

