/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.PathEditBase;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/jgit/dirCache/AddFile;", "Lorg/jetbrains/jgit/dirCache/PathEditBase;", "pathString", "", "(Ljava/lang/String;)V", "apply", "", "entry", "Lorg/eclipse/jgit/dircache/DirCacheEntry;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "settings-repository"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/jgit/dirCache/AddFile;", "Lorg/jetbrains/jgit/dirCache/PathEditBase;", "pathString", "", "(Ljava/lang/String;)V", "apply", "", "entry", "Lorg/eclipse/jgit/dircache/DirCacheEntry;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "settings-repository"})
public final class AddFile
extends PathEditBase {
    private final String pathString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NotNull DirCacheEntry entry, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        File file = new File(repository2.getWorkTree(), this.pathString);
        entry.setFileMode(FileMode.REGULAR_FILE);
        long length = file.length();
        entry.setLength(length);
        entry.setLastModified(file.lastModified());
        FileInputStream input = new FileInputStream(file);
        ObjectInserter inserter = repository2.newObjectInserter();
        try {
            entry.setObjectId((AnyObjectId)inserter.insert(3, length, (InputStream)input));
            inserter.flush();
        }
        finally {
            inserter.close();
            input.close();
        }
    }

    public AddFile(@NotNull String pathString) {
        Intrinsics.checkParameterIsNotNull((Object)pathString, (String)"pathString");
        super(DirCacheEditorKt.access$encodePath(pathString));
        this.pathString = pathString;
    }
}

