/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import gnu.trove.THashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibrary;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0016J$\u0010\u000f\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/keychain/OsXCredentialsStore;", "Lorg/jetbrains/keychain/CredentialsStore;", "serviceName", "", "(Ljava/lang/String;)V", "accountToCredentials", "Lgnu/trove/THashMap;", "Lorg/jetbrains/keychain/Credentials;", "", "get", "host", "sshKeyFile", "getServiceName", "reset", "", "save", "credentials", "Companion", "settings-repository"})
@KotlinClass(version={1, 1, 0}, data={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0016J$\u0010\u000f\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/keychain/OsXCredentialsStore;", "Lorg/jetbrains/keychain/CredentialsStore;", "serviceName", "", "(Ljava/lang/String;)V", "accountToCredentials", "Lgnu/trove/THashMap;", "Lorg/jetbrains/keychain/Credentials;", "", "get", "host", "sshKeyFile", "getServiceName", "reset", "", "save", "credentials", "Companion", "settings-repository"})
public final class OsXCredentialsStore
implements CredentialsStore {
    private final byte[] serviceName;
    private final THashMap<String, Credentials> accountToCredentials;
    @NotNull
    private static final byte[] SSH;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        if (host == null) {
            return null;
        }
        String string = sshKeyFile;
        if (string == null) {
            string = host;
        }
        String accountName = string;
        Credentials credentials = (Credentials)this.accountToCredentials.get((Object)accountName);
        if (credentials != null) {
            return credentials;
        }
        String string2 = OSXKeychainLibrary.Companion.findGenericPassword(this.getServiceName(sshKeyFile), accountName);
        if (string2 == null) {
            return null;
        }
        String data = string2;
        if (sshKeyFile == null) {
            int separatorIndex = StringsKt.indexOf$default((CharSequence)data, (char)'@', (int)0, (boolean)false, (int)6, null);
            if (separatorIndex <= 0) return null;
            String username = PasswordUtil.decodePassword((String)StringsKt.substring((String)data, (int)0, (int)separatorIndex));
            String password = PasswordUtil.decodePassword((String)StringsKt.substring((String)data, (int)(separatorIndex + 1)));
            credentials = new Credentials(username, password);
        } else {
            credentials = new Credentials(sshKeyFile, data);
        }
        MapsKt.set((Map)((Map)this.accountToCredentials), (Object)accountName, (Object)credentials);
        return credentials;
    }

    private final byte[] getServiceName(String sshKeyFile) {
        return sshKeyFile == null ? this.serviceName : Companion.getSSH();
    }

    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        String string;
        String accountName;
        Credentials oldCredentials;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string2 = sshKeyFile;
        if (string2 == null && (string2 = host) == null) {
            Intrinsics.throwNpe();
        }
        if (credentials.equals(oldCredentials = (Credentials)this.accountToCredentials.put((Object)(accountName = string2), (Object)credentials))) {
            return;
        }
        if (sshKeyFile == null) {
            string = PasswordUtil.encodePassword((String)credentials.getId()) + "@" + PasswordUtil.encodePassword((String)credentials.getToken());
        } else {
            string = credentials.getToken();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String data = string;
        OSXKeychainLibrary.Companion.saveGenericPassword(this.getServiceName(sshKeyFile), accountName, data);
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.accountToCredentials.remove((Object)host) != null) {
            OSXKeychainLibrary.Companion.deleteGenericPassword(this.serviceName, host);
        }
    }

    public OsXCredentialsStore(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        this.serviceName = StringsKt.toByteArray$default((String)serviceName, null, (int)1, null);
        this.accountToCredentials = new THashMap();
    }

    static {
        Companion = new Companion(null);
        SSH = StringsKt.toByteArray$default((String)"SSH", null, (int)1, null);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/keychain/OsXCredentialsStore$Companion;", "", "()V", "SSH", "", "getSSH", "()[B", "settings-repository"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, strings={"Lorg/jetbrains/keychain/OsXCredentialsStore$Companion;", "", "()V", "SSH", "", "getSSH", "()[B", "settings-repository"})
    public static final class Companion {
        @NotNull
        public final byte[] getSSH() {
            return SSH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

